/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;

public class SubTaskTest
extends PluggableProcessEngineTestCase {
    public void testSubTask() {
        Task gonzoTask = this.taskService.newTask();
        gonzoTask.setName("gonzoTask");
        this.taskService.saveTask(gonzoTask);
        Task subTaskOne = this.taskService.newTask();
        subTaskOne.setName("subtask one");
        String gonzoTaskId = gonzoTask.getId();
        subTaskOne.setParentTaskId(gonzoTaskId);
        this.taskService.saveTask(subTaskOne);
        Task subTaskTwo = this.taskService.newTask();
        subTaskTwo.setName("subtask two");
        subTaskTwo.setParentTaskId(gonzoTaskId);
        this.taskService.saveTask(subTaskTwo);
        String subTaskId = subTaskOne.getId();
        SubTaskTest.assertTrue((boolean)this.taskService.getSubTasks(subTaskId).isEmpty());
        SubTaskTest.assertTrue((boolean)this.historyService.createHistoricTaskInstanceQuery().taskParentTaskId(subTaskId).list().isEmpty());
        List subTasks = this.taskService.getSubTasks(gonzoTaskId);
        HashSet<String> subTaskNames = new HashSet<String>();
        for (Task subTask : subTasks) {
            subTaskNames.add(subTask.getName());
        }
        if (this.processEngineConfiguration.getHistoryLevel() >= 2) {
            HashSet<String> expectedSubTaskNames = new HashSet<String>();
            expectedSubTaskNames.add("subtask one");
            expectedSubTaskNames.add("subtask two");
            SubTaskTest.assertEquals(expectedSubTaskNames, subTaskNames);
            List historicSubTasks = this.historyService.createHistoricTaskInstanceQuery().taskParentTaskId(gonzoTaskId).list();
            subTaskNames = new HashSet();
            for (HistoricTaskInstance historicSubTask : historicSubTasks) {
                subTaskNames.add(historicSubTask.getName());
            }
            SubTaskTest.assertEquals(expectedSubTaskNames, subTaskNames);
        }
        this.taskService.deleteTask(gonzoTaskId, true);
    }
}

