/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.NativeTaskQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class TaskQueryTest
extends PluggableProcessEngineTestCase {
    private List<String> taskIds;

    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.createMembership("kermit", "management");
        this.identityService.createMembership("kermit", "accountancy");
        this.identityService.createMembership("fozzie", "management");
        this.taskIds = this.generateTestTasks();
    }

    public void tearDown() throws Exception {
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteUser("kermit");
        this.taskService.deleteTasks(this.taskIds, true);
    }

    public void tesBasicTaskPropertiesNotNull() {
        Task task = (Task)this.taskService.createTaskQuery().taskId(this.taskIds.get(0)).singleResult();
        TaskQueryTest.assertNotNull((Object)task.getDescription());
        TaskQueryTest.assertNotNull((Object)task.getId());
        TaskQueryTest.assertNotNull((Object)task.getName());
        TaskQueryTest.assertNotNull((Object)task.getCreateTime());
    }

    public void testQueryNoCriteria() {
        TaskQuery query = this.taskService.createTaskQuery();
        TaskQueryTest.assertEquals((long)12L, (long)query.count());
        TaskQueryTest.assertEquals((int)12, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByTaskId() {
        TaskQuery query = this.taskService.createTaskQuery().taskId(this.taskIds.get(0));
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidTaskId() {
        TaskQuery query = this.taskService.createTaskQuery().taskId("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidName() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskName(null).singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskNameLike("gonzo%");
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidNameLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("1");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskName(null).singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDescription() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescription("testTask description");
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidDescription() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescription("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskDescription(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDescriptionLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescriptionLike("%gonzo%");
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidDescriptionLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescriptionLike("invalid");
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskDescriptionLike(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByPriority() {
        TaskQuery query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)2, (int)query.list().size());
        TaskQueryTest.assertEquals((long)2L, (long)query.count());
        try {
            query.singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(100));
        TaskQueryTest.assertNull((Object)query.singleResult());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(50));
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMaxPriority(Integer.valueOf(10));
        TaskQueryTest.assertEquals((int)9, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskMaxPriority(Integer.valueOf(3));
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
    }

    public void testQueryByInvalidPriority() {
        try {
            this.taskService.createTaskQuery().taskPriority(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByAssignee() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssignee("gonzo");
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("kermit");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByAssigneeLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeLike("gonz%");
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        TaskQueryTest.assertNotNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("gonz");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        TaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByNullAssignee() {
        try {
            this.taskService.createTaskQuery().taskAssignee(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByUnassigned() {
        TaskQuery query = this.taskService.createTaskQuery().taskUnassigned();
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
    }

    public void testQueryByCandidateUser() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateUser("kermit");
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateUser("fozzie");
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullCandidateUser() {
        try {
            this.taskService.createTaskQuery().taskCandidateUser(null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCandidateGroup() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroup("management");
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateGroup("sales");
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    public void testQueryByNullCandidateGroup() {
        try {
            this.taskService.createTaskQuery().taskCandidateGroup(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCandidateGroupIn() {
        List<String> groups = Arrays.asList("management", "accountancy");
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups);
        TaskQueryTest.assertEquals((long)5L, (long)query.count());
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
        try {
            query.singleResult();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        groups = Arrays.asList("management", "accountancy", "sales", "unexising");
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups);
        TaskQueryTest.assertEquals((long)5L, (long)query.count());
        TaskQueryTest.assertEquals((int)5, (int)query.list().size());
    }

    public void testQueryByNullCandidateGroupIn() {
        try {
            this.taskService.createTaskQuery().taskCandidateGroupIn(null).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskCandidateGroupIn(new ArrayList()).list();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDelegationState() {
        TaskQuery query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)12L, (long)query.count());
        TaskQueryTest.assertEquals((int)12, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        String taskId = ((Task)this.taskService.createTaskQuery().taskAssignee("gonzo").singleResult()).getId();
        this.taskService.delegateTask(taskId, "kermit");
        query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        this.taskService.resolveTask(taskId);
        query = this.taskService.createTaskQuery().taskDelegationState(null);
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        TaskQueryTest.assertEquals((long)1L, (long)query.count());
        TaskQueryTest.assertEquals((int)1, (int)query.list().size());
    }

    public void testQueryCreatedOn() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date createTime = sdf.parse("01/01/2001 01:01:01.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedOn(createTime);
        TaskQueryTest.assertEquals((long)6L, (long)query.count());
        TaskQueryTest.assertEquals((int)6, (int)query.list().size());
    }

    public void testQueryCreatedBefore() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date before = sdf.parse("03/02/2002 02:02:02.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedBefore(before);
        TaskQueryTest.assertEquals((long)7L, (long)query.count());
        TaskQueryTest.assertEquals((int)7, (int)query.list().size());
        before = sdf.parse("01/01/2001 01:01:01.000");
        query = this.taskService.createTaskQuery().taskCreatedBefore(before);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    public void testQueryCreatedAfter() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date after = sdf.parse("03/03/2003 03:03:03.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedAfter(after);
        TaskQueryTest.assertEquals((long)3L, (long)query.count());
        TaskQueryTest.assertEquals((int)3, (int)query.list().size());
        after = sdf.parse("05/05/2005 05:05:05.000");
        query = this.taskService.createTaskQuery().taskCreatedAfter(after);
        TaskQueryTest.assertEquals((long)0L, (long)query.count());
        TaskQueryTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    public void testTaskDefinitionKey() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = this.taskService.createTaskQuery().taskDefinitionKey("taskKey1").list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKey("unexistingKey").count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    public void testTaskDefinitionKeyLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("taskKey1%").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)2, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey1", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(1)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("%123").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("%Key12%").orderByTaskName().asc()).list();
        TaskQueryTest.assertNotNull((Object)tasks);
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"taskKey123", (String)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKeyLike("%unexistingKey%").count();
        TaskQueryTest.assertEquals((long)0L, (long)count);
    }

    @Deployment
    public void testTaskVariableValueEquals() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("unexistingVar", (Object)"value").count());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("booleanVar", (Object)false).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    public void testTaskVariableValueLike() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal%").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVal%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVar").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.taskService.createTaskQuery().taskVariableValueLike("stringVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    public void testTaskVariableValueCompare() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment
    public void testProcessVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nullVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)928374L).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", null).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("longVar", (Object)999L).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("shortVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("integerVar", (Object)999).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("stringVar", (Object)"999").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("booleanVar", (Object)false).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("longVar", (Object)928374L).count());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)"theValue");
        this.taskService.setVariableLocal(task.getId(), "longVar", (Object)928374L);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).taskVariableValueEquals("taskVar", (Object)"theValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).taskVariableValueEquals("longVar", (Object)928374L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    public void testProcessVariableValueLike() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal%").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngValue").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVal%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVar").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVar%").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.taskService.createTaskQuery().processVariableValueLike("stringVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    public void testProcessVariableValueCompare() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928373).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"aa").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThan("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nullVar", null).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThan("nullVar", (Object)true).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionId() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionId(processInstance.getProcessDefinitionId()).list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionId("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionKey() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionKey("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionName() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionName("The One Task Process").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionName("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessDefinitionNameLike() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionNameLike("The One Task%").list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)processInstance.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionNameLike("The One Task").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionNameLike("The Other Task%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessInstanceBusinessKey() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processDefinitionName("The One Task Process").processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKey("NON-EXISTING").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testProcessInstanceBusinessKeyLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processDefinitionName("The One Task Process").processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUSINESS-KEY%").list().size());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUSINESS-KEY").count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUZINESS-KEY%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueDate() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setDueDate(dueDate);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueDate(dueDate).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueDate(otherDate.getTime()).count());
        Calendar priorDate = Calendar.getInstance();
        priorDate.setTime(dueDate);
        priorDate.roll(1, -1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(priorDate.getTime()).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueBefore(otherDate.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueBefore() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Calendar dueDateCal = Calendar.getInstance();
        task.setDueDate(dueDateCal.getTime());
        this.taskService.saveTask(task);
        Calendar oneHourAgo = Calendar.getInstance();
        oneHourAgo.setTime(dueDateCal.getTime());
        oneHourAgo.add(10, -1);
        Calendar oneHourLater = Calendar.getInstance();
        oneHourLater.setTime(dueDateCal.getTime());
        oneHourLater.add(10, 1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueBefore(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourAgo.getTime()).count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(null);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourAgo.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testTaskDueAfter() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Calendar dueDateCal = Calendar.getInstance();
        task.setDueDate(dueDateCal.getTime());
        this.taskService.saveTask(task);
        Calendar oneHourAgo = Calendar.getInstance();
        oneHourAgo.setTime(dueDateCal.getTime());
        oneHourAgo.add(10, -1);
        Calendar oneHourLater = Calendar.getInstance();
        oneHourLater.setTime(dueDateCal.getTime());
        oneHourLater.add(10, 1);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater.getTime()).count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(null);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testFollowUpDate() throws Exception {
        Calendar otherDate = Calendar.getInstance();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date followUpDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setFollowUpDate(followUpDate);
        this.taskService.saveTask(task);
        TaskQueryTest.assertEquals((Object)followUpDate, (Object)((Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpDate(followUpDate).count());
        otherDate.setTime(followUpDate);
        otherDate.add(1, 1);
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpBefore(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpAfter(otherDate.getTime()).count());
        otherDate.add(1, -2);
        TaskQueryTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpAfter(otherDate.getTime()).count());
        TaskQueryTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpBefore(otherDate.getTime()).count());
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByActivityInstanceId() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)processInstance;
        String activityInstanceId = execution.getActivityInstanceId();
        TaskQueryTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId}).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseActivityInstanceId() throws Exception {
        String caseDefinitionKey = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getKey();
        this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.activityInstanceIdIn(new String[]{caseExecutionId});
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByMultipleActivityInstanceIds() throws Exception {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance1 instanceof ExecutionEntity));
        ExecutionEntity execution1 = (ExecutionEntity)processInstance1;
        String activityInstanceId1 = execution1.getActivityInstanceId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertTrue((boolean)(processInstance2 instanceof ExecutionEntity));
        ExecutionEntity execution2 = (ExecutionEntity)processInstance2;
        String activityInstanceId2 = execution2.getActivityInstanceId();
        List result1 = this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId1}).list();
        TaskQueryTest.assertEquals((int)1, (int)result1.size());
        TaskQueryTest.assertEquals((String)processInstance1.getId(), (String)((Task)result1.get(0)).getProcessInstanceId());
        List result2 = this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId2}).list();
        TaskQueryTest.assertEquals((int)1, (int)result2.size());
        TaskQueryTest.assertEquals((String)processInstance2.getId(), (String)((Task)result2.get(0)).getProcessInstanceId());
        TaskQueryTest.assertEquals((int)2, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId1, activityInstanceId2}).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    public void testQueryByInvalidActivityInstanceId() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TaskQueryTest.assertEquals((int)0, (int)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{"anInvalidActivityInstanceId"}).list().size());
    }

    public void testQueryPaging() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateUser("kermit");
        TaskQueryTest.assertEquals((int)11, (int)query.listPage(0, Integer.MAX_VALUE).size());
        TaskQueryTest.assertEquals((long)11L, (long)query.count());
        TaskQueryTest.assertEquals((int)11, (int)query.list().size());
        TaskQueryTest.assertEquals((int)2, (int)query.listPage(0, 2).size());
        TaskQueryTest.assertEquals((int)2, (int)query.listPage(2, 2).size());
        TaskQueryTest.assertEquals((int)3, (int)query.listPage(4, 3).size());
        TaskQueryTest.assertEquals((int)1, (int)query.listPage(10, 3).size());
        TaskQueryTest.assertEquals((int)1, (int)query.listPage(10, 1).size());
        TaskQueryTest.assertEquals((int)0, (int)query.listPage(-1, -1).size());
        TaskQueryTest.assertEquals((int)0, (int)query.listPage(11, 2).size());
        TaskQueryTest.assertEquals((int)11, (int)query.listPage(0, 15).size());
    }

    public void testQuerySorting() {
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskId().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskPriority().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskAssignee().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskDescription().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByProcessInstanceId().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByExecutionId().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskCreateTime().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByDueDate().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByFollowUpDate().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByCaseInstanceId().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByCaseExecutionId().asc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskId().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskPriority().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskAssignee().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskDescription().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByProcessInstanceId().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByExecutionId().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskCreateTime().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByDueDate().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByFollowUpDate().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByCaseInstanceId().desc()).list().size());
        TaskQueryTest.assertEquals((int)12, (int)((TaskQuery)this.taskService.createTaskQuery().orderByCaseExecutionId().desc()).list().size());
        TaskQueryTest.assertEquals((int)6, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskId().taskName("testTask").asc()).list().size());
        TaskQueryTest.assertEquals((int)6, (int)((TaskQuery)this.taskService.createTaskQuery().orderByTaskId().taskName("testTask").desc()).list().size());
    }

    public void testNativeQuery() {
        TaskQueryTest.assertEquals((String)"ACT_RU_TASK", (String)this.managementService.getTableName(Task.class));
        TaskQueryTest.assertEquals((String)"ACT_RU_TASK", (String)this.managementService.getTableName(TaskEntity.class));
        TaskQueryTest.assertEquals((int)12, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).list().size());
        TaskQueryTest.assertEquals((long)12L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class))).count());
        TaskQueryTest.assertEquals((long)144L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM ACT_RU_TASK T1, ACT_RU_TASK T2")).count());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T1, " + this.managementService.getTableName(VariableInstanceEntity.class) + " V1 WHERE V1.TASK_ID_ = T1.ID_")).count());
        List tasks = ((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class) + " T1, " + this.managementService.getTableName(VariableInstanceEntity.class) + " V1 WHERE V1.TASK_ID_ = T1.ID_")).list();
        TaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQueryTest.assertEquals((String)"gonzoTask", (String)((Task)tasks.get(0)).getName());
        TaskQueryTest.assertEquals((int)12, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT DISTINCT T1.* FROM ACT_RU_TASK T1")).list().size());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = 'gonzoTask'")).count());
        TaskQueryTest.assertEquals((int)1, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = 'gonzoTask'")).list().size());
        TaskQueryTest.assertEquals((long)1L, (long)((NativeTaskQuery)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = #{taskName}")).parameter("taskName", (Object)"gonzoTask")).count());
    }

    public void testNativeQueryPaging() {
        TaskQueryTest.assertEquals((String)"ACT_RU_TASK", (String)this.managementService.getTableName(Task.class));
        TaskQueryTest.assertEquals((String)"ACT_RU_TASK", (String)this.managementService.getTableName(TaskEntity.class));
        TaskQueryTest.assertEquals((int)5, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).listPage(0, 5).size());
        TaskQueryTest.assertEquals((int)2, (int)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).listPage(10, 12).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionKey() {
        String caseDefinitionKey = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getKey();
        this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionKey(caseDefinitionKey);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionKey() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKey(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionName() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        String caseDefinitionId = caseDefinition.getId();
        String caseDefinitionName = caseDefinition.getName();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionName(caseDefinitionName);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionName() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionName(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionNameLike() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionNameLike("One T%");
        this.verifyQueryResults(query, 1);
        query.caseDefinitionNameLike("%Task Case");
        this.verifyQueryResults(query, 1);
        query.caseDefinitionNameLike("%Task%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionNameLike() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionNameLike("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionNameLike(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceId(caseInstanceId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseInstanceId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceBusinessKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String businessKey = "aBusinessKey";
        this.caseService.withCaseDefinition(caseDefinitionId).businessKey(businessKey).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKey(businessKey);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseInstanceBusinessKey() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKey(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceBusinessKeyLike() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String businessKey = "aBusinessKey";
        this.caseService.withCaseDefinition(caseDefinitionId).businessKey(businessKey).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKeyLike("aBus%");
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKeyLike("%sinessKey");
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKeyLike("%sines%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseInstanceBusinessKeyLike() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKeyLike("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKeyLike(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseExecutionId(humanTaskExecutionId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseExecutionId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseExecutionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseExecutionId(null);
            TaskQueryTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueEquals("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableValueEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueEquals("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        Date before = new Date(now.getTime() - 100000L);
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aBooleanValue", (Object)false).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableGreaterThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aBooleanValue", (Object)false).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueGreaterThanOrEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThanOrEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableGreaterThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aBooleanValue", (Object)false).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableLessThan() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByBooleanCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aBooleanValue", (Object)false).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByShortCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByIntegerCaseInstanceVariableValueLessThanOrEquals() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByLongCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDateCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThanOrEquals("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByDoubleCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByByteArrayCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aByteArrayValue", (Object)bytes).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySerializableCaseInstanceVariableLessThanOrEqual() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aSerializableValue", serializable).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByNullCaseInstanceVariableValueLike() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLike("aNullValue", null).list();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByStringCaseInstanceVariableValueLike() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 1);
    }

    private void verifyQueryResults(TaskQuery query, int countExpected) {
        TaskQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        TaskQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            TaskQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            TaskQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(TaskQuery query) {
        try {
            query.singleResult();
            TaskQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private List<String> generateTestTasks() throws Exception {
        int i;
        ArrayList<String> ids = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        ClockUtil.setCurrentTime((Date)sdf.parse("01/01/2001 01:01:01.000"));
        for (int i2 = 0; i2 < 6; ++i2) {
            Task task = this.taskService.newTask();
            task.setName("testTask");
            task.setDescription("testTask description");
            task.setPriority(3);
            this.taskService.saveTask(task);
            ids.add(task.getId());
            this.taskService.addCandidateUser(task.getId(), "kermit");
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("02/02/2002 02:02:02.000"));
        Task task = this.taskService.newTask();
        task.setName("gonzoTask");
        task.setDescription("gonzo description");
        task.setPriority(4);
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "gonzo");
        this.taskService.setVariable(task.getId(), "testVar", (Object)"someVariable");
        ids.add(task.getId());
        ClockUtil.setCurrentTime((Date)sdf.parse("03/03/2003 03:03:03.000"));
        for (i = 0; i < 2; ++i) {
            task = this.taskService.newTask();
            task.setName("managementTask");
            task.setPriority(10);
            this.taskService.saveTask(task);
            this.taskService.addCandidateGroup(task.getId(), "management");
            ids.add(task.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("04/04/2004 04:04:04.000"));
        for (i = 0; i < 2; ++i) {
            task = this.taskService.newTask();
            task.setName("accountancyTask");
            task.setName("accountancy description");
            this.taskService.saveTask(task);
            this.taskService.addCandidateGroup(task.getId(), "accountancy");
            ids.add(task.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("05/05/2005 05:05:05.000"));
        task = this.taskService.newTask();
        task.setName("managementAndAccountancyTask");
        this.taskService.saveTask(task);
        this.taskService.addCandidateGroup(task.getId(), "management");
        this.taskService.addCandidateGroup(task.getId(), "accountancy");
        ids.add(task.getId());
        return ids;
    }
}

