/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class AsyncAfterTest
extends PluggableProcessEngineTestCase {
    public void testTransitionIdRequired() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/async/AsyncAfterTest.testTransitionIdRequired.bpmn20.xml").deploy();
            AsyncAfterTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Sequence flow with sourceRef='service' must have an id, activity with id 'service' uses 'asyncAfter'.", e.getMessage());
        }
    }

    @Deployment
    public void testAsyncAfterServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotBehaviorInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterServiceTaskMultipleTransitions() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("flowToTake", "flow2");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
        this.runtimeService.signal(pi.getId());
        varMap = new HashMap();
        varMap.put("flowToTake", "flow3");
        pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
    }

    @Deployment
    public void testAsyncAfterServiceTaskMultipleTransitionsConcurrent() {
        HashMap varMap = new HashMap();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        List jobs = this.managementService.createJobQuery().list();
        AsyncAfterTest.assertEquals((int)2, (int)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
    }

    @Deployment
    public void testAsyncAfterWithoutTransition() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "process-listenerEndInvoked"));
        this.managementService.executeJob(continuationJob.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterInNestedWithoutTransition() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "subprocess-listenerEndInvoked"));
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi.getId(), "subprocess-listenerEndInvoked")));
    }

    protected void assertListenerStartInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "listenerStartInvoked")));
    }

    protected void assertListenerEndInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "listenerEndInvoked")));
    }

    protected void assertBehaviorInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "behaviorInvoked")));
    }

    protected void assertNotListenerStartInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "listenerStartInvoked"));
    }

    protected void assertNotListenerEndInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "listenerEndInvoked"));
    }

    protected void assertNotBehaviorInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "behaviorInvoked"));
    }
}

