/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.test.Deployment;

public class BpmnDeploymentTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testGetBpmnXmlFileThroughService() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        BpmnDeploymentTest.assertEquals((int)1, (int)deploymentResources.size());
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        BpmnDeploymentTest.assertEquals((String)bpmnResourceName, (String)((String)deploymentResources.get(0)));
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        BpmnDeploymentTest.assertEquals((String)bpmnResourceName, (String)processDefinition.getResourceName());
        BpmnDeploymentTest.assertNull((Object)processDefinition.getDiagramResourceName());
        BpmnDeploymentTest.assertFalse((boolean)processDefinition.hasStartFormKey());
        ReadOnlyProcessDefinition readOnlyProcessDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinition.getId());
        BpmnDeploymentTest.assertNull((Object)readOnlyProcessDefinition.getDiagramResourceName());
        InputStream deploymentInputStream = this.repositoryService.getResourceAsStream(deploymentId, bpmnResourceName);
        String contentFromDeployment = this.readInputStreamToString(deploymentInputStream);
        BpmnDeploymentTest.assertTrue((contentFromDeployment.length() > 0 ? 1 : 0) != 0);
        BpmnDeploymentTest.assertTrue((boolean)contentFromDeployment.contains("process id=\"emptyProcess\""));
        InputStream fileInputStream = ReflectUtil.getResourceAsStream((String)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml");
        String contentFromFile = this.readInputStreamToString(fileInputStream);
        BpmnDeploymentTest.assertEquals((String)contentFromFile, (String)contentFromDeployment);
    }

    private String readInputStreamToString(InputStream inputStream) {
        byte[] bytes = IoUtil.readInputStream((InputStream)inputStream, (String)"input stream");
        return new String(bytes);
    }

    public void FAILING_testViolateProcessDefinitionIdMaximumLength() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/deployment/processWithLongId.bpmn20.xml").deploy();
            BpmnDeploymentTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("id can be maximum 64 characters", e.getMessage());
        }
        BpmnDeploymentTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
    }

    public void testDeploySameFileTwice() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).name("twice").deploy();
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        BpmnDeploymentTest.assertEquals((int)1, (int)deploymentResources.size());
        BpmnDeploymentTest.assertEquals((String)bpmnResourceName, (String)((String)deploymentResources.get(0)));
        this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).name("twice").deploy();
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        BpmnDeploymentTest.assertEquals((int)1, (int)deploymentList.size());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    public void testDeployTwoProcessesWithDuplicateIdAtTheSameTime() {
        try {
            String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
            String bpmnResourceName2 = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService2.bpmn20.xml";
            this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).addClasspathResource(bpmnResourceName2).name("duplicateAtTheSameTime").deploy();
            BpmnDeploymentTest.fail();
        }
        catch (Exception e) {
            BpmnDeploymentTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        }
    }

    public void testDeployDifferentFiles() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).name("twice").deploy();
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        BpmnDeploymentTest.assertEquals((int)1, (int)deploymentResources.size());
        BpmnDeploymentTest.assertEquals((String)bpmnResourceName, (String)((String)deploymentResources.get(0)));
        bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml";
        this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).name("twice").deploy();
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        BpmnDeploymentTest.assertEquals((int)2, (int)deploymentList.size());
        for (org.camunda.bpm.engine.repository.Deployment deployment : deploymentList) {
            this.repositoryService.deleteDeployment(deployment.getId());
        }
    }

    public void testDiagramCreationDisabled() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseDiagramInterchangeElements.bpmn20.xml").deploy();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandExecutor.execute((Command)new Command<ProcessDefinitionEntity>(){

            public ProcessDefinitionEntity execute(CommandContext commandContext) {
                return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedLatestProcessDefinitionByKey("myProcess");
            }
        });
        BpmnDeploymentTest.assertNotNull((Object)processDefinitionEntity);
        BpmnDeploymentTest.assertEquals((int)7, (int)processDefinitionEntity.getActivities().size());
        List resourceNames = this.repositoryService.getDeploymentResourceNames(processDefinitionEntity.getDeploymentId());
        BpmnDeploymentTest.assertEquals((int)1, (int)resourceNames.size());
        this.repositoryService.deleteDeployment(((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg"})
    public void testProcessDiagramResource() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        BpmnDeploymentTest.assertEquals((String)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml", (String)processDefinition.getResourceName());
        BpmnDeploymentTest.assertTrue((boolean)processDefinition.hasStartFormKey());
        String diagramResourceName = processDefinition.getDiagramResourceName();
        BpmnDeploymentTest.assertEquals((String)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg", (String)diagramResourceName);
        InputStream diagramStream = this.repositoryService.getResourceAsStream(this.deploymentId, "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg");
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        BpmnDeploymentTest.assertEquals((int)33343, (int)diagramBytes.length);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.a.jpg", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.b.jpg", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.c.jpg"})
    public void testMultipleDiagramResourcesProvided() {
        ProcessDefinition processA = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("a").singleResult();
        ProcessDefinition processB = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("b").singleResult();
        ProcessDefinition processC = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("c").singleResult();
        BpmnDeploymentTest.assertEquals((String)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.a.jpg", (String)processA.getDiagramResourceName());
        BpmnDeploymentTest.assertEquals((String)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.b.jpg", (String)processB.getDiagramResourceName());
        BpmnDeploymentTest.assertEquals((String)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.c.jpg", (String)processC.getDiagramResourceName());
    }

    @Deployment
    public void testProcessDefinitionDescription() {
        String id = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ReadOnlyProcessDefinition processDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(id);
        BpmnDeploymentTest.assertEquals((String)"This is really good process documentation!", (String)processDefinition.getDescription());
    }

    public void testDeployInvalidExpression() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testInvalidExpression.bpmn20.xml").deploy();
            BpmnDeploymentTest.fail((String)"Expected exception when deploying process with invalid expression.");
        }
        catch (ProcessEngineException expected) {
            BpmnDeploymentTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
            BpmnDeploymentTest.assertTrue((boolean)expected.getMessage().startsWith("Error while parsing process: "));
        }
    }

    public void testProcessDiagramCreation() throws IOException {
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        config.setCreateDiagramOnDeploy(true);
        ProcessEngine engine = config.buildProcessEngine();
        String deploymentId = engine.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramCreation.bpmn20.xml").deploy().getId();
        ProcessDefinition definition = (ProcessDefinition)engine.getRepositoryService().createProcessDefinitionQuery().singleResult();
        String expectedDiagramName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramCreation.processDiagramProcess.png";
        BpmnDeploymentTest.assertEquals((String)expectedDiagramName, (String)definition.getDiagramResourceName());
        InputStream diagramStream = engine.getRepositoryService().getProcessDiagram(definition.getId());
        BpmnDeploymentTest.assertNotNull((Object)diagramStream);
        diagramStream.close();
        engine.getRepositoryService().deleteDeployment(deploymentId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml"})
    public void testDeploymentIdOfResource() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        BpmnDeploymentTest.assertEquals((int)1, (int)resources.size());
        Resource resource = (Resource)resources.get(0);
        BpmnDeploymentTest.assertEquals((String)deploymentId, (String)resource.getDeploymentId());
    }
}

