/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.casetask;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class CaseTaskTest
extends PluggableProcessEngineTestCase {
    protected final String CASE_TASK = "PI_CaseTask_1";
    protected final String ONE_CASE_TASK_CASE = "oneCaseTaskCase";
    protected final String ONE_TASK_CASE = "oneTaskCase";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseAsConstant() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseAsExpressionStartsWithDollar() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("oneTaskCase", (Object)"oneTaskCase").manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseAsExpressionStartsWithHash.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseAsExpressionStartsWithHash() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("oneTaskCase", (Object)"oneTaskCase").manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallLatestCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallLatestCase() {
        String cmmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        CaseTaskTest.assertEquals((long)3L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String latestCaseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").latestVersion().singleResult()).getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        CaseTaskTest.assertEquals((String)latestCaseDefinitionId, (String)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseByDeployment.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseByDeployment() {
        String firstDeploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String cmmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        CaseTaskTest.assertEquals((long)3L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String caseDefinitionIdInSameDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(firstDeploymentId).singleResult()).getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        CaseTaskTest.assertEquals((String)caseDefinitionIdInSameDeployment, (String)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseByVersion.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseByVersion() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        CaseTaskTest.assertEquals((long)4L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String caseDefinitionIdInSecondDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(secondDeploymentId).singleResult()).getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        CaseTaskTest.assertEquals((String)caseDefinitionIdInSecondDeployment, (String)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseByVersionAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseByVersionAsExpressionStartsWithDollar() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        CaseTaskTest.assertEquals((long)4L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String caseDefinitionIdInSecondDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(secondDeploymentId).singleResult()).getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("myVersion", (Object)2).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        CaseTaskTest.assertEquals((String)caseDefinitionIdInSecondDeployment, (String)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseByVersionAsExpressionStartsWithHash.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCallCaseByVersionAsExpressionStartsWithHash() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        CaseTaskTest.assertEquals((long)4L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String caseDefinitionIdInSecondDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(secondDeploymentId).singleResult()).getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("myVersion", (Object)2).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        CaseTaskTest.assertEquals((String)caseDefinitionIdInSecondDeployment, (String)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputBusinessKey.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputBusinessKey() {
        String businessKey = "myBusinessKey";
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase", businessKey).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        CaseTaskTest.assertEquals((String)businessKey, (String)subCaseInstance.getBusinessKey());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputDifferentBusinessKey.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputDifferentBusinessKey() {
        String businessKey = "myBusinessKey";
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase", businessKey).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("myOwnBusinessKey", (Object)"myOwnBusinessKey").manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        CaseTaskTest.assertEquals((String)caseTaskId, (String)superCaseExecutionId);
        CaseTaskTest.assertEquals((String)superCaseInstanceId, (String)superCaseExecution.getCaseInstanceId());
        CaseTaskTest.assertEquals((String)"myOwnBusinessKey", (String)subCaseInstance.getBusinessKey());
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputSource.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputSource() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).setVariable("aThirdVariable", (Object)"def").manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputSourceDifferentTarget.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputSourceDifferentTarget() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("myVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"myVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("myAnotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"myAnotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputSource.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputSourceNullValue() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
            } else if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
            } else {
                CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
            }
            CaseTaskTest.assertNull((Object)variable.getValue());
        }
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputSourceExpression.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputSourceExpression() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputAll.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testInputAll() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn"})
    public void testCaseNotFound() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).manualStart();
            CaseTaskTest.fail((String)"It should not be possible to start a case instance.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.caseService.withCaseExecution(caseTaskId).disable();
        this.closeCaseInstance(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteSimpleCase() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseTaskTest.assertNull((Object)caseTask);
        this.closeCaseInstance(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputSource.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputSource() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).setVariable("aThirdVariable", (Object)"def").execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputSourceDifferentTarget.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputSourceDifferentTarget() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("myVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"myVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("myAnotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"myAnotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputSource.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputSourceNullValue() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
            } else if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
            } else {
                CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
            }
            CaseTaskTest.assertNull((Object)variable.getValue());
        }
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputSourceExpression.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputSourceExpression() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputAll.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputAll() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputAll.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testOutputVariablesShouldNotExistAnymore() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariableLocal("aVariable", (Object)"xyz").setVariableLocal("anotherVariable", (Object)123).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        CaseTaskTest.assertTrue((boolean)variables.isEmpty());
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testVariablesRoundtrip.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testVariablesRoundtrip() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariable", (Object)"xyz").setVariable("anotherVariable", (Object)123).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        CaseTaskTest.assertFalse((boolean)variables.isEmpty());
        CaseTaskTest.assertEquals((int)2, (int)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"aVariable", (String)name);
                CaseTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                CaseTaskTest.assertEquals((String)"anotherVariable", (String)name);
                CaseTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseTaskTest.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteCaseTask() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            CaseTaskTest.fail((String)"It should not be possible to complete a case task, while the case instance is active.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        this.closeCaseInstance(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminateCaseTask() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        CaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        this.terminate(caseTaskId);
        subCaseInstance = this.queryOneTaskCaseInstance();
        CaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        this.closeCaseInstance(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminateSubCaseInstance() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        CmmnExecution subCaseInstance = (CmmnExecution)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseTaskTest.assertTrue((boolean)subCaseInstance.isTerminated());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseTaskTest.assertNotNull((Object)caseTask);
        CaseTaskTest.assertTrue((boolean)caseTask.isActive());
        this.closeCaseInstance(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSuspendCaseTask() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        CaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        this.suspend(caseTaskId);
        subCaseInstance = this.queryOneTaskCaseInstance();
        CaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        this.closeCaseInstance(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.terminate(superCaseInstanceId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSuspendSubCaseInstance() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.suspend(subCaseInstanceId);
        CmmnExecution subCaseInstance = (CmmnExecution)this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseTaskTest.assertTrue((boolean)subCaseInstance.isSuspended());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseTaskTest.assertNotNull((Object)caseTask);
        CaseTaskTest.assertTrue((boolean)caseTask.isActive());
        this.closeCaseInstance(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testResumeCaseTask() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        this.suspend(caseTaskId);
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        CaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        this.resume(caseTaskId);
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseTaskTest.assertTrue((boolean)caseTask.isActive());
        subCaseInstance = this.queryOneTaskCaseInstance();
        CaseTaskTest.assertTrue((boolean)subCaseInstance.isActive());
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        this.closeCaseInstance(subCaseInstanceId);
        this.assertCaseEnded(subCaseInstanceId);
        this.terminate(caseTaskId);
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testNotBlockingCaseTask.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNotBlockingCaseTask() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        CaseTaskTest.assertNotNull((Object)subCaseInstance);
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseTaskTest.assertNull((Object)caseTask);
        CaseInstance superCaseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneCaseTaskCase").singleResult();
        CaseTaskTest.assertNotNull((Object)superCaseInstance);
        CaseTaskTest.assertTrue((boolean)superCaseInstance.isCompleted());
        this.closeCaseInstance(superCaseInstanceId);
        this.assertCaseEnded(superCaseInstanceId);
        this.terminate(subCaseInstance.getId());
        this.closeCaseInstance(subCaseInstance.getId());
        this.assertProcessEnded(subCaseInstance.getId());
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey) {
        return this.createCaseInstance(caseDefinitionKey, null);
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey, String businessKey) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).businessKey(businessKey).create();
    }

    protected CaseExecution queryCaseExecutionById(String id) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().caseExecutionId(id).singleResult();
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }

    protected CaseInstance queryOneTaskCaseInstance() {
        return (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult();
    }

    protected Task queryTask() {
        return (Task)this.taskService.createTaskQuery().singleResult();
    }

    protected void terminate(final String caseExecutionId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                CmmnExecution caseTask = (CmmnExecution)CaseTaskTest.this.caseService.createCaseExecutionQuery().caseExecutionId(caseExecutionId).singleResult();
                caseTask.terminate();
                return null;
            }
        });
    }

    protected void suspend(final String caseExecutionId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                CmmnExecution caseTask = (CmmnExecution)CaseTaskTest.this.caseService.createCaseExecutionQuery().caseExecutionId(caseExecutionId).singleResult();
                caseTask.suspend();
                return null;
            }
        });
    }

    protected void resume(final String caseExecutionId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                CmmnExecution caseTask = (CmmnExecution)CaseTaskTest.this.caseService.createCaseExecutionQuery().caseExecutionId(caseExecutionId).singleResult();
                caseTask.resume();
                return null;
            }
        });
    }

    protected void closeCaseInstance(String caseInstanceId) {
        this.caseService.withCaseExecution(caseInstanceId).close();
    }
}

