/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CasePlanModelHandlerTest
extends CmmnElementHandlerTest {
    protected CasePlanModelHandler handler = new CasePlanModelHandler();
    protected CmmnHandlerContext context;

    @Before
    public void setUp() {
        this.context = new CmmnHandlerContext();
    }

    @Test
    public void testCasePlanModelActivityName() {
        String name = "A CasePlanModel";
        this.casePlanModel.setName(name);
        CmmnActivity activity = this.handler.handleElement(this.casePlanModel, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement(this.casePlanModel, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof StageActivityBehavior));
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement(this.casePlanModel, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement(this.casePlanModel, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }
}

