/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import java.util.HashMap;
import java.util.Set;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.HumanTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.HumanTaskPlanItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.impl.instance.CaseRoles;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.Role;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HumanTaskPlanItemHandlerTest
extends CmmnElementHandlerTest {
    protected HumanTask humanTask;
    protected PlanItem planItem;
    protected HumanTaskPlanItemHandler handler = new HumanTaskPlanItemHandler();
    protected CmmnHandlerContext context;

    @Before
    public void setUp() {
        this.humanTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aHumanTask", HumanTask.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aHumanTask", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.humanTask);
        this.context = new CmmnHandlerContext();
        CaseDefinitionEntity caseDefinition = new CaseDefinitionEntity();
        caseDefinition.setTaskDefinitions(new HashMap());
        this.context.setCaseDefinition((CmmnCaseDefinition)caseDefinition);
        ExpressionManager expressionManager = new ExpressionManager();
        this.context.setExpressionManager(expressionManager);
    }

    @Test
    public void testHumanTaskActivityName() {
        String name = "A HumanTask";
        this.humanTask.setName(name);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testPlanItemActivityName() {
        String humanTaskName = "A HumanTask";
        this.humanTask.setName(humanTaskName);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertNotEquals((Object)humanTaskName, (Object)activity.getName());
        Assert.assertEquals((Object)planItemName, (Object)activity.getName());
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof HumanTaskActivityBehavior));
    }

    @Test
    public void testIsBlockingEqualsTrueProperty() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertTrue((boolean)isBlocking);
    }

    @Test
    public void testIsBlockingEqualsFalseProperty() {
        this.humanTask.setIsBlocking(false);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertNull((Object)activity);
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testTaskDecorator() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        Assert.assertNotNull((Object)behavior.getTaskDecorator());
    }

    @Test
    public void testTaskDefinition() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        Assert.assertNotNull((Object)behavior.getTaskDefinition());
    }

    @Test
    public void testExpressionManager() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        ExpressionManager expressionManager = behavior.getExpressionManager();
        Assert.assertNotNull((Object)expressionManager);
        Assert.assertEquals((Object)this.context.getExpressionManager(), (Object)expressionManager);
    }

    @Test
    public void testTaskDefinitionHumanTaskNameExpression() {
        String name = "A HumanTask";
        this.humanTask.setName(name);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        Expression nameExpression = behavior.getTaskDefinition().getNameExpression();
        Assert.assertNotNull((Object)nameExpression);
        Assert.assertEquals((Object)"A HumanTask", (Object)nameExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionPlanItemNameExpression() {
        String name = "A HumanTask";
        this.humanTask.setName(name);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression nameExpression = taskDefinition.getNameExpression();
        Assert.assertNotNull((Object)nameExpression);
        Assert.assertEquals((Object)"My LocalName", (Object)nameExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionDueDateExpression() {
        String aDueDate = "aDueDate";
        this.humanTask.setCamundaDueDate(aDueDate);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression dueDateExpression = taskDefinition.getDueDateExpression();
        Assert.assertNotNull((Object)dueDateExpression);
        Assert.assertEquals((Object)aDueDate, (Object)dueDateExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionPriorityExpression() {
        String aPriority = "aPriority";
        this.humanTask.setCamundaPriority(aPriority);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression priorityExpression = taskDefinition.getPriorityExpression();
        Assert.assertNotNull((Object)priorityExpression);
        Assert.assertEquals((Object)aPriority, (Object)priorityExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionPeformerExpression() {
        CaseRoles role = this.createElement((CmmnModelElementInstance)this.caseDefinition, "aRole", CaseRoles.class);
        role.setName("aPerformerRole");
        this.humanTask.setPerformer((Role)role);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression assigneeExpression = taskDefinition.getAssigneeExpression();
        Assert.assertNotNull((Object)assigneeExpression);
        Assert.assertEquals((Object)"aPerformerRole", (Object)assigneeExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionAssigneeExpression() {
        String aPriority = "aPriority";
        this.humanTask.setCamundaPriority(aPriority);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression priorityExpression = taskDefinition.getPriorityExpression();
        Assert.assertNotNull((Object)priorityExpression);
        Assert.assertEquals((Object)aPriority, (Object)priorityExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionCandidateUsers() {
        String aCandidateUsers = "mary,john,peter";
        this.humanTask.setCamundaCandidateUsers(aCandidateUsers);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Set candidateUserExpressions = taskDefinition.getCandidateUserIdExpressions();
        Assert.assertEquals((long)3L, (long)candidateUserExpressions.size());
        for (Expression candidateUserExpression : candidateUserExpressions) {
            String candidateUser = candidateUserExpression.getExpressionText();
            if ("mary".equals(candidateUser)) {
                Assert.assertEquals((Object)"mary", (Object)candidateUser);
                continue;
            }
            if ("john".equals(candidateUser)) {
                Assert.assertEquals((Object)"john", (Object)candidateUser);
                continue;
            }
            if ("peter".equals(candidateUser)) {
                Assert.assertEquals((Object)"peter", (Object)candidateUser);
                continue;
            }
            Assert.fail((String)("Unexpected candidate user: " + candidateUser));
        }
    }

    @Test
    public void testTaskDefinitionCandidateGroups() {
        String aCandidateGroups = "accounting,management,backoffice";
        this.humanTask.setCamundaCandidateGroups(aCandidateGroups);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Set candidateGroupExpressions = taskDefinition.getCandidateGroupIdExpressions();
        Assert.assertEquals((long)3L, (long)candidateGroupExpressions.size());
        for (Expression candidateGroupExpression : candidateGroupExpressions) {
            String candidateGroup = candidateGroupExpression.getExpressionText();
            if ("accounting".equals(candidateGroup)) {
                Assert.assertEquals((Object)"accounting", (Object)candidateGroup);
                continue;
            }
            if ("management".equals(candidateGroup)) {
                Assert.assertEquals((Object)"management", (Object)candidateGroup);
                continue;
            }
            if ("backoffice".equals(candidateGroup)) {
                Assert.assertEquals((Object)"backoffice", (Object)candidateGroup);
                continue;
            }
            Assert.fail((String)("Unexpected candidate group: " + candidateGroup));
        }
    }

    @Test
    public void testTaskDefinitionFormKey() {
        String aFormKey = "aFormKey";
        this.humanTask.setCamundaFormKey(aFormKey);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression formKeyExpression = taskDefinition.getFormKey();
        Assert.assertNotNull((Object)formKeyExpression);
        Assert.assertEquals((Object)aFormKey, (Object)formKeyExpression.getExpressionText());
    }

    @Test
    public void testHumanTaskDescription() {
        String description = "A description";
        this.humanTask.setDescription(description);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression descriptionExpression = taskDefinition.getDescriptionExpression();
        Assert.assertNotNull((Object)descriptionExpression);
        Assert.assertEquals((Object)description, (Object)descriptionExpression.getExpressionText());
    }

    @Test
    public void testPlanItemDescription() {
        String description = "A description";
        this.humanTask.setDescription(description);
        String localDescription = "My Local Description";
        this.planItem.setDescription(localDescription);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression descriptionExpression = taskDefinition.getDescriptionExpression();
        Assert.assertNotNull((Object)descriptionExpression);
        Assert.assertEquals((Object)localDescription, (Object)descriptionExpression.getExpressionText());
    }
}

