/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.StagePlanItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.Stage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StagePlanItemHandlerTest
extends CmmnElementHandlerTest {
    protected Stage stage;
    protected PlanItem planItem;
    protected StagePlanItemHandler handler = new StagePlanItemHandler();
    protected CmmnHandlerContext context;

    @Before
    public void setUp() {
        this.stage = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aStage", Stage.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aStage", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.stage);
        this.context = new CmmnHandlerContext();
    }

    @Test
    public void testStageActivityName() {
        String name = "A Stage";
        this.stage.setName(name);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testPlanItemActivityName() {
        String stageName = "A Stage";
        this.stage.setName(stageName);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertNotEquals((Object)stageName, (Object)activity.getName());
        Assert.assertEquals((Object)planItemName, (Object)activity.getName());
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof StageActivityBehavior));
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }
}

