/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.db.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;

public class DbDeadlockTests
extends ConcurrencyTestCase {
    private ConcurrencyTestCase.ThreadControl thread1;
    private ConcurrencyTestCase.ThreadControl thread2;

    public void testTransactionIsolation() {
        this.thread1 = this.executeControllableCommand(new TestCommand("p1"));
        this.thread1.waitForSync();
        this.thread2 = this.executeControllableCommand(new TestCommand("p2"));
        this.thread2.waitForSync();
        this.thread2.makeContinue();
        this.thread1.makeContinue();
        this.thread2.waitForSync();
        this.thread1.waitForSync();
    }

    protected void tearDown() throws Exception {
        this.thread2.waitUntilDone();
        this.thread1.waitUntilDone();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List list = commandContext.getDbSqlSession().createHistoricProcessInstanceQuery().list();
                for (HistoricProcessInstance historicProcessInstance : list) {
                    commandContext.getDbSqlSession().delete("deleteHistoricProcessInstance", (Object)historicProcessInstance.getId());
                }
                return null;
            }
        });
    }

    static class TestCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String id;

        public TestCommand(String id) {
            this.id = id;
        }

        public Void execute(CommandContext commandContext) {
            DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
            DbSqlSessionFactory dbSqlSessionFactory = dbSqlSession.getDbSqlSessionFactory();
            HistoricProcessInstanceEventEntity hpi = new HistoricProcessInstanceEventEntity();
            hpi.setId(this.id);
            hpi.setProcessInstanceId(this.id);
            hpi.setProcessDefinitionId("someProcDefId");
            hpi.setStartTime(new Date());
            dbSqlSession.insert((PersistentObject)hpi);
            dbSqlSession.flush();
            this.monitor.sync();
            DbSqlSession newDbSqlSession = (DbSqlSession)dbSqlSessionFactory.openSession();
            newDbSqlSession.createHistoricProcessInstanceQuery().list();
            this.monitor.sync();
            return null;
        }
    }
}

