/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class JobEntityTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/db/processWithGatewayAndTwoEndEvents.bpmn20.xml"})
    public void testGatewayWithTwoEndEventsLastJobReAssignedToParentExe() {
        String processKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processKey).getId();
        List jobList = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        JobEntityTest.assertNotNull((Object)jobList);
        JobEntityTest.assertEquals((int)2, (int)jobList.size());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        JobEntityTest.assertEquals((int)1, (int)jobList.size());
        JobEntityTest.assertEquals((int)1, (int)this.runtimeService.createExecutionQuery().list().size());
        JobEntityTest.assertEquals((String)processInstanceId, (String)((Job)jobList.get(0)).getExecutionId());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        JobEntityTest.assertEquals((int)0, (int)jobList.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/db/processGatewayAndTwoEndEventsPlusTimer.bpmn20.xml"})
    public void testGatewayWithTwoEndEventsLastTimerReAssignedToParentExe() {
        String processKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processKey).getId();
        List jobList = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        JobEntityTest.assertNotNull((Object)jobList);
        JobEntityTest.assertEquals((int)2, (int)jobList.size());
        String timerId = ((Job)this.managementService.createJobQuery().timers().singleResult()).getId();
        this.managementService.executeJob(timerId);
        jobList = this.managementService.createJobQuery().list();
        JobEntityTest.assertEquals((int)1, (int)jobList.size());
        JobEntityTest.assertEquals((int)1, (int)this.runtimeService.createExecutionQuery().list().size());
        JobEntityTest.assertEquals((String)processInstanceId, (String)((Job)jobList.get(0)).getExecutionId());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        JobEntityTest.assertEquals((int)0, (int)jobList.size());
    }
}

