/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.cmd.SetProcessDefinitionVersionCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ProcessInstanceMigrationTest
extends PluggableProcessEngineTestCase {
    private static final String TEST_PROCESS_WITH_PARALLEL_GATEWAY = "org/camunda/bpm/engine/test/examples/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml";
    private static final String TEST_PROCESS = "org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.testSetProcessDefinitionVersion.bpmn20.xml";
    private static final String TEST_PROCESS_ACTIVITY_MISSING = "org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.testSetProcessDefinitionVersionActivityMissing.bpmn20.xml";
    private static final String TEST_PROCESS_CALL_ACTIVITY = "org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.withCallActivity.bpmn20.xml";
    private static final String TEST_PROCESS_USER_TASK_V1 = "org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.testSetProcessDefinitionVersionWithTask.bpmn20.xml";
    private static final String TEST_PROCESS_USER_TASK_V2 = "org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.testSetProcessDefinitionVersionWithTaskV2.bpmn20.xml";

    public void testSetProcessDefinitionVersionEmptyArguments() {
        try {
            new SetProcessDefinitionVersionCmd(null, Integer.valueOf(23));
            ProcessInstanceMigrationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process instance id is mandatory: processInstanceId is null", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("", Integer.valueOf(23));
            ProcessInstanceMigrationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process instance id is mandatory: processInstanceId is empty", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("42", null);
            ProcessInstanceMigrationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition version is mandatory: processDefinitionVersion is null", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("42", Integer.valueOf(-1));
            ProcessInstanceMigrationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition version must be positive: processDefinitionVersion is not positive", ae.getMessage());
        }
    }

    public void testSetProcessDefinitionVersionNonExistingPI() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        try {
            commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd("42", Integer.valueOf(23)));
            ProcessInstanceMigrationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("No process instance found for id = '42'.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml"})
    public void testSetProcessDefinitionVersionPIIsSubExecution() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("forkJoin");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("receivePayment").singleResult();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        SetProcessDefinitionVersionCmd command = new SetProcessDefinitionVersionCmd(execution.getId(), Integer.valueOf(1));
        try {
            commandExecutor.execute((Command)command);
            ProcessInstanceMigrationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("A process instance id is required, but the provided id '" + execution.getId() + "' points to a child execution of process instance '" + pi.getId() + "'. Please invoke the " + command.getClass().getSimpleName() + " with a root execution id.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.testSetProcessDefinitionVersion.bpmn20.xml"})
    public void testSetProcessDefinitionVersionNonExistingPD() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        try {
            commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(23)));
            ProcessInstanceMigrationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no processes deployed with key = 'receiveTask' and version = '23'", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.testSetProcessDefinitionVersion.bpmn20.xml"})
    public void testSetProcessDefinitionVersionActivityMissing() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("waitState1").singleResult();
        ProcessInstanceMigrationTest.assertNotNull((Object)execution);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ACTIVITY_MISSING).deploy();
        ProcessInstanceMigrationTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        SetProcessDefinitionVersionCmd setProcessDefinitionVersionCmd = new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2));
        try {
            commandExecutor.execute((Command)setProcessDefinitionVersionCmd);
            ProcessInstanceMigrationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The new process definition (key = 'receiveTask') does not contain the current activity (id = 'waitState1') of the process instance (id = '", ae.getMessage());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment
    public void testSetProcessDefinitionVersion() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState1").singleResult();
        ProcessInstanceMigrationTest.assertNotNull((Object)execution);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS).deploy();
        ProcessInstanceMigrationTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        this.runtimeService.signal(execution.getId());
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
        ProcessInstanceMigrationTest.assertEquals((String)newProcessDefinition.getId(), (String)pi.getProcessDefinitionId());
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            HistoricProcessInstance historicPI = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml"})
    public void testSetProcessDefinitionVersionSubExecutions() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("forkJoin");
        ProcessInstanceMigrationTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_WITH_PARALLEL_GATEWAY).deploy();
        ProcessInstanceMigrationTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).list();
        for (Execution execution : executions) {
            ProcessInstanceMigrationTest.assertEquals((String)newProcessDefinition.getId(), (String)((ExecutionEntity)execution).getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.withCallActivity.bpmn20.xml"})
    public void testSetProcessDefinitionVersionWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("parentProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("waitState1").processDefinitionKey("childProcess").singleResult();
        ProcessInstanceMigrationTest.assertNotNull((Object)execution);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_CALL_ACTIVITY).deploy();
        ProcessInstanceMigrationTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("parentProcess").count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        this.runtimeService.signal(execution.getId());
        ProcessInstanceMigrationTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/db/ProcessInstanceMigrationTest.testSetProcessDefinitionVersionWithTask.bpmn20.xml"})
    public void testSetProcessDefinitionVersionWithWithTask() {
        try {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("userTask");
            ProcessInstanceMigrationTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(pi.getId()).count());
            org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_USER_TASK_V2).deploy();
            ProcessInstanceMigrationTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("userTask").count());
            ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("userTask").processDefinitionVersion(Integer.valueOf(2)).singleResult();
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            ProcessInstanceMigrationTest.assertEquals((String)newProcessDefinition.getId(), (String)task.getProcessDefinitionId());
            ProcessInstanceMigrationTest.assertEquals((String)"testFormKey", (String)this.formService.getTaskFormData(task.getId()).getFormKey());
            this.taskService.complete(task.getId());
            this.assertProcessEnded(pi.getId());
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

