/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.usertask;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class FinancialReportProcessTest
extends PluggableProcessEngineTestCase {
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.createMembership("fozzie", "accountancy");
        this.identityService.createMembership("kermit", "management");
    }

    public void tearDown() throws Exception {
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("kermit");
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/usertask/FinancialReportProcess.bpmn20.xml"})
    public void testProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("financialReport");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("fozzie").list();
        FinancialReportProcessTest.assertEquals((int)1, (int)tasks.size());
        Task task = (Task)tasks.get(0);
        FinancialReportProcessTest.assertEquals((String)"Write monthly financial report", (String)task.getName());
        this.taskService.claim(task.getId(), "fozzie");
        tasks = this.taskService.createTaskQuery().taskAssignee("fozzie").list();
        FinancialReportProcessTest.assertEquals((int)1, (int)tasks.size());
        this.taskService.complete(task.getId());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("fozzie").list();
        FinancialReportProcessTest.assertEquals((int)0, (int)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        FinancialReportProcessTest.assertEquals((int)1, (int)tasks.size());
        FinancialReportProcessTest.assertEquals((String)"Verify monthly financial report", (String)((Task)tasks.get(0)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.assertProcessEnded(processInstance.getId());
    }
}

