/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.pvm;

import java.util.ArrayList;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.pvm.EventCollector;
import org.camunda.bpm.engine.test.pvm.activities.Automatic;
import org.camunda.bpm.engine.test.pvm.activities.End;
import org.camunda.bpm.engine.test.pvm.activities.WaitState;

public class PvmScopeAndEventsTest
extends PvmTestCase {
    public void testStartEndWithScopesAndNestedActivities() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("scopes and events").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("mostOuterNestedActivity").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("outerScope").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("firstInnerScope").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("firstMostInnerNestedActivity").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("waitInFirst").endActivity().createActivity("waitInFirst").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("waitInSecond").endActivity().endActivity().endActivity().createActivity("secondInnerScope").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("secondMostInnerNestedActivity").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("waitInSecond").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().endActivity().endActivity().endActivity().endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(scopes and events)");
        expectedEvents.add("start on Activity(mostOuterNestedActivity)");
        expectedEvents.add("start on Activity(outerScope)");
        expectedEvents.add("start on Activity(firstInnerScope)");
        expectedEvents.add("start on Activity(firstMostInnerNestedActivity)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("start on Activity(waitInFirst)");
        PvmScopeAndEventsTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmExecution execution = processInstance.findExecution("waitInFirst");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(waitInFirst)");
        expectedEvents.add("end on Activity(firstMostInnerNestedActivity)");
        expectedEvents.add("end on Activity(firstInnerScope)");
        expectedEvents.add("start on Activity(secondInnerScope)");
        expectedEvents.add("start on Activity(secondMostInnerNestedActivity)");
        expectedEvents.add("start on Activity(waitInSecond)");
        PvmScopeAndEventsTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        execution = processInstance.findExecution("waitInSecond");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(waitInSecond)");
        expectedEvents.add("start on Activity(end)");
        expectedEvents.add("end on Activity(end)");
        expectedEvents.add("end on Activity(secondMostInnerNestedActivity)");
        expectedEvents.add("end on Activity(secondInnerScope)");
        expectedEvents.add("end on Activity(outerScope)");
        expectedEvents.add("end on Activity(mostOuterNestedActivity)");
        expectedEvents.add("end on ProcessDefinition(scopes and events)");
        PvmScopeAndEventsTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
    }

    public void testStartEndWithScopesAndNestedActivitiesNotAtInitial() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("scopes and events").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("mostOuterNestedActivity").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("outerScope").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("firstInnerScope").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("firstMostInnerNestedActivity").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("waitInFirst").endActivity().createActivity("waitInFirst").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("waitInSecond").endActivity().endActivity().endActivity().createActivity("secondInnerScope").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("secondMostInnerNestedActivity").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("waitInSecond").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().endActivity().endActivity().endActivity().endActivity().buildProcessDefinition();
        ActivityImpl alternativeInitial = (ActivityImpl)processDefinition.findActivity("waitInFirst");
        PvmProcessInstance processInstance = ((ProcessDefinitionImpl)processDefinition).createProcessInstanceForInitial(alternativeInitial);
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(scopes and events)");
        expectedEvents.add("start on Activity(mostOuterNestedActivity)");
        expectedEvents.add("start on Activity(outerScope)");
        expectedEvents.add("start on Activity(firstInnerScope)");
        expectedEvents.add("start on Activity(firstMostInnerNestedActivity)");
        expectedEvents.add("start on Activity(waitInFirst)");
        PvmScopeAndEventsTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmExecution execution = processInstance.findExecution("waitInFirst");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(waitInFirst)");
        expectedEvents.add("end on Activity(firstMostInnerNestedActivity)");
        expectedEvents.add("end on Activity(firstInnerScope)");
        expectedEvents.add("start on Activity(secondInnerScope)");
        expectedEvents.add("start on Activity(secondMostInnerNestedActivity)");
        expectedEvents.add("start on Activity(waitInSecond)");
        PvmScopeAndEventsTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        execution = processInstance.findExecution("waitInSecond");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(waitInSecond)");
        expectedEvents.add("start on Activity(end)");
        expectedEvents.add("end on Activity(end)");
        expectedEvents.add("end on Activity(secondMostInnerNestedActivity)");
        expectedEvents.add("end on Activity(secondInnerScope)");
        expectedEvents.add("end on Activity(outerScope)");
        expectedEvents.add("end on Activity(mostOuterNestedActivity)");
        expectedEvents.add("end on ProcessDefinition(scopes and events)");
        PvmScopeAndEventsTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
    }
}

