/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.PostDeploy;
import org.camunda.bpm.container.impl.jmx.deployment.util.InjectionUtil;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.engine.ProcessEngineException;

public class PostDeployInvocationStep
extends MBeanDeploymentOperationStep {
    @Override
    public String getName() {
        return "Invoking @PostDeploy";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        Class<?> paClass = processApplication.getClass();
        Method postDeployMethod = InjectionUtil.detectAnnotatedMethod(paClass, PostDeploy.class);
        if (postDeployMethod == null) {
            return;
        }
        Object[] injections = InjectionUtil.resolveInjections(operationContext, postDeployMethod);
        try {
            postDeployMethod.invoke((Object)processApplication, injections);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessEngineException("IllegalArgumentException while invoking @PostDeploy method", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessEngineException("IllegalAccessException while invoking @PostDeploy method", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ProcessEngineException("Exception while invoking @PostDeploy method", cause);
        }
    }
}

