/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class SequentialMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    public SequentialMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    @Override
    protected void createInstances(ActivityExecution execution, int nrOfInstances) throws Exception {
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "loopCounter", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", 1);
        this.logLoopDetails(execution, "initialized", 0, 0, 1, nrOfInstances);
        this.executeOriginalBehavior(execution, 0);
    }

    @Override
    public void leave(ActivityExecution execution) {
        int loopCounter = this.getLoopVariable(execution, "loopCounter") + 1;
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        this.setLoopVariable(execution, "loopCounter", loopCounter);
        this.setLoopVariable(execution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        if (loopCounter == nrOfInstances || this.completionConditionSatisfied(execution)) {
            super.leave(execution);
        } else {
            for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(execution.getActivity())) {
                declaration.handleSequentialMultiInstanceLeave((ExecutionEntity)execution);
            }
            List<JobEntity> jobs = ((ExecutionEntity)execution).getJobs();
            for (JobEntity jobEntity : jobs) {
                jobEntity.delete();
            }
            List timerDeclarations = (List)execution.getActivity().getProperty("timerDeclarations");
            if (timerDeclarations != null) {
                for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                    timerDeclaration.createTimerInstance((ExecutionEntity)execution);
                }
            }
            this.callActivityEndListeners(execution);
            try {
                this.executeOriginalBehavior(execution, loopCounter);
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new ProcessEngineException("Could not execute inner activity behavior of multi instance behavior", e);
            }
        }
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        super.execute(execution);
        if (this.innerActivityBehavior instanceof SubProcessActivityBehavior && !execution.isActive() && execution.isEnded() && (execution.getExecutions() == null || execution.getExecutions().size() == 0)) {
            execution.setActive(true);
        }
    }
}

