/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.helper;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class ScopeUtil {
    public static ActivityExecution findScopeExecution(ActivityExecution execution) {
        while (!execution.isScope()) {
            execution = execution.getParent();
        }
        if (execution.isConcurrent()) {
            execution = execution.getParent();
        }
        return execution;
    }

    public static ExecutionEntity findScopeExecutionForScope(ExecutionEntity execution, PvmScope scopeActivity) {
        if (scopeActivity instanceof PvmProcessDefinition) {
            return execution.getProcessInstance();
        }
        ActivityImpl currentActivity = execution.getActivity();
        ExecutionEntity candiadateExecution = null;
        ExecutionEntity originalExecution = execution;
        while (execution != null) {
            currentActivity = execution.getActivity();
            if (scopeActivity.getActivities().contains(currentActivity) || scopeActivity.equals(currentActivity)) {
                candiadateExecution = execution;
            } else if (currentActivity != null && currentActivity.contains((ActivityImpl)scopeActivity)) break;
            execution = execution.getParent();
        }
        if (originalExecution == candiadateExecution && originalExecution.getActivity().isScope() && !originalExecution.getActivity().equals(scopeActivity)) {
            candiadateExecution = originalExecution.getParent();
        }
        return candiadateExecution;
    }

    public static ActivityImpl findInParentScopesByBehaviorType(ActivityImpl activity, Class<? extends ActivityBehavior> behaviorType) {
        while (activity != null) {
            for (ActivityImpl childActivity : activity.getActivities()) {
                if (!behaviorType.isAssignableFrom(childActivity.getActivityBehavior().getClass())) continue;
                return childActivity;
            }
            activity = activity.getParentActivity();
        }
        return null;
    }

    public static void throwCompensationEvent(List<CompensateEventSubscriptionEntity> eventSubscriptions, ActivityExecution execution, boolean async) {
        for (CompensateEventSubscriptionEntity eventSubscription : eventSubscriptions) {
            ExecutionEntity compensatingExecution = null;
            if (eventSubscription.getConfiguration() != null) {
                compensatingExecution = Context.getCommandContext().getExecutionManager().findExecutionById(eventSubscription.getConfiguration());
                compensatingExecution.setParent((PvmExecutionImpl)execution);
                compensatingExecution.setEventScope(false);
            } else {
                compensatingExecution = (ExecutionEntity)execution.createExecution();
                eventSubscription.setConfiguration(compensatingExecution.getId());
            }
            compensatingExecution.setConcurrent(true);
        }
        Collections.sort(eventSubscriptions, new Comparator<EventSubscriptionEntity>(){

            @Override
            public int compare(EventSubscriptionEntity o1, EventSubscriptionEntity o2) {
                return o2.getCreated().compareTo(o1.getCreated());
            }
        });
        for (CompensateEventSubscriptionEntity compensateEventSubscriptionEntity : eventSubscriptions) {
            compensateEventSubscriptionEntity.eventReceived(null, async);
        }
    }

    public static void createEventScopeExecution(ExecutionEntity execution) {
        ExecutionEntity eventScope = ScopeUtil.findScopeExecutionForScope(execution, execution.getActivity().getParent());
        List<CompensateEventSubscriptionEntity> eventSubscriptions = execution.getCompensateEventSubscriptions();
        if (eventSubscriptions.size() > 0) {
            ExecutionEntity eventScopeExecution = eventScope.createExecution();
            eventScopeExecution.setActivity(execution.getActivity());
            eventScopeExecution.enterActivityInstance();
            eventScopeExecution.setActive(false);
            eventScopeExecution.setConcurrent(false);
            eventScopeExecution.setEventScope(true);
            execution.setConcurrent(false);
            Map<String, Object> variables = execution.getVariablesLocal();
            for (Map.Entry<String, Object> variable : variables.entrySet()) {
                eventScopeExecution.setVariableLocal(variable.getKey(), variable.getValue());
            }
            for (CompensateEventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
                eventSubscriptionEntity = eventSubscriptionEntity.moveUnder(eventScopeExecution);
            }
            CompensateEventSubscriptionEntity eventSubscription = CompensateEventSubscriptionEntity.createAndInsert(eventScope);
            eventSubscription.setActivity(execution.getActivity());
            eventSubscription.setConfiguration(eventScopeExecution.getId());
        }
    }
}

