/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.bpm.engine.impl.variable.VariableTypes;
import org.camunda.bpm.engine.runtime.VariableInstance;

public abstract class AbstractGetFormVariablesCmd
implements Command<Map<String, VariableInstance>> {
    public String resourceId;
    public Collection<String> formVariableNames;

    public AbstractGetFormVariablesCmd(String resourceId, Collection<String> formVariableNames) {
        this.resourceId = resourceId;
        this.formVariableNames = formVariableNames;
    }

    protected VariableInstance createVariable(FormField formField) {
        VariableInstanceEntity variableInstance = new VariableInstanceEntity();
        variableInstance.setName(formField.getId());
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(formField.getTypeName());
        if (variableType == null) {
            throw new ProcessEngineException("Unsupported variable type '" + formField.getTypeName() + "'.");
        }
        variableInstance.setType(variableType);
        Object defaultValue = formField.getDefaultValue();
        if (defaultValue != null) {
            variableInstance.setValue(defaultValue);
        }
        return variableInstance;
    }
}

