/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetProcessDefinitionVersionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String processInstanceId;
    private final Integer processDefinitionVersion;

    public SetProcessDefinitionVersionCmd(String processInstanceId, Integer processDefinitionVersion) {
        EnsureUtil.ensureNotEmpty("The process instance id is mandatory", "processInstanceId", processInstanceId);
        EnsureUtil.ensureNotNull("The process definition version is mandatory", "processDefinitionVersion", (Object)processDefinitionVersion);
        EnsureUtil.ensurePositive("The process definition version must be positive", "processDefinitionVersion", processDefinitionVersion);
        this.processInstanceId = processInstanceId;
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(this.processInstanceId);
        if (processInstance == null) {
            throw new ProcessEngineException("No process instance found for id = '" + this.processInstanceId + "'.");
        }
        if (!processInstance.isProcessInstanceExecution()) {
            throw new ProcessEngineException("A process instance id is required, but the provided id '" + this.processInstanceId + "' " + "points to a child execution of process instance " + "'" + processInstance.getProcessInstanceId() + "'. " + "Please invoke the " + this.getClass().getSimpleName() + " with a root execution id.");
        }
        ProcessDefinitionImpl currentProcessDefinitionImpl = processInstance.getProcessDefinition();
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity currentProcessDefinition = currentProcessDefinitionImpl instanceof ProcessDefinitionEntity ? (ProcessDefinitionEntity)currentProcessDefinitionImpl : deploymentCache.findDeployedProcessDefinitionById(currentProcessDefinitionImpl.getId());
        ProcessDefinitionEntity newProcessDefinition = deploymentCache.findDeployedProcessDefinitionByKeyAndVersion(currentProcessDefinition.getKey(), this.processDefinitionVersion);
        this.validateAndSwitchVersionOfExecution(commandContext, processInstance, newProcessDefinition);
        HistoricProcessInstanceManager historicProcessInstanceManager = commandContext.getHistoricProcessInstanceManager();
        if (historicProcessInstanceManager.isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance = historicProcessInstanceManager.findHistoricProcessInstance(this.processInstanceId);
            historicProcessInstance.setProcessDefinitionId(newProcessDefinition.getId());
        }
        List<ExecutionEntity> childExecutions = executionManager.findChildExecutionsByParentExecutionId(this.processInstanceId);
        for (ExecutionEntity executionEntity : childExecutions) {
            this.validateAndSwitchVersionOfExecution(commandContext, executionEntity, newProcessDefinition);
        }
        return null;
    }

    protected void validateAndSwitchVersionOfExecution(CommandContext commandContext, ExecutionEntity execution, ProcessDefinitionEntity newProcessDefinition) {
        if (execution.getActivity() != null && !newProcessDefinition.contains(execution.getActivity())) {
            throw new ProcessEngineException("The new process definition (key = '" + newProcessDefinition.getKey() + "') " + "does not contain the current activity " + "(id = '" + execution.getActivity().getId() + "') " + "of the process instance " + "(id = '" + this.processInstanceId + "').");
        }
        execution.setProcessDefinition(newProcessDefinition);
        List<TaskEntity> tasks = commandContext.getTaskManager().findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : tasks) {
            taskEntity.setProcessDefinitionId(newProcessDefinition.getId());
        }
    }
}

