/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageOrTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class StageActivityBehavior
extends StageOrTaskActivityBehavior
implements CompositeActivityBehavior {
    @Override
    protected void performStart(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        List<CmmnActivity> childActivities = activity.getActivities();
        if (childActivities != null && !childActivities.isEmpty()) {
            execution.createChildExecutions(childActivities);
        } else {
            execution.complete();
        }
    }

    @Override
    public void onReactivation(CmmnActivityExecution execution) {
        if (execution.isActive()) {
            throw new ProcessEngineException("Case execution is already active.");
        }
        if (execution.isCaseInstanceExecution()) {
            if (execution.isClosed()) {
                throw new ProcessEngineException("It is not possible to re-activate a closed case instance.");
            }
        } else {
            this.ensureTransitionAllowed(execution, CaseExecutionState.FAILED, CaseExecutionState.ACTIVE, "re-activate");
        }
    }

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.canComplete(execution, false, true);
        this.completing(execution);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.canComplete(execution, true, true);
        this.completing(execution);
    }

    protected boolean canComplete(CmmnActivityExecution execution, boolean manualCompletion, boolean throwException) {
        boolean bl;
        CmmnActivity activity = execution.getActivity();
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children == null || children.isEmpty()) {
            return true;
        }
        for (CmmnExecution cmmnExecution : children) {
            if (!cmmnExecution.isActive()) continue;
            if (throwException) {
                throw new ProcessEngineException("At least one child case execution is active.");
            }
            return false;
        }
        Object autoCompleteProperty = activity.getProperty("autoComplete");
        boolean bl2 = false;
        if (autoCompleteProperty != null) {
            bl = (Boolean)autoCompleteProperty;
        }
        if (bl || manualCompletion) {
            for (CmmnExecution cmmnExecution : children) {
                if (!cmmnExecution.isRequired() || cmmnExecution.isDisabled()) continue;
                if (throwException) {
                    throw new ProcessEngineException("At least one required child case execution is active.");
                }
                return false;
            }
        } else {
            for (CmmnExecution cmmnExecution : children) {
                if (cmmnExecution.isDisabled()) continue;
                if (throwException) {
                    throw new ProcessEngineException("At least one required child case execution is available|enabled|suspended.");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void childStateChanged(CmmnExecution execution, CmmnExecution child) {
        if ((child.isDisabled() || child.isCompleted() || child.isTerminated()) && this.canComplete(execution, false, false)) {
            execution.complete();
        }
    }

    protected CmmnActivityBehavior getActivityBehavior(CmmnActivityExecution execution) {
        String id = execution.getId();
        CmmnActivity activity = execution.getActivity();
        EnsureUtil.ensureNotNull("Case execution '" + id + "': has no current activity", "activity", (Object)activity);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        EnsureUtil.ensureNotNull("There is no behavior specified in " + activity + " for case execution '" + id + "'", "behavior", (Object)behavior);
        return behavior;
    }

    @Override
    protected void terminating(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                CmmnActivityBehavior behavior = this.getActivityBehavior(cmmnExecution);
                if (behavior instanceof StageOrTaskActivityBehavior) {
                    cmmnExecution.exit();
                    continue;
                }
                cmmnExecution.parentTerminate();
            }
        }
    }

    @Override
    protected void suspending(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                CmmnActivityBehavior behavior = this.getActivityBehavior(cmmnExecution);
                if (behavior instanceof StageOrTaskActivityBehavior) {
                    cmmnExecution.parentSuspend();
                    continue;
                }
                cmmnExecution.suspend();
            }
        }
    }

    @Override
    public void resumed(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                CmmnActivityBehavior behavior = this.getActivityBehavior(cmmnExecution);
                if (behavior instanceof StageOrTaskActivityBehavior) {
                    cmmnExecution.parentResume();
                    continue;
                }
                cmmnExecution.resume();
            }
        }
    }

    @Override
    public void reactivated(CmmnActivityExecution execution) {
        CaseExecutionState previousState;
        if (execution.isCaseInstanceExecution() && CaseExecutionState.SUSPENDED.equals(previousState = execution.getPreviousState())) {
            this.resumed(execution);
        }
    }
}

