/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public class GetDeploymentCaseModelCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;

    public GetDeploymentCaseModelCmd(String caseDefinitionId) {
        if (caseDefinitionId == null || caseDefinitionId.length() < 1) {
            throw new ProcessEngineException("The case definition id is mandatory, but '" + caseDefinitionId + "' has been provided.");
        }
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        CaseDefinitionEntity caseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
        String deploymentId = caseDefinition.getDeploymentId();
        String resourceName = caseDefinition.getResourceName();
        InputStream inputStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
        return inputStream;
    }
}

