/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntityVariableStore;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class CaseExecutionEntity
extends CmmnExecution
implements CaseExecution,
CaseInstance,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected transient CaseExecutionEntity caseInstance;
    protected transient CaseExecutionEntity parent;
    protected List<CaseExecutionEntity> caseExecutions;
    protected transient ExecutionEntity subProcessInstance;
    protected transient CaseExecutionEntity subCaseInstance;
    protected transient CaseExecutionEntity superCaseExecution;
    protected CaseExecutionEntityVariableStore variableStore = new CaseExecutionEntityVariableStore(this);
    protected int revision = 1;
    protected String caseDefinitionId;
    protected String activityId;
    protected String activityName;
    protected String caseInstanceId;
    protected String parentId;
    protected String superCaseExecutionId;

    @Override
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    @Override
    public CmmnCaseDefinition getCaseDefinition() {
        this.ensureCaseDefinitionInitialized();
        return this.caseDefinition;
    }

    @Override
    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        super.setCaseDefinition(caseDefinition);
        this.caseDefinitionId = null;
        if (caseDefinition != null) {
            this.caseDefinitionId = caseDefinition.getId();
        }
    }

    protected void ensureCaseDefinitionInitialized() {
        if (this.caseDefinition == null && this.caseDefinitionId != null) {
            CaseDefinitionEntity deployedCaseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
            this.setCaseDefinition(deployedCaseDefinition);
        }
    }

    @Override
    public CaseExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    @Override
    public void setParent(CmmnExecution parent) {
        this.parent = (CaseExecutionEntity)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            this.parent = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.parentId);
        }
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    @Override
    public CmmnActivity getActivity() {
        this.ensureActivityInitialized();
        return super.getActivity();
    }

    @Override
    public void setActivity(CmmnActivity activity) {
        super.setActivity(activity);
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = (String)activity.getProperty("name");
        } else {
            this.activityId = null;
            this.activityName = null;
        }
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.setActivity(this.getCaseDefinition().findActivity(this.activityId));
        }
    }

    public List<CaseExecutionEntity> getCaseExecutions() {
        return new ArrayList<CaseExecutionEntity>(this.getCaseExecutionsInternal());
    }

    protected List<CaseExecutionEntity> getCaseExecutionsInternal() {
        this.ensureCaseExecutionsInitialized();
        return this.caseExecutions;
    }

    protected void ensureCaseExecutionsInitialized() {
        if (this.caseExecutions == null) {
            this.caseExecutions = Context.getCommandContext().getCaseExecutionManager().findChildCaseExecutionsByParentCaseExecutionId(this.id);
        }
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public CaseExecutionEntity getCaseInstance() {
        this.ensureCaseInstanceInitialized();
        return this.caseInstance;
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (CaseExecutionEntity)caseInstance;
        if (caseInstance != null) {
            this.caseInstanceId = this.caseInstance.getId();
        }
    }

    protected void ensureCaseInstanceInitialized() {
        if (this.caseInstance == null && this.caseInstanceId != null) {
            this.caseInstance = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.caseInstanceId);
        }
    }

    @Override
    public boolean isCaseInstanceExecution() {
        return this.parentId == null;
    }

    @Override
    protected CaseExecutionEntity createCaseExecution(CmmnActivity activity) {
        CaseExecutionEntity child = this.newCaseExecution();
        child.setActivity(activity);
        child.setParent(this);
        this.getCaseExecutionsInternal().add(child);
        child.setCaseInstance(this.getCaseInstance());
        child.setCaseDefinition(this.getCaseDefinition());
        return child;
    }

    @Override
    protected CaseExecutionEntity newCaseExecution() {
        CaseExecutionEntity newCaseExecution = new CaseExecutionEntity();
        Context.getCommandContext().getCaseExecutionManager().insertCaseExecution(newCaseExecution);
        return newCaseExecution;
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(PvmExecutionImpl subProcessInstance) {
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition) {
        ExecutionEntity subProcessInstance = (ExecutionEntity)processDefinition.createProcessInstance();
        subProcessInstance.setSuperCaseExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        return subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionManager().findSubProcessInstanceBySuperCaseExecutionId(this.id);
        }
    }

    @Override
    public CaseExecutionEntity getSubCaseInstance() {
        this.ensureSubCaseInstanceInitialized();
        return this.subCaseInstance;
    }

    @Override
    public void setSubCaseInstance(CmmnExecution subCaseInstance) {
        this.subCaseInstance = (CaseExecutionEntity)subCaseInstance;
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition) {
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)caseDefinition.createCaseInstance();
        subCaseInstance.setSuperCaseExecution(this);
        this.setSubCaseInstance(subCaseInstance);
        return subCaseInstance;
    }

    protected void ensureSubCaseInstanceInitialized() {
        if (this.subCaseInstance == null) {
            this.subCaseInstance = Context.getCommandContext().getCaseExecutionManager().findSubCaseInstanceBySuperCaseExecutionId(this.id);
        }
    }

    public String getSuperCaseExecutionId() {
        return this.superCaseExecutionId;
    }

    public void setSuperCaseExecutionId(String superCaseExecutionId) {
        this.superCaseExecutionId = superCaseExecutionId;
    }

    @Override
    public CmmnExecution getSuperCaseExecution() {
        this.ensureSuperCaseExecutionInitialized();
        return this.superCaseExecution;
    }

    @Override
    public void setSuperCaseExecution(CmmnExecution superCaseExecution) {
        this.superCaseExecution = (CaseExecutionEntity)superCaseExecution;
        this.superCaseExecutionId = superCaseExecution != null ? superCaseExecution.getId() : null;
    }

    protected void ensureSuperCaseExecutionInitialized() {
        if (this.superCaseExecution == null && this.superCaseExecutionId != null) {
            this.superCaseExecution = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.superCaseExecutionId);
        }
    }

    @Override
    protected CoreVariableStore getVariableStore() {
        return this.variableStore;
    }

    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setCaseInstanceId(this.caseInstanceId);
        variableInstance.setCaseExecutionId(this.id);
    }

    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByCaseExecutionId(this.id);
    }

    @Override
    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CaseExecution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public void remove() {
        super.remove();
        this.variableStore.removeVariablesWithoutFiringEvents();
        this.removeTask();
        Context.getCommandContext().getCaseExecutionManager().deleteCaseExecution(this);
    }

    protected void removeTask() {
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskByCaseExecutionId(this.getId());
        if (task != null) {
            task.delete("deleted", false);
        }
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("caseDefinitionId", this.caseDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("parentId", this.parentId);
        persistentState.put("currentState", this.currentState);
        persistentState.put("previousState", this.previousState);
        return persistentState;
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance() {
        if (this.caseDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findCmmnModelInstanceForCaseDefinition(this.caseDefinitionId);
        }
        return null;
    }

    @Override
    public CmmnElement getCmmnModelElementInstance() {
        CmmnModelInstance cmmnModelInstance = this.getCmmnModelInstance();
        if (cmmnModelInstance != null) {
            ModelElementInstance modelElementInstance = cmmnModelInstance.getModelElementById(this.activityId);
            return (CmmnElement)modelElementInstance;
        }
        return null;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }
}

