/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment.jobexecutor;

import java.util.Map;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedJobExecutor;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.container.impl.metadata.spi.JobAcquisitionXml;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.RuntimeContainerJobExecutor;

public class StartJobAcquisitionStep
extends MBeanDeploymentOperationStep {
    protected final JobAcquisitionXml jobAcquisitionXml;

    public StartJobAcquisitionStep(JobAcquisitionXml jobAcquisitionXml) {
        this.jobAcquisitionXml = jobAcquisitionXml;
    }

    @Override
    public String getName() {
        return "Start job acquisition '" + this.jobAcquisitionXml.getName() + "'";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        ClassLoader configurationClassloader = null;
        configurationClassloader = processApplication != null ? processApplication.getProcessApplicationClassloader() : ProcessEngineConfiguration.class.getClassLoader();
        String configurationClassName = this.jobAcquisitionXml.getJobExecutorClassName();
        if (configurationClassName == null || configurationClassName.isEmpty()) {
            configurationClassName = RuntimeContainerJobExecutor.class.getName();
        }
        Class<? extends JobExecutor> jobExecutorClass = this.loadJobExecutorClass(configurationClassloader, configurationClassName);
        JobExecutor jobExecutor = this.instantiateJobExecutor(jobExecutorClass);
        Map<String, String> properties = this.jobAcquisitionXml.getProperties();
        PropertyHelper.applyProperties(jobExecutor, properties);
        JmxManagedJobExecutor jmxManagedJobExecutor = new JmxManagedJobExecutor(jobExecutor);
        serviceContainer.startService(JmxRuntimeContainerDelegate.ServiceTypes.JOB_EXECUTOR, this.jobAcquisitionXml.getName(), jmxManagedJobExecutor);
    }

    protected JobExecutor instantiateJobExecutor(Class<? extends JobExecutor> configurationClass) {
        try {
            return configurationClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ProcessEngineException("Could not instantiate job executor class", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessEngineException("IllegalAccessException while instantiating job executor class", e);
        }
    }

    protected Class<? extends JobExecutor> loadJobExecutorClass(ClassLoader processApplicationClassloader, String jobExecutorClassname) {
        try {
            return processApplicationClassloader.loadClass(jobExecutorClassname);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessEngineException("Could not load job executor class", e);
        }
    }
}

