/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.camunda.bpm.connect.rest.httpclient.RestHttpConnector;
import org.camunda.bpm.connect.soap.httpclient.SoapHttpConnector;
import org.camunda.bpm.engine.ArtifactFactory;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.AuthorizationServiceImpl;
import org.camunda.bpm.engine.impl.DefaultArtifactFactory;
import org.camunda.bpm.engine.impl.FormServiceImpl;
import org.camunda.bpm.engine.impl.HistoryServiceImpl;
import org.camunda.bpm.engine.impl.IdentityServiceImpl;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.ServiceImpl;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.application.ProcessApplicationManager;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParser;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendarManager;
import org.camunda.bpm.engine.impl.calendar.CycleBusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.DueDateBusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.DurationBusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.MapBusinessCalendarManager;
import org.camunda.bpm.engine.impl.cfg.BpmnParseFactory;
import org.camunda.bpm.engine.impl.cfg.DefaultBpmnParseFactory;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.JpaHelper;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.TransactionContextFactory;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultAuthorizationProvider;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.cfg.standalone.StandaloneMybatisTransactionContextFactory;
import org.camunda.bpm.engine.impl.cmmn.CaseServiceImpl;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionManager;
import org.camunda.bpm.engine.impl.cmmn.handler.DefaultCmmnElementHandlerRegistry;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformFactory;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformer;
import org.camunda.bpm.engine.impl.cmmn.transformer.DefaultCmmnTranformFactory;
import org.camunda.bpm.engine.impl.connector.Connectors;
import org.camunda.bpm.engine.impl.db.DbIdGenerator;
import org.camunda.bpm.engine.impl.db.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.db.IbatisVariableTypeHandler;
import org.camunda.bpm.engine.impl.delegate.DefaultDelegateInterceptor;
import org.camunda.bpm.engine.impl.digest.PasswordEncryptor;
import org.camunda.bpm.engine.impl.digest.ShaHashDigest;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.event.CompensationEventHandler;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.impl.event.MessageEventHandler;
import org.camunda.bpm.engine.impl.event.SignalEventHandler;
import org.camunda.bpm.engine.impl.form.engine.FormEngine;
import org.camunda.bpm.engine.impl.form.engine.HtmlFormEngine;
import org.camunda.bpm.engine.impl.form.engine.JuelFormEngine;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.camunda.bpm.engine.impl.form.type.BooleanFormType;
import org.camunda.bpm.engine.impl.form.type.DateFormType;
import org.camunda.bpm.engine.impl.form.type.FormTypes;
import org.camunda.bpm.engine.impl.form.type.LongFormType;
import org.camunda.bpm.engine.impl.form.type.StringFormType;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidator;
import org.camunda.bpm.engine.impl.form.validator.FormValidators;
import org.camunda.bpm.engine.impl.form.validator.MaxLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MaxValidator;
import org.camunda.bpm.engine.impl.form.validator.MinLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MinValidator;
import org.camunda.bpm.engine.impl.form.validator.ReadOnlyValidator;
import org.camunda.bpm.engine.impl.form.validator.RequiredValidator;
import org.camunda.bpm.engine.impl.history.handler.DbHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.parser.HistoryParseListener;
import org.camunda.bpm.engine.impl.history.producer.CacheAwareHistoryEventProducer;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.identity.WritableIdentityProvider;
import org.camunda.bpm.engine.impl.identity.db.DbIdentityServiceProvider;
import org.camunda.bpm.engine.impl.incident.FailedJobIncidentHandler;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContextFactory;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutorImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.DelegateInterceptor;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.jobexecutor.AsyncContinuationJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.CallerRunsRejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultFailedJobCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.ProcessEventJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerActivateJobDefinitionHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerActivateProcessDefinitionHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerCatchIntermediateEventJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerExecuteNestedActivityJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerStartEventJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerStartEventSubprocessJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerSuspendJobDefinitionHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerSuspendProcessDefinitionHandler;
import org.camunda.bpm.engine.impl.mail.MailScanner;
import org.camunda.bpm.engine.impl.persistence.GenericManagerFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.CommentManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricStatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkManager;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceManager;
import org.camunda.bpm.engine.impl.persistence.entity.StatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.TableDataManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceManager;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.DefaultCorrelationHandler;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.engine.BeansResolverFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ResolverFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptBindingsFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.camunda.bpm.engine.impl.scripting.engine.VariableScopeResolverFactory;
import org.camunda.bpm.engine.impl.scripting.env.ScriptEnvResolver;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;
import org.camunda.bpm.engine.impl.spin.ProcessEngineSpinSupport;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.impl.variable.BooleanType;
import org.camunda.bpm.engine.impl.variable.ByteArrayType;
import org.camunda.bpm.engine.impl.variable.DateType;
import org.camunda.bpm.engine.impl.variable.DefaultVariableTypes;
import org.camunda.bpm.engine.impl.variable.DoubleType;
import org.camunda.bpm.engine.impl.variable.EntityManagerSession;
import org.camunda.bpm.engine.impl.variable.EntityManagerSessionFactory;
import org.camunda.bpm.engine.impl.variable.IntegerType;
import org.camunda.bpm.engine.impl.variable.JPAEntityVariableType;
import org.camunda.bpm.engine.impl.variable.LongType;
import org.camunda.bpm.engine.impl.variable.NullType;
import org.camunda.bpm.engine.impl.variable.SerializableType;
import org.camunda.bpm.engine.impl.variable.SerializableTypeResolver;
import org.camunda.bpm.engine.impl.variable.SerializationVariableTypeResolver;
import org.camunda.bpm.engine.impl.variable.ShortType;
import org.camunda.bpm.engine.impl.variable.StringType;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.bpm.engine.impl.variable.VariableTypes;

public abstract class ProcessEngineConfigurationImpl
extends ProcessEngineConfiguration {
    private static Logger log = Logger.getLogger(ProcessEngineConfigurationImpl.class.getName());
    public static final String DB_SCHEMA_UPDATE_CREATE = "create";
    public static final String DB_SCHEMA_UPDATE_DROP_CREATE = "drop-create";
    public static final int HISTORYLEVEL_NONE = 0;
    public static final int HISTORYLEVEL_ACTIVITY = 1;
    public static final int HISTORYLEVEL_AUDIT = 2;
    public static final int HISTORYLEVEL_FULL = 3;
    public static final String DEFAULT_WS_SYNC_FACTORY = "org.camunda.bpm.engine.impl.webservice.CxfWebServiceClientFactory";
    public static final String DEFAULT_MYBATIS_MAPPING_FILE = "org/camunda/bpm/engine/impl/mapping/mappings.xml";
    protected RepositoryService repositoryService = new RepositoryServiceImpl();
    protected RuntimeService runtimeService = new RuntimeServiceImpl();
    protected HistoryService historyService = new HistoryServiceImpl();
    protected IdentityService identityService = new IdentityServiceImpl();
    protected TaskService taskService = new TaskServiceImpl();
    protected FormService formService = new FormServiceImpl();
    protected ManagementService managementService = new ManagementServiceImpl();
    protected AuthorizationService authorizationService = new AuthorizationServiceImpl();
    protected CaseService caseService = new CaseServiceImpl();
    protected List<CommandInterceptor> customPreCommandInterceptorsTxRequired;
    protected List<CommandInterceptor> customPostCommandInterceptorsTxRequired;
    protected List<CommandInterceptor> commandInterceptorsTxRequired;
    protected CommandExecutor commandExecutorTxRequired;
    protected List<CommandInterceptor> customPreCommandInterceptorsTxRequiresNew;
    protected List<CommandInterceptor> customPostCommandInterceptorsTxRequiresNew;
    protected List<CommandInterceptor> commandInterceptorsTxRequiresNew;
    protected CommandExecutor commandExecutorTxRequiresNew;
    protected CommandExecutor commandExecutorSchemaOperations;
    protected List<SessionFactory> customSessionFactories;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected List<Deployer> customPreDeployers;
    protected List<Deployer> customPostDeployers;
    protected List<Deployer> deployers;
    protected DeploymentCache deploymentCache;
    protected List<JobHandler> customJobHandlers;
    protected Map<String, JobHandler> jobHandlers;
    protected JobExecutor jobExecutor;
    protected MailScanner mailScanner;
    protected SqlSessionFactory sqlSessionFactory;
    protected TransactionFactory transactionFactory;
    protected IdGenerator idGenerator;
    protected DataSource idGeneratorDataSource;
    protected String idGeneratorDataSourceJndiName;
    protected Map<String, IncidentHandler> incidentHandlers;
    protected List<IncidentHandler> customIncidentHandlers;
    protected List<FormEngine> customFormEngines;
    protected Map<String, FormEngine> formEngines;
    protected List<AbstractFormFieldType> customFormTypes;
    protected FormTypes formTypes;
    protected FormValidators formValidators;
    protected Map<String, Class<? extends FormFieldValidator>> customFormFieldValidators;
    protected List<VariableType> customPreVariableTypes;
    protected List<VariableType> customPostVariableTypes;
    protected VariableTypes variableTypes;
    protected String defaultSerializationFormat;
    protected ExpressionManager expressionManager;
    protected List<String> customScriptingEngineClasses;
    protected ScriptingEngines scriptingEngines;
    protected List<ResolverFactory> resolverFactories;
    protected ScriptingEnvironment scriptingEnvironment;
    protected List<ScriptEnvResolver> scriptEnvResolvers;
    protected ScriptFactory scriptFactory;
    protected boolean autoStoreScriptVariables = false;
    protected boolean enableScriptCompilation = true;
    protected boolean cmmnEnabled = true;
    protected BusinessCalendarManager businessCalendarManager;
    protected String wsSyncFactoryClassName = "org.camunda.bpm.engine.impl.webservice.CxfWebServiceClientFactory";
    protected CommandContextFactory commandContextFactory;
    protected TransactionContextFactory transactionContextFactory;
    protected BpmnParseFactory bpmnParseFactory;
    protected CmmnTransformFactory cmmnTransformFactory;
    protected DefaultCmmnElementHandlerRegistry cmmnElementHandlerRegistry;
    protected int historyLevel;
    protected List<BpmnParseListener> preParseListeners;
    protected List<BpmnParseListener> postParseListeners;
    protected Map<Object, Object> beans;
    protected boolean isDbIdentityUsed = true;
    protected boolean isDbHistoryUsed = true;
    protected DelegateInterceptor delegateInterceptor;
    protected CommandInterceptor actualCommandExecutor;
    protected RejectedJobsHandler customRejectedJobsHandler;
    protected Map<String, EventHandler> eventHandlers;
    protected List<EventHandler> customEventHandlers;
    protected FailedJobCommandFactory failedJobCommandFactory;
    protected String databaseTablePrefix = "";
    protected String databaseSchema = null;
    protected boolean isCreateDiagramOnDeploy = false;
    protected ProcessApplicationManager processApplicationManager;
    protected CorrelationHandler correlationHandler;
    protected SessionFactory identityProviderSessionFactory;
    protected PasswordEncryptor passwordEncryptor;
    protected Set<String> registeredDeployments;
    protected ResourceAuthorizationProvider resourceAuthorizationProvider;
    protected List<ProcessEnginePlugin> processEnginePlugins = new ArrayList<ProcessEnginePlugin>();
    protected HistoryEventProducer historyEventProducer;
    protected HistoryEventHandler historyEventHandler;
    protected boolean isExecutionTreePrefetchEnabled = true;
    protected boolean isDeploymentLockUsed = true;
    protected Connectors connectors;
    protected List<SerializationVariableTypeResolver> serializationTypeResolvers = new ArrayList<SerializationVariableTypeResolver>();
    protected ProcessEngineImpl processEngine;
    protected ArtifactFactory artifactFactory;
    protected static Properties databaseTypeMappings = ProcessEngineConfigurationImpl.getDefaultDatabaseTypeMappings();

    @Override
    public ProcessEngine buildProcessEngine() {
        this.init();
        this.processEngine = new ProcessEngineImpl(this);
        this.invokePostProcessEngineBuild(this.processEngine);
        return this.processEngine;
    }

    protected void init() {
        this.invokePreInit();
        this.initHistoryLevel();
        this.initHistoryEventProducer();
        this.initHistoryEventHandler();
        this.initExpressionManager();
        this.initBeans();
        this.initArtifactFactory();
        this.initFormEngines();
        this.initFormTypes();
        this.initFormFieldValidators();
        this.initScripting();
        this.initBusinessCalendarManager();
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initServices();
        this.initIdGenerator();
        this.initDeployers();
        this.initJobExecutor();
        this.initMailScanner();
        this.initDataSource();
        this.initTransactionFactory();
        this.initSqlSessionFactory();
        this.initIdentityProviderSessionFactory();
        this.initSessionFactories();
        this.initSpin();
        this.initSerializationTypeResolvers();
        this.initVariableTypes();
        this.initJpa();
        this.initDelegateInterceptor();
        this.initEventHandlers();
        this.initFailedJobCommandFactory();
        this.initProcessApplicationManager();
        this.initCorrelationHandler();
        this.initIncidentHandlers();
        this.initPasswordDigest();
        this.initDeploymentRegistration();
        this.initResourceAuthorizationProvider();
        this.initConnectors();
        this.invokePostInit();
    }

    protected void invokePreInit() {
        for (ProcessEnginePlugin plugin : this.processEnginePlugins) {
            log.log(Level.INFO, "PLUGIN {0} activated on process engine {1}", new String[]{plugin.getClass().getSimpleName(), this.getProcessEngineName()});
            plugin.preInit(this);
        }
    }

    protected void invokePostInit() {
        for (ProcessEnginePlugin plugin : this.processEnginePlugins) {
            plugin.postInit(this);
        }
    }

    protected void invokePostProcessEngineBuild(ProcessEngine engine) {
        for (ProcessEnginePlugin plugin : this.processEnginePlugins) {
            plugin.postProcessEngineBuild(engine);
        }
    }

    protected void initFailedJobCommandFactory() {
        if (this.failedJobCommandFactory == null) {
            this.failedJobCommandFactory = new DefaultFailedJobCommandFactory();
        }
    }

    protected void initIncidentHandlers() {
        if (this.incidentHandlers == null) {
            this.incidentHandlers = new HashMap<String, IncidentHandler>();
            FailedJobIncidentHandler failedJobIncidentHandler = new FailedJobIncidentHandler();
            this.incidentHandlers.put(failedJobIncidentHandler.getIncidentHandlerType(), failedJobIncidentHandler);
        }
        if (this.customIncidentHandlers != null) {
            for (IncidentHandler incidentHandler : this.customIncidentHandlers) {
                this.incidentHandlers.put(incidentHandler.getIncidentHandlerType(), incidentHandler);
            }
        }
    }

    protected abstract Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired();

    protected abstract Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew();

    protected void initCommandExecutors() {
        this.initActualCommandExecutor();
        this.initCommandInterceptorsTxRequired();
        this.initCommandExecutorTxRequired();
        this.initCommandInterceptorsTxRequiresNew();
        this.initCommandExecutorTxRequiresNew();
        this.initCommandExecutorDbSchemaOperations();
    }

    protected void initActualCommandExecutor() {
        this.actualCommandExecutor = new CommandExecutorImpl();
    }

    protected void initCommandInterceptorsTxRequired() {
        if (this.commandInterceptorsTxRequired == null) {
            this.commandInterceptorsTxRequired = this.customPreCommandInterceptorsTxRequired != null ? new ArrayList<CommandInterceptor>(this.customPreCommandInterceptorsTxRequired) : new ArrayList<CommandInterceptor>();
            this.commandInterceptorsTxRequired.addAll(this.getDefaultCommandInterceptorsTxRequired());
            if (this.customPostCommandInterceptorsTxRequired != null) {
                this.commandInterceptorsTxRequired.addAll(this.customPostCommandInterceptorsTxRequired);
            }
            this.commandInterceptorsTxRequired.add(this.actualCommandExecutor);
        }
    }

    protected void initCommandInterceptorsTxRequiresNew() {
        if (this.commandInterceptorsTxRequiresNew == null) {
            this.commandInterceptorsTxRequiresNew = this.customPreCommandInterceptorsTxRequiresNew != null ? new ArrayList<CommandInterceptor>(this.customPreCommandInterceptorsTxRequiresNew) : new ArrayList<CommandInterceptor>();
            this.commandInterceptorsTxRequiresNew.addAll(this.getDefaultCommandInterceptorsTxRequiresNew());
            if (this.customPostCommandInterceptorsTxRequiresNew != null) {
                this.commandInterceptorsTxRequiresNew.addAll(this.customPostCommandInterceptorsTxRequiresNew);
            }
            this.commandInterceptorsTxRequiresNew.add(this.actualCommandExecutor);
        }
    }

    protected void initCommandExecutorTxRequired() {
        if (this.commandExecutorTxRequired == null) {
            this.commandExecutorTxRequired = this.initInterceptorChain(this.commandInterceptorsTxRequired);
        }
    }

    protected void initCommandExecutorTxRequiresNew() {
        if (this.commandExecutorTxRequiresNew == null) {
            this.commandExecutorTxRequiresNew = this.initInterceptorChain(this.commandInterceptorsTxRequiresNew);
        }
    }

    protected void initCommandExecutorDbSchemaOperations() {
        if (this.commandExecutorSchemaOperations == null) {
            this.commandExecutorSchemaOperations = this.commandExecutorTxRequired;
        }
    }

    protected CommandInterceptor initInterceptorChain(List<CommandInterceptor> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new ProcessEngineException("invalid command interceptor chain configuration: " + chain);
        }
        for (int i = 0; i < chain.size() - 1; ++i) {
            chain.get(i).setNext(chain.get(i + 1));
        }
        return chain.get(0);
    }

    protected void initServices() {
        this.initService(this.repositoryService);
        this.initService(this.runtimeService);
        this.initService(this.historyService);
        this.initService(this.identityService);
        this.initService(this.taskService);
        this.initService(this.formService);
        this.initService(this.managementService);
        this.initService(this.authorizationService);
        this.initService(this.caseService);
    }

    protected void initService(Object service) {
        if (service instanceof ServiceImpl) {
            ((ServiceImpl)service).setCommandExecutor(this.commandExecutorTxRequired);
        }
    }

    protected void initDataSource() {
        if (this.dataSource == null) {
            if (this.dataSourceJndiName != null) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(this.dataSourceJndiName);
                }
                catch (Exception e) {
                    throw new ProcessEngineException("couldn't lookup datasource from " + this.dataSourceJndiName + ": " + e.getMessage(), e);
                }
            } else if (this.jdbcUrl != null) {
                if (this.jdbcDriver == null || this.jdbcUrl == null || this.jdbcUsername == null) {
                    throw new ProcessEngineException("DataSource or JDBC properties have to be specified in a process engine configuration");
                }
                log.fine("initializing datasource to db: " + this.jdbcUrl);
                PooledDataSource pooledDataSource = new PooledDataSource(ReflectUtil.getClassLoader(), this.jdbcDriver, this.jdbcUrl, this.jdbcUsername, this.jdbcPassword);
                if (this.jdbcMaxActiveConnections > 0) {
                    pooledDataSource.setPoolMaximumActiveConnections(this.jdbcMaxActiveConnections);
                }
                if (this.jdbcMaxIdleConnections > 0) {
                    pooledDataSource.setPoolMaximumIdleConnections(this.jdbcMaxIdleConnections);
                }
                if (this.jdbcMaxCheckoutTime > 0) {
                    pooledDataSource.setPoolMaximumCheckoutTime(this.jdbcMaxCheckoutTime);
                }
                if (this.jdbcMaxWaitTime > 0) {
                    pooledDataSource.setPoolTimeToWait(this.jdbcMaxWaitTime);
                }
                if (this.jdbcPingEnabled) {
                    pooledDataSource.setPoolPingEnabled(true);
                    if (this.jdbcPingQuery != null) {
                        pooledDataSource.setPoolPingQuery(this.jdbcPingQuery);
                    }
                    pooledDataSource.setPoolPingConnectionsNotUsedFor(this.jdbcPingConnectionNotUsedFor);
                }
                this.dataSource = pooledDataSource;
            }
            if (this.dataSource instanceof PooledDataSource) {
                ((PooledDataSource)this.dataSource).forceCloseAll();
            }
        }
        if (this.databaseType == null) {
            this.initDatabaseType();
        }
    }

    protected static Properties getDefaultDatabaseTypeMappings() {
        Properties databaseTypeMappings = new Properties();
        databaseTypeMappings.setProperty("H2", "h2");
        databaseTypeMappings.setProperty("MySQL", "mysql");
        databaseTypeMappings.setProperty("Oracle", "oracle");
        databaseTypeMappings.setProperty("PostgreSQL", "postgres");
        databaseTypeMappings.setProperty("Microsoft SQL Server", "mssql");
        databaseTypeMappings.setProperty("DB2", "db2");
        databaseTypeMappings.setProperty("DB2", "db2");
        databaseTypeMappings.setProperty("DB2/NT", "db2");
        databaseTypeMappings.setProperty("DB2/NT64", "db2");
        databaseTypeMappings.setProperty("DB2 UDP", "db2");
        databaseTypeMappings.setProperty("DB2/LINUX", "db2");
        databaseTypeMappings.setProperty("DB2/LINUX390", "db2");
        databaseTypeMappings.setProperty("DB2/LINUXX8664", "db2");
        databaseTypeMappings.setProperty("DB2/LINUXZ64", "db2");
        databaseTypeMappings.setProperty("DB2/400 SQL", "db2");
        databaseTypeMappings.setProperty("DB2/6000", "db2");
        databaseTypeMappings.setProperty("DB2 UDB iSeries", "db2");
        databaseTypeMappings.setProperty("DB2/AIX64", "db2");
        databaseTypeMappings.setProperty("DB2/HPUX", "db2");
        databaseTypeMappings.setProperty("DB2/HP64", "db2");
        databaseTypeMappings.setProperty("DB2/SUN", "db2");
        databaseTypeMappings.setProperty("DB2/SUN64", "db2");
        databaseTypeMappings.setProperty("DB2/PTX", "db2");
        databaseTypeMappings.setProperty("DB2/2", "db2");
        return databaseTypeMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDatabaseType() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            log.fine("database product name: '" + databaseProductName + "'");
            this.databaseType = databaseTypeMappings.getProperty(databaseProductName);
            EnsureUtil.ensureNotNull("couldn't deduct database type from database product name '" + databaseProductName + "'", "databaseType", (Object)this.databaseType);
            log.fine("using database type: " + this.databaseType);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected void initTransactionFactory() {
        if (this.transactionFactory == null) {
            this.transactionFactory = this.transactionsExternallyManaged ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        }
    }

    protected void initSqlSessionFactory() {
        if (this.sqlSessionFactory == null) {
            InputStream inputStream = null;
            try {
                inputStream = this.getMyBatisXmlConfigurationSteam();
                Environment environment = new Environment("default", this.transactionFactory, this.dataSource);
                InputStreamReader reader = new InputStreamReader(inputStream);
                Properties properties = new Properties();
                properties.put("prefix", this.databaseTablePrefix);
                if (this.databaseType != null) {
                    properties.put("limitBefore", DbSqlSessionFactory.databaseSpecificLimitBeforeStatements.get(this.databaseType));
                    properties.put("limitAfter", DbSqlSessionFactory.databaseSpecificLimitAfterStatements.get(this.databaseType));
                    properties.put("limitBetween", DbSqlSessionFactory.databaseSpecificLimitBetweenStatements.get(this.databaseType));
                    properties.put("orderBy", DbSqlSessionFactory.databaseSpecificOrderByStatements.get(this.databaseType));
                    properties.put("limitBeforeNativeQuery", DbSqlSessionFactory.databaseSpecificLimitBeforeNativeQueryStatements.get(this.databaseType));
                    properties.put("bitand1", DbSqlSessionFactory.databaseSpecificBitAnd1.get(this.databaseType));
                    properties.put("bitand2", DbSqlSessionFactory.databaseSpecificBitAnd2.get(this.databaseType));
                    properties.put("bitand3", DbSqlSessionFactory.databaseSpecificBitAnd3.get(this.databaseType));
                    properties.put("dateDiff1", DbSqlSessionFactory.databaseSpecificDateDiff1.get(this.databaseType));
                    properties.put("dateDiff2", DbSqlSessionFactory.databaseSpecificDateDiff2.get(this.databaseType));
                    properties.put("dateDiff3", DbSqlSessionFactory.databaseSpecificDateDiff3.get(this.databaseType));
                    properties.put("trueConstant", DbSqlSessionFactory.databaseSpecificTrueConstant.get(this.databaseType));
                    properties.put("falseConstant", DbSqlSessionFactory.databaseSpecificFalseConstant.get(this.databaseType));
                    properties.put("dbSpecificDummyTable", DbSqlSessionFactory.databaseSpecificDummyTable.get(this.databaseType));
                    Map<String, String> constants = DbSqlSessionFactory.dbSpecificConstants.get(this.databaseType);
                    for (Map.Entry<String, String> entry : constants.entrySet()) {
                        properties.put(entry.getKey(), entry.getValue());
                    }
                }
                XMLConfigBuilder parser = new XMLConfigBuilder((Reader)reader, "", properties);
                Configuration configuration = parser.getConfiguration();
                configuration.setEnvironment(environment);
                configuration.getTypeHandlerRegistry().register(VariableType.class, JdbcType.VARCHAR, (TypeHandler)new IbatisVariableTypeHandler());
                configuration = parser.parse();
                this.sqlSessionFactory = new DefaultSqlSessionFactory(configuration);
            }
            catch (Exception e) {
                throw new ProcessEngineException("Error while building ibatis SqlSessionFactory: " + e.getMessage(), e);
            }
            finally {
                IoUtil.closeSilently(inputStream);
            }
        }
    }

    protected InputStream getMyBatisXmlConfigurationSteam() {
        return ReflectUtil.getResourceAsStream(DEFAULT_MYBATIS_MAPPING_FILE);
    }

    protected void initIdentityProviderSessionFactory() {
        if (this.identityProviderSessionFactory == null) {
            this.identityProviderSessionFactory = new GenericManagerFactory(DbIdentityServiceProvider.class);
        }
    }

    protected void initSessionFactories() {
        if (this.sessionFactories == null) {
            this.sessionFactories = new HashMap();
            this.dbSqlSessionFactory = new DbSqlSessionFactory();
            this.dbSqlSessionFactory.setDatabaseType(this.databaseType);
            this.dbSqlSessionFactory.setIdGenerator(this.idGenerator);
            this.dbSqlSessionFactory.setSqlSessionFactory(this.sqlSessionFactory);
            this.dbSqlSessionFactory.setDbIdentityUsed(this.isDbIdentityUsed);
            this.dbSqlSessionFactory.setDbHistoryUsed(this.isDbHistoryUsed);
            this.dbSqlSessionFactory.setCmmnEnabled(this.cmmnEnabled);
            this.dbSqlSessionFactory.setDatabaseTablePrefix(this.databaseTablePrefix);
            this.dbSqlSessionFactory.setDatabaseSchema(this.databaseSchema);
            this.addSessionFactory(this.dbSqlSessionFactory);
            this.addSessionFactory(new GenericManagerFactory(AttachmentManager.class));
            this.addSessionFactory(new GenericManagerFactory(CommentManager.class));
            this.addSessionFactory(new GenericManagerFactory(DeploymentManager.class));
            this.addSessionFactory(new GenericManagerFactory(ExecutionManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricActivityInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricStatisticsManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricDetailManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricProcessInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(UserOperationLogManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricTaskInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricVariableInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricIncidentManager.class));
            this.addSessionFactory(new GenericManagerFactory(IdentityInfoManager.class));
            this.addSessionFactory(new GenericManagerFactory(IdentityLinkManager.class));
            this.addSessionFactory(new GenericManagerFactory(JobManager.class));
            this.addSessionFactory(new GenericManagerFactory(JobDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(ProcessDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(PropertyManager.class));
            this.addSessionFactory(new GenericManagerFactory(ResourceManager.class));
            this.addSessionFactory(new GenericManagerFactory(ByteArrayManager.class));
            this.addSessionFactory(new GenericManagerFactory(TableDataManager.class));
            this.addSessionFactory(new GenericManagerFactory(TaskManager.class));
            this.addSessionFactory(new GenericManagerFactory(VariableInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(EventSubscriptionManager.class));
            this.addSessionFactory(new GenericManagerFactory(StatisticsManager.class));
            this.addSessionFactory(new GenericManagerFactory(IncidentManager.class));
            this.addSessionFactory(new GenericManagerFactory(AuthorizationManager.class));
            this.addSessionFactory(new GenericManagerFactory(CaseDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(CaseExecutionManager.class));
            this.sessionFactories.put(ReadOnlyIdentityProvider.class, this.identityProviderSessionFactory);
            Class<?> identityProviderType = this.identityProviderSessionFactory.getSessionType();
            if (WritableIdentityProvider.class.isAssignableFrom(identityProviderType)) {
                this.sessionFactories.put(WritableIdentityProvider.class, this.identityProviderSessionFactory);
            }
        }
        if (this.customSessionFactories != null) {
            for (SessionFactory sessionFactory : this.customSessionFactories) {
                this.addSessionFactory(sessionFactory);
            }
        }
    }

    protected void addSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactories.put(sessionFactory.getSessionType(), sessionFactory);
    }

    protected void initDeployers() {
        if (this.deployers == null) {
            this.deployers = new ArrayList<Deployer>();
            if (this.customPreDeployers != null) {
                this.deployers.addAll(this.customPreDeployers);
            }
            this.deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                this.deployers.addAll(this.customPostDeployers);
            }
        }
        if (this.deploymentCache == null) {
            ArrayList<Deployer> deployers = new ArrayList<Deployer>();
            if (this.customPreDeployers != null) {
                deployers.addAll(this.customPreDeployers);
            }
            deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                deployers.addAll(this.customPostDeployers);
            }
            this.deploymentCache = new DeploymentCache();
            this.deploymentCache.setDeployers(deployers);
        }
    }

    protected Collection<? extends Deployer> getDefaultDeployers() {
        ArrayList<Deployer> defaultDeployers = new ArrayList<Deployer>();
        BpmnDeployer bpmnDeployer = this.getBpmnDeployer();
        defaultDeployers.add(bpmnDeployer);
        if (this.isCmmnEnabled()) {
            CmmnDeployer cmmnDeployer = this.getCmmnDeployer();
            defaultDeployers.add(cmmnDeployer);
        }
        return defaultDeployers;
    }

    protected BpmnDeployer getBpmnDeployer() {
        BpmnDeployer bpmnDeployer = new BpmnDeployer();
        bpmnDeployer.setExpressionManager(this.expressionManager);
        bpmnDeployer.setIdGenerator(this.idGenerator);
        if (this.bpmnParseFactory == null) {
            this.bpmnParseFactory = new DefaultBpmnParseFactory();
        }
        BpmnParser bpmnParser = new BpmnParser(this.expressionManager, this.bpmnParseFactory);
        if (this.preParseListeners != null) {
            bpmnParser.getParseListeners().addAll(this.preParseListeners);
        }
        bpmnParser.getParseListeners().addAll(this.getDefaultBPMNParseListeners());
        if (this.postParseListeners != null) {
            bpmnParser.getParseListeners().addAll(this.postParseListeners);
        }
        bpmnDeployer.setBpmnParser(bpmnParser);
        return bpmnDeployer;
    }

    protected List<BpmnParseListener> getDefaultBPMNParseListeners() {
        ArrayList<BpmnParseListener> defaultListeners = new ArrayList<BpmnParseListener>();
        if (this.historyLevel >= 1) {
            defaultListeners.add(new HistoryParseListener(this.historyLevel, this.historyEventProducer));
        }
        return defaultListeners;
    }

    protected CmmnDeployer getCmmnDeployer() {
        CmmnDeployer cmmnDeployer = new CmmnDeployer();
        cmmnDeployer.setIdGenerator(this.idGenerator);
        if (this.cmmnTransformFactory == null) {
            this.cmmnTransformFactory = new DefaultCmmnTranformFactory();
        }
        if (this.cmmnElementHandlerRegistry == null) {
            this.cmmnElementHandlerRegistry = new DefaultCmmnElementHandlerRegistry();
        }
        CmmnTransformer cmmnTransformer = new CmmnTransformer(this.expressionManager, this.cmmnElementHandlerRegistry, this.cmmnTransformFactory);
        cmmnDeployer.setTransformer(cmmnTransformer);
        return cmmnDeployer;
    }

    protected void initJobExecutor() {
        if (this.jobExecutor == null) {
            this.jobExecutor = new DefaultJobExecutor();
        }
        this.jobHandlers = new HashMap<String, JobHandler>();
        TimerExecuteNestedActivityJobHandler timerExecuteNestedActivityJobHandler = new TimerExecuteNestedActivityJobHandler();
        this.jobHandlers.put(timerExecuteNestedActivityJobHandler.getType(), timerExecuteNestedActivityJobHandler);
        TimerCatchIntermediateEventJobHandler timerCatchIntermediateEvent = new TimerCatchIntermediateEventJobHandler();
        this.jobHandlers.put(timerCatchIntermediateEvent.getType(), timerCatchIntermediateEvent);
        TimerStartEventJobHandler timerStartEvent = new TimerStartEventJobHandler();
        this.jobHandlers.put(timerStartEvent.getType(), timerStartEvent);
        TimerStartEventSubprocessJobHandler timerStartEventSubprocess = new TimerStartEventSubprocessJobHandler();
        this.jobHandlers.put(timerStartEventSubprocess.getType(), timerStartEventSubprocess);
        AsyncContinuationJobHandler asyncContinuationJobHandler = new AsyncContinuationJobHandler();
        this.jobHandlers.put(asyncContinuationJobHandler.getType(), asyncContinuationJobHandler);
        ProcessEventJobHandler processEventJobHandler = new ProcessEventJobHandler();
        this.jobHandlers.put(processEventJobHandler.getType(), processEventJobHandler);
        TimerSuspendProcessDefinitionHandler suspendProcessDefinitionHandler = new TimerSuspendProcessDefinitionHandler();
        this.jobHandlers.put(suspendProcessDefinitionHandler.getType(), suspendProcessDefinitionHandler);
        TimerActivateProcessDefinitionHandler activateProcessDefinitionHandler = new TimerActivateProcessDefinitionHandler();
        this.jobHandlers.put(activateProcessDefinitionHandler.getType(), activateProcessDefinitionHandler);
        TimerSuspendJobDefinitionHandler suspendJobDefinitionHandler = new TimerSuspendJobDefinitionHandler();
        this.jobHandlers.put(suspendJobDefinitionHandler.getType(), suspendJobDefinitionHandler);
        TimerActivateJobDefinitionHandler activateJobDefinitionHandler = new TimerActivateJobDefinitionHandler();
        this.jobHandlers.put(activateJobDefinitionHandler.getType(), activateJobDefinitionHandler);
        if (this.getCustomJobHandlers() != null) {
            for (JobHandler customJobHandler : this.getCustomJobHandlers()) {
                this.jobHandlers.put(customJobHandler.getType(), customJobHandler);
            }
        }
        this.jobExecutor.setAutoActivate(this.jobExecutorActivate);
        if (this.jobExecutor.getRejectedJobsHandler() == null) {
            if (this.customRejectedJobsHandler != null) {
                this.jobExecutor.setRejectedJobsHandler(this.customRejectedJobsHandler);
            } else {
                this.jobExecutor.setRejectedJobsHandler(new CallerRunsRejectedJobsHandler());
            }
        }
    }

    protected void initMailScanner() {
        if (this.mailScanner == null) {
            this.mailScanner = new MailScanner();
        }
        this.mailScanner.setCommandExecutor(this.commandExecutorTxRequired);
    }

    public void initHistoryLevel() {
        if ("none".equalsIgnoreCase(this.history)) {
            this.historyLevel = 0;
        } else if ("activity".equalsIgnoreCase(this.history)) {
            this.historyLevel = 1;
        } else if ("variable".equalsIgnoreCase(this.history)) {
            this.historyLevel = 1;
            log.warning("Using deprecated history level 'variable'. This history level is deprecated and replaced by 'activity'. Consider using 'ACTIVITY' instead.");
        } else if ("audit".equalsIgnoreCase(this.history)) {
            this.historyLevel = 2;
        } else if ("full".equalsIgnoreCase(this.history)) {
            this.historyLevel = 3;
        } else {
            throw new ProcessEngineException("invalid history level: " + this.history);
        }
    }

    protected void initIdGenerator() {
        if (this.idGenerator == null) {
            StandaloneProcessEngineConfiguration processEngineConfiguration;
            CommandExecutor idGeneratorCommandExecutor = null;
            if (this.idGeneratorDataSource != null) {
                processEngineConfiguration = new StandaloneProcessEngineConfiguration();
                processEngineConfiguration.setDataSource(this.idGeneratorDataSource);
                processEngineConfiguration.setDatabaseSchemaUpdate("false");
                processEngineConfiguration.init();
                idGeneratorCommandExecutor = processEngineConfiguration.getCommandExecutorTxRequiresNew();
            } else if (this.idGeneratorDataSourceJndiName != null) {
                processEngineConfiguration = new StandaloneProcessEngineConfiguration();
                processEngineConfiguration.setDataSourceJndiName(this.idGeneratorDataSourceJndiName);
                processEngineConfiguration.setDatabaseSchemaUpdate("false");
                processEngineConfiguration.init();
                idGeneratorCommandExecutor = processEngineConfiguration.getCommandExecutorTxRequiresNew();
            } else {
                idGeneratorCommandExecutor = this.commandExecutorTxRequiresNew;
            }
            DbIdGenerator dbIdGenerator = new DbIdGenerator();
            dbIdGenerator.setIdBlockSize(this.idBlockSize);
            dbIdGenerator.setCommandExecutor(idGeneratorCommandExecutor);
            this.idGenerator = dbIdGenerator;
        }
    }

    protected void initCommandContextFactory() {
        if (this.commandContextFactory == null) {
            this.commandContextFactory = new CommandContextFactory();
            this.commandContextFactory.setProcessEngineConfiguration(this);
        }
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new StandaloneMybatisTransactionContextFactory();
        }
    }

    protected void initSerializationTypeResolvers() {
        this.serializationTypeResolvers.add(new SerializableTypeResolver());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initVariableTypes() {
        if (this.variableTypes != null) return;
        this.variableTypes = new DefaultVariableTypes();
        if (this.customPreVariableTypes != null) {
            for (VariableType customVariableType : this.customPreVariableTypes) {
                this.variableTypes.addType(customVariableType);
            }
        }
        this.variableTypes.addType(new NullType());
        this.variableTypes.addType(new StringType());
        this.variableTypes.addType(new BooleanType());
        this.variableTypes.addType(new ShortType());
        this.variableTypes.addType(new IntegerType());
        this.variableTypes.addType(new LongType());
        this.variableTypes.addType(new DateType());
        this.variableTypes.addType(new DoubleType());
        this.variableTypes.addType(new ByteArrayType());
        if (this.defaultSerializationFormat != null) {
            SerializationVariableTypeResolver resolver;
            this.defaultSerializationFormat = this.defaultSerializationFormat.trim();
            VariableType serializationType = null;
            Iterator<SerializationVariableTypeResolver> i$ = this.serializationTypeResolvers.iterator();
            while (i$.hasNext() && (serializationType = (resolver = i$.next()).getTypeForSerializationFormat(this.defaultSerializationFormat)) == null) {
            }
            if (serializationType == null) throw new ProcessEngineException("Cannot find a VariableType that serializes objects for the default format '" + this.defaultSerializationFormat + "'");
            this.variableTypes.addType(serializationType);
        } else {
            this.variableTypes.addType(new SerializableType());
        }
        if (this.customPostVariableTypes == null) return;
        for (VariableType customVariableType : this.customPostVariableTypes) {
            this.variableTypes.addType(customVariableType);
        }
    }

    protected void initFormEngines() {
        if (this.formEngines == null) {
            this.formEngines = new HashMap<String, FormEngine>();
            HtmlFormEngine defaultFormEngine = new HtmlFormEngine();
            this.formEngines.put(null, defaultFormEngine);
            this.formEngines.put(defaultFormEngine.getName(), defaultFormEngine);
            JuelFormEngine juelFormEngine = new JuelFormEngine();
            this.formEngines.put(juelFormEngine.getName(), juelFormEngine);
        }
        if (this.customFormEngines != null) {
            for (FormEngine formEngine : this.customFormEngines) {
                this.formEngines.put(formEngine.getName(), formEngine);
            }
        }
    }

    protected void initFormTypes() {
        if (this.formTypes == null) {
            this.formTypes = new FormTypes();
            this.formTypes.addFormType(new StringFormType());
            this.formTypes.addFormType(new LongFormType());
            this.formTypes.addFormType(new DateFormType("dd/MM/yyyy"));
            this.formTypes.addFormType(new BooleanFormType());
        }
        if (this.customFormTypes != null) {
            for (AbstractFormFieldType customFormType : this.customFormTypes) {
                this.formTypes.addFormType(customFormType);
            }
        }
    }

    protected void initFormFieldValidators() {
        if (this.formValidators == null) {
            this.formValidators = new FormValidators();
            this.formValidators.addValidator("min", MinValidator.class);
            this.formValidators.addValidator("max", MaxValidator.class);
            this.formValidators.addValidator("minlength", MinLengthValidator.class);
            this.formValidators.addValidator("maxlength", MaxLengthValidator.class);
            this.formValidators.addValidator("required", RequiredValidator.class);
            this.formValidators.addValidator("readonly", ReadOnlyValidator.class);
        }
        if (this.customFormFieldValidators != null) {
            for (Map.Entry<String, Class<? extends FormFieldValidator>> validator : this.customFormFieldValidators.entrySet()) {
                this.formValidators.addValidator(validator.getKey(), validator.getValue());
            }
        }
    }

    protected void initScripting() {
        if (this.resolverFactories == null) {
            this.resolverFactories = new ArrayList<ResolverFactory>();
            this.resolverFactories.add(new VariableScopeResolverFactory());
            this.resolverFactories.add(new BeansResolverFactory());
        }
        if (this.scriptingEngines == null) {
            this.scriptingEngines = new ScriptingEngines(new ScriptBindingsFactory(this.resolverFactories));
        }
        if (this.scriptFactory == null) {
            this.scriptFactory = new ScriptFactory(this.scriptingEngines);
        }
        if (this.scriptEnvResolvers == null) {
            this.scriptEnvResolvers = new ArrayList<ScriptEnvResolver>();
        }
        if (this.scriptingEnvironment == null) {
            this.scriptingEnvironment = new ScriptingEnvironment(this.scriptFactory, this.scriptEnvResolvers);
        }
    }

    protected void initSpin() {
        if (ProcessEngineSpinSupport.isSpinAvailable()) {
            log.info("Spin available: camunda Spin is found on the classpath. Spin support is available in Expression Language and Scripts.");
            this.scriptEnvResolvers.add(ProcessEngineSpinSupport.getScriptEnvResolver());
            this.expressionManager.addFunctionMapper(ProcessEngineSpinSupport.getElFunctionMapper());
            this.serializationTypeResolvers.add(ProcessEngineSpinSupport.getVariableTypeResolver());
        } else {
            log.info("Spin unavailable: camunda Spin is not found on the classpath.");
        }
    }

    protected void initConnectors() {
        if (this.connectors == null) {
            this.connectors = new Connectors();
            this.connectors.addConnector("soap-http-connector", SoapHttpConnector.class);
            this.connectors.addConnector("rest-http-connector", RestHttpConnector.class);
        }
    }

    protected void initExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = new ExpressionManager(this.beans);
        }
    }

    protected void initBusinessCalendarManager() {
        if (this.businessCalendarManager == null) {
            MapBusinessCalendarManager mapBusinessCalendarManager = new MapBusinessCalendarManager();
            mapBusinessCalendarManager.addBusinessCalendar(DurationBusinessCalendar.NAME, new DurationBusinessCalendar());
            mapBusinessCalendarManager.addBusinessCalendar("dueDate", new DueDateBusinessCalendar());
            mapBusinessCalendarManager.addBusinessCalendar(CycleBusinessCalendar.NAME, new CycleBusinessCalendar());
            this.businessCalendarManager = mapBusinessCalendarManager;
        }
    }

    protected void initDelegateInterceptor() {
        if (this.delegateInterceptor == null) {
            this.delegateInterceptor = new DefaultDelegateInterceptor();
        }
    }

    protected void initEventHandlers() {
        if (this.eventHandlers == null) {
            this.eventHandlers = new HashMap<String, EventHandler>();
            SignalEventHandler signalEventHander = new SignalEventHandler();
            this.eventHandlers.put(signalEventHander.getEventHandlerType(), signalEventHander);
            CompensationEventHandler compensationEventHandler = new CompensationEventHandler();
            this.eventHandlers.put(compensationEventHandler.getEventHandlerType(), compensationEventHandler);
            MessageEventHandler messageEventHandler = new MessageEventHandler();
            this.eventHandlers.put(messageEventHandler.getEventHandlerType(), messageEventHandler);
        }
        if (this.customEventHandlers != null) {
            for (EventHandler eventHandler : this.customEventHandlers) {
                this.eventHandlers.put(eventHandler.getEventHandlerType(), eventHandler);
            }
        }
    }

    protected void initJpa() {
        if (this.jpaPersistenceUnitName != null) {
            this.jpaEntityManagerFactory = JpaHelper.createEntityManagerFactory(this.jpaPersistenceUnitName);
        }
        if (this.jpaEntityManagerFactory != null) {
            this.sessionFactories.put(EntityManagerSession.class, new EntityManagerSessionFactory(this.jpaEntityManagerFactory, this.jpaHandleTransaction, this.jpaCloseEntityManager));
            VariableType jpaType = this.variableTypes.getVariableType("jpa-entity");
            if (jpaType == null) {
                int serializableIndex = this.variableTypes.getTypeIndex("serializable");
                if (serializableIndex > -1) {
                    this.variableTypes.addType(new JPAEntityVariableType(), serializableIndex);
                } else {
                    this.variableTypes.addType(new JPAEntityVariableType());
                }
            }
        }
    }

    protected void initBeans() {
        if (this.beans == null) {
            this.beans = new HashMap<Object, Object>();
        }
    }

    protected void initArtifactFactory() {
        if (this.artifactFactory == null) {
            this.artifactFactory = new DefaultArtifactFactory();
        }
    }

    protected void initProcessApplicationManager() {
        if (this.processApplicationManager == null) {
            this.processApplicationManager = new ProcessApplicationManager();
        }
    }

    protected void initCorrelationHandler() {
        if (this.correlationHandler == null) {
            this.correlationHandler = new DefaultCorrelationHandler();
        }
    }

    protected void initHistoryEventProducer() {
        if (this.historyEventProducer == null) {
            this.historyEventProducer = new CacheAwareHistoryEventProducer();
        }
    }

    protected void initHistoryEventHandler() {
        if (this.historyEventHandler == null) {
            this.historyEventHandler = new DbHistoryEventHandler();
        }
    }

    protected void initPasswordDigest() {
        if (this.passwordEncryptor == null) {
            this.passwordEncryptor = new ShaHashDigest();
        }
    }

    protected void initDeploymentRegistration() {
        if (this.registeredDeployments == null) {
            this.registeredDeployments = new CopyOnWriteArraySet<String>();
        }
    }

    protected void initResourceAuthorizationProvider() {
        if (this.resourceAuthorizationProvider == null) {
            this.resourceAuthorizationProvider = new DefaultAuthorizationProvider();
        }
    }

    @Override
    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public int getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(int historyLevel) {
        this.historyLevel = historyLevel;
    }

    @Override
    public ProcessEngineConfigurationImpl setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
        return this;
    }

    public List<CommandInterceptor> getCustomPreCommandInterceptorsTxRequired() {
        return this.customPreCommandInterceptorsTxRequired;
    }

    public ProcessEngineConfigurationImpl setCustomPreCommandInterceptorsTxRequired(List<CommandInterceptor> customPreCommandInterceptorsTxRequired) {
        this.customPreCommandInterceptorsTxRequired = customPreCommandInterceptorsTxRequired;
        return this;
    }

    public List<CommandInterceptor> getCustomPostCommandInterceptorsTxRequired() {
        return this.customPostCommandInterceptorsTxRequired;
    }

    public ProcessEngineConfigurationImpl setCustomPostCommandInterceptorsTxRequired(List<CommandInterceptor> customPostCommandInterceptorsTxRequired) {
        this.customPostCommandInterceptorsTxRequired = customPostCommandInterceptorsTxRequired;
        return this;
    }

    public List<CommandInterceptor> getCommandInterceptorsTxRequired() {
        return this.commandInterceptorsTxRequired;
    }

    public ProcessEngineConfigurationImpl setCommandInterceptorsTxRequired(List<CommandInterceptor> commandInterceptorsTxRequired) {
        this.commandInterceptorsTxRequired = commandInterceptorsTxRequired;
        return this;
    }

    public CommandExecutor getCommandExecutorTxRequired() {
        return this.commandExecutorTxRequired;
    }

    public ProcessEngineConfigurationImpl setCommandExecutorTxRequired(CommandExecutor commandExecutorTxRequired) {
        this.commandExecutorTxRequired = commandExecutorTxRequired;
        return this;
    }

    public List<CommandInterceptor> getCustomPreCommandInterceptorsTxRequiresNew() {
        return this.customPreCommandInterceptorsTxRequiresNew;
    }

    public ProcessEngineConfigurationImpl setCustomPreCommandInterceptorsTxRequiresNew(List<CommandInterceptor> customPreCommandInterceptorsTxRequiresNew) {
        this.customPreCommandInterceptorsTxRequiresNew = customPreCommandInterceptorsTxRequiresNew;
        return this;
    }

    public List<CommandInterceptor> getCustomPostCommandInterceptorsTxRequiresNew() {
        return this.customPostCommandInterceptorsTxRequiresNew;
    }

    public ProcessEngineConfigurationImpl setCustomPostCommandInterceptorsTxRequiresNew(List<CommandInterceptor> customPostCommandInterceptorsTxRequiresNew) {
        this.customPostCommandInterceptorsTxRequiresNew = customPostCommandInterceptorsTxRequiresNew;
        return this;
    }

    public List<CommandInterceptor> getCommandInterceptorsTxRequiresNew() {
        return this.commandInterceptorsTxRequiresNew;
    }

    public ProcessEngineConfigurationImpl setCommandInterceptorsTxRequiresNew(List<CommandInterceptor> commandInterceptorsTxRequiresNew) {
        this.commandInterceptorsTxRequiresNew = commandInterceptorsTxRequiresNew;
        return this;
    }

    public CommandExecutor getCommandExecutorTxRequiresNew() {
        return this.commandExecutorTxRequiresNew;
    }

    public ProcessEngineConfigurationImpl setCommandExecutorTxRequiresNew(CommandExecutor commandExecutorTxRequiresNew) {
        this.commandExecutorTxRequiresNew = commandExecutorTxRequiresNew;
        return this;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public ProcessEngineConfigurationImpl setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        return this;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public ProcessEngineConfigurationImpl setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
        return this;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public ProcessEngineConfigurationImpl setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
        return this;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public ProcessEngineConfigurationImpl setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
        return this;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public ProcessEngineConfigurationImpl setTaskService(TaskService taskService) {
        this.taskService = taskService;
        return this;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public ProcessEngineConfigurationImpl setFormService(FormService formService) {
        this.formService = formService;
        return this;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public ProcessEngineConfigurationImpl setManagementService(ManagementService managementService) {
        this.managementService = managementService;
        return this;
    }

    public CaseService getCaseService() {
        return this.caseService;
    }

    public void setCaseService(CaseService caseService) {
        this.caseService = caseService;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public ProcessEngineConfigurationImpl setSessionFactories(Map<Class<?>, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
        return this;
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public ProcessEngineConfigurationImpl setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
        return this;
    }

    public JobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    public ProcessEngineConfigurationImpl setJobExecutor(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
        return this;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public ProcessEngineConfigurationImpl setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public String getWsSyncFactoryClassName() {
        return this.wsSyncFactoryClassName;
    }

    public ProcessEngineConfigurationImpl setWsSyncFactoryClassName(String wsSyncFactoryClassName) {
        this.wsSyncFactoryClassName = wsSyncFactoryClassName;
        return this;
    }

    public Map<String, FormEngine> getFormEngines() {
        return this.formEngines;
    }

    public ProcessEngineConfigurationImpl setFormEngines(Map<String, FormEngine> formEngines) {
        this.formEngines = formEngines;
        return this;
    }

    public FormTypes getFormTypes() {
        return this.formTypes;
    }

    public ProcessEngineConfigurationImpl setFormTypes(FormTypes formTypes) {
        this.formTypes = formTypes;
        return this;
    }

    public ScriptingEngines getScriptingEngines() {
        return this.scriptingEngines;
    }

    public ProcessEngineConfigurationImpl setScriptingEngines(ScriptingEngines scriptingEngines) {
        this.scriptingEngines = scriptingEngines;
        return this;
    }

    public VariableTypes getVariableTypes() {
        return this.variableTypes;
    }

    public ProcessEngineConfigurationImpl setVariableTypes(VariableTypes variableTypes) {
        this.variableTypes = variableTypes;
        return this;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public ProcessEngineConfigurationImpl setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    public BusinessCalendarManager getBusinessCalendarManager() {
        return this.businessCalendarManager;
    }

    public ProcessEngineConfigurationImpl setBusinessCalendarManager(BusinessCalendarManager businessCalendarManager) {
        this.businessCalendarManager = businessCalendarManager;
        return this;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public ProcessEngineConfigurationImpl setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
        return this;
    }

    public TransactionContextFactory getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public ProcessEngineConfigurationImpl setTransactionContextFactory(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
        return this;
    }

    public List<Deployer> getCustomPreDeployers() {
        return this.customPreDeployers;
    }

    public ProcessEngineConfigurationImpl setCustomPreDeployers(List<Deployer> customPreDeployers) {
        this.customPreDeployers = customPreDeployers;
        return this;
    }

    public List<Deployer> getCustomPostDeployers() {
        return this.customPostDeployers;
    }

    public ProcessEngineConfigurationImpl setCustomPostDeployers(List<Deployer> customPostDeployers) {
        this.customPostDeployers = customPostDeployers;
        return this;
    }

    public Map<String, JobHandler> getJobHandlers() {
        return this.jobHandlers;
    }

    public ProcessEngineConfigurationImpl setJobHandlers(Map<String, JobHandler> jobHandlers) {
        this.jobHandlers = jobHandlers;
        return this;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public ProcessEngineConfigurationImpl setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public ProcessEngineConfigurationImpl setDbSqlSessionFactory(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        return this;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public ProcessEngineConfigurationImpl setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
        return this;
    }

    public List<SessionFactory> getCustomSessionFactories() {
        return this.customSessionFactories;
    }

    public ProcessEngineConfigurationImpl setCustomSessionFactories(List<SessionFactory> customSessionFactories) {
        this.customSessionFactories = customSessionFactories;
        return this;
    }

    public List<JobHandler> getCustomJobHandlers() {
        return this.customJobHandlers;
    }

    public ProcessEngineConfigurationImpl setCustomJobHandlers(List<JobHandler> customJobHandlers) {
        this.customJobHandlers = customJobHandlers;
        return this;
    }

    public List<FormEngine> getCustomFormEngines() {
        return this.customFormEngines;
    }

    public ProcessEngineConfigurationImpl setCustomFormEngines(List<FormEngine> customFormEngines) {
        this.customFormEngines = customFormEngines;
        return this;
    }

    public List<AbstractFormFieldType> getCustomFormTypes() {
        return this.customFormTypes;
    }

    public ProcessEngineConfigurationImpl setCustomFormTypes(List<AbstractFormFieldType> customFormTypes) {
        this.customFormTypes = customFormTypes;
        return this;
    }

    public List<String> getCustomScriptingEngineClasses() {
        return this.customScriptingEngineClasses;
    }

    public ProcessEngineConfigurationImpl setCustomScriptingEngineClasses(List<String> customScriptingEngineClasses) {
        this.customScriptingEngineClasses = customScriptingEngineClasses;
        return this;
    }

    public List<VariableType> getCustomPreVariableTypes() {
        return this.customPreVariableTypes;
    }

    public ProcessEngineConfigurationImpl setCustomPreVariableTypes(List<VariableType> customPreVariableTypes) {
        this.customPreVariableTypes = customPreVariableTypes;
        return this;
    }

    public List<VariableType> getCustomPostVariableTypes() {
        return this.customPostVariableTypes;
    }

    public ProcessEngineConfigurationImpl setCustomPostVariableTypes(List<VariableType> customPostVariableTypes) {
        this.customPostVariableTypes = customPostVariableTypes;
        return this;
    }

    public List<BpmnParseListener> getCustomPreBPMNParseListeners() {
        return this.preParseListeners;
    }

    public void setCustomPreBPMNParseListeners(List<BpmnParseListener> preParseListeners) {
        this.preParseListeners = preParseListeners;
    }

    public List<BpmnParseListener> getCustomPostBPMNParseListeners() {
        return this.postParseListeners;
    }

    public void setCustomPostBPMNParseListeners(List<BpmnParseListener> postParseListeners) {
        this.postParseListeners = postParseListeners;
    }

    public List<BpmnParseListener> getPreParseListeners() {
        return this.preParseListeners;
    }

    public void setPreParseListeners(List<BpmnParseListener> preParseListeners) {
        this.preParseListeners = preParseListeners;
    }

    public List<BpmnParseListener> getPostParseListeners() {
        return this.postParseListeners;
    }

    public void setPostParseListeners(List<BpmnParseListener> postParseListeners) {
        this.postParseListeners = postParseListeners;
    }

    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public ProcessEngineConfigurationImpl setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setDatabaseType(String databaseType) {
        super.setDatabaseType(databaseType);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setDatabaseSchemaUpdate(String databaseSchemaUpdate) {
        super.setDatabaseSchemaUpdate(databaseSchemaUpdate);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setHistory(String history) {
        super.setHistory(history);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setIdBlockSize(int idBlockSize) {
        super.setIdBlockSize(idBlockSize);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcDriver(String jdbcDriver) {
        super.setJdbcDriver(jdbcDriver);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcPassword(String jdbcPassword) {
        super.setJdbcPassword(jdbcPassword);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcUrl(String jdbcUrl) {
        super.setJdbcUrl(jdbcUrl);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcUsername(String jdbcUsername) {
        super.setJdbcUsername(jdbcUsername);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJobExecutorActivate(boolean jobExecutorActivate) {
        super.setJobExecutorActivate(jobExecutorActivate);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerDefaultFrom(String mailServerDefaultFrom) {
        super.setMailServerDefaultFrom(mailServerDefaultFrom);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerHost(String mailServerHost) {
        super.setMailServerHost(mailServerHost);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerPassword(String mailServerPassword) {
        super.setMailServerPassword(mailServerPassword);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerPort(int mailServerPort) {
        super.setMailServerPort(mailServerPort);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerUseTLS(boolean useTLS) {
        super.setMailServerUseTLS(useTLS);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerUsername(String mailServerUsername) {
        super.setMailServerUsername(mailServerUsername);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcMaxActiveConnections(int jdbcMaxActiveConnections) {
        super.setJdbcMaxActiveConnections(jdbcMaxActiveConnections);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcMaxCheckoutTime(int jdbcMaxCheckoutTime) {
        super.setJdbcMaxCheckoutTime(jdbcMaxCheckoutTime);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcMaxIdleConnections(int jdbcMaxIdleConnections) {
        super.setJdbcMaxIdleConnections(jdbcMaxIdleConnections);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcMaxWaitTime(int jdbcMaxWaitTime) {
        super.setJdbcMaxWaitTime(jdbcMaxWaitTime);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setTransactionsExternallyManaged(boolean transactionsExternallyManaged) {
        super.setTransactionsExternallyManaged(transactionsExternallyManaged);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJpaEntityManagerFactory(Object jpaEntityManagerFactory) {
        this.jpaEntityManagerFactory = jpaEntityManagerFactory;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJpaHandleTransaction(boolean jpaHandleTransaction) {
        this.jpaHandleTransaction = jpaHandleTransaction;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJpaCloseEntityManager(boolean jpaCloseEntityManager) {
        this.jpaCloseEntityManager = jpaCloseEntityManager;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcPingEnabled(boolean jdbcPingEnabled) {
        this.jdbcPingEnabled = jdbcPingEnabled;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcPingQuery(String jdbcPingQuery) {
        this.jdbcPingQuery = jdbcPingQuery;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcPingConnectionNotUsedFor(int jdbcPingNotUsedFor) {
        this.jdbcPingConnectionNotUsedFor = jdbcPingNotUsedFor;
        return this;
    }

    public boolean isDbIdentityUsed() {
        return this.isDbIdentityUsed;
    }

    public void setDbIdentityUsed(boolean isDbIdentityUsed) {
        this.isDbIdentityUsed = isDbIdentityUsed;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }

    public MailScanner getMailScanner() {
        return this.mailScanner;
    }

    public void setMailScanner(MailScanner mailScanner) {
        this.mailScanner = mailScanner;
    }

    public DeploymentCache getDeploymentCache() {
        return this.deploymentCache;
    }

    public void setDeploymentCache(DeploymentCache deploymentCache) {
        this.deploymentCache = deploymentCache;
    }

    public ProcessEngineConfigurationImpl setDelegateInterceptor(DelegateInterceptor delegateInterceptor) {
        this.delegateInterceptor = delegateInterceptor;
        return this;
    }

    public DelegateInterceptor getDelegateInterceptor() {
        return this.delegateInterceptor;
    }

    public RejectedJobsHandler getCustomRejectedJobsHandler() {
        return this.customRejectedJobsHandler;
    }

    public ProcessEngineConfigurationImpl setCustomRejectedJobsHandler(RejectedJobsHandler customRejectedJobsHandler) {
        this.customRejectedJobsHandler = customRejectedJobsHandler;
        return this;
    }

    public EventHandler getEventHandler(String eventType) {
        return this.eventHandlers.get(eventType);
    }

    public void setEventHandlers(Map<String, EventHandler> eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    public Map<String, EventHandler> getEventHandlers() {
        return this.eventHandlers;
    }

    public List<EventHandler> getCustomEventHandlers() {
        return this.customEventHandlers;
    }

    public void setCustomEventHandlers(List<EventHandler> customEventHandlers) {
        this.customEventHandlers = customEventHandlers;
    }

    public FailedJobCommandFactory getFailedJobCommandFactory() {
        return this.failedJobCommandFactory;
    }

    public ProcessEngineConfigurationImpl setFailedJobCommandFactory(FailedJobCommandFactory failedJobCommandFactory) {
        this.failedJobCommandFactory = failedJobCommandFactory;
        return this;
    }

    public ProcessEngineConfiguration setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
        return this;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public boolean isCreateDiagramOnDeploy() {
        return this.isCreateDiagramOnDeploy;
    }

    public ProcessEngineConfiguration setCreateDiagramOnDeploy(boolean createDiagramOnDeploy) {
        this.isCreateDiagramOnDeploy = createDiagramOnDeploy;
        return this;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public DataSource getIdGeneratorDataSource() {
        return this.idGeneratorDataSource;
    }

    public void setIdGeneratorDataSource(DataSource idGeneratorDataSource) {
        this.idGeneratorDataSource = idGeneratorDataSource;
    }

    public String getIdGeneratorDataSourceJndiName() {
        return this.idGeneratorDataSourceJndiName;
    }

    public void setIdGeneratorDataSourceJndiName(String idGeneratorDataSourceJndiName) {
        this.idGeneratorDataSourceJndiName = idGeneratorDataSourceJndiName;
    }

    public ProcessApplicationManager getProcessApplicationManager() {
        return this.processApplicationManager;
    }

    public void setProcessApplicationManager(ProcessApplicationManager processApplicationManager) {
        this.processApplicationManager = processApplicationManager;
    }

    public CommandExecutor getCommandExecutorSchemaOperations() {
        return this.commandExecutorSchemaOperations;
    }

    public void setCommandExecutorSchemaOperations(CommandExecutor commandExecutorSchemaOperations) {
        this.commandExecutorSchemaOperations = commandExecutorSchemaOperations;
    }

    public CorrelationHandler getCorrelationHandler() {
        return this.correlationHandler;
    }

    public void setCorrelationHandler(CorrelationHandler correlationHandler) {
        this.correlationHandler = correlationHandler;
    }

    public ProcessEngineConfigurationImpl setHistoryEventHandler(HistoryEventHandler historyEventHandler) {
        this.historyEventHandler = historyEventHandler;
        return this;
    }

    public HistoryEventHandler getHistoryEventHandler() {
        return this.historyEventHandler;
    }

    public IncidentHandler getIncidentHandler(String incidentType) {
        return this.incidentHandlers.get(incidentType);
    }

    public Map<String, IncidentHandler> getIncidentHandlers() {
        return this.incidentHandlers;
    }

    public void setIncidentHandlers(Map<String, IncidentHandler> incidentHandlers) {
        this.incidentHandlers = incidentHandlers;
    }

    public List<IncidentHandler> getCustomIncidentHandlers() {
        return this.customIncidentHandlers;
    }

    public void setCustomIncidentHandlers(List<IncidentHandler> customIncidentHandlers) {
        this.customIncidentHandlers = customIncidentHandlers;
    }

    public SessionFactory getIdentityProviderSessionFactory() {
        return this.identityProviderSessionFactory;
    }

    public void setIdentityProviderSessionFactory(SessionFactory identityProviderSessionFactory) {
        this.identityProviderSessionFactory = identityProviderSessionFactory;
    }

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public PasswordEncryptor getPasswordEncryptor() {
        return this.passwordEncryptor;
    }

    public Set<String> getRegisteredDeployments() {
        return this.registeredDeployments;
    }

    public void setRegisteredDeployments(Set<String> registeredDeployments) {
        this.registeredDeployments = registeredDeployments;
    }

    public ResourceAuthorizationProvider getResourceAuthorizationProvider() {
        return this.resourceAuthorizationProvider;
    }

    public void setResourceAuthorizationProvider(ResourceAuthorizationProvider resourceAuthorizationProvider) {
        this.resourceAuthorizationProvider = resourceAuthorizationProvider;
    }

    public List<ProcessEnginePlugin> getProcessEnginePlugins() {
        return this.processEnginePlugins;
    }

    public void setProcessEnginePlugins(List<ProcessEnginePlugin> processEnginePlugins) {
        this.processEnginePlugins = processEnginePlugins;
    }

    public ProcessEngineConfigurationImpl setHistoryEventProducer(HistoryEventProducer historyEventProducerFactory) {
        this.historyEventProducer = historyEventProducerFactory;
        return this;
    }

    public HistoryEventProducer getHistoryEventProducer() {
        return this.historyEventProducer;
    }

    public Map<String, Class<? extends FormFieldValidator>> getCustomFormFieldValidators() {
        return this.customFormFieldValidators;
    }

    public void setCustomFormFieldValidators(Map<String, Class<? extends FormFieldValidator>> customFormFieldValidators) {
        this.customFormFieldValidators = customFormFieldValidators;
    }

    public void setFormValidators(FormValidators formValidators) {
        this.formValidators = formValidators;
    }

    public FormValidators getFormValidators() {
        return this.formValidators;
    }

    public boolean isExecutionTreePrefetchEnabled() {
        return this.isExecutionTreePrefetchEnabled;
    }

    public void setExecutionTreePrefetchEnabled(boolean isExecutionTreePrefetchingEnabled) {
        this.isExecutionTreePrefetchEnabled = isExecutionTreePrefetchingEnabled;
    }

    public ProcessEngineImpl getProcessEngine() {
        return this.processEngine;
    }

    public void setAutoStoreScriptVariables(boolean autoStoreScriptVariables) {
        this.autoStoreScriptVariables = autoStoreScriptVariables;
    }

    public boolean isAutoStoreScriptVariables() {
        return this.autoStoreScriptVariables;
    }

    public void setEnableScriptCompilation(boolean enableScriptCompilation) {
        this.enableScriptCompilation = enableScriptCompilation;
    }

    public boolean isEnableScriptCompilation() {
        return this.enableScriptCompilation;
    }

    public boolean isDeploymentLockUsed() {
        return this.isDeploymentLockUsed;
    }

    public void setDeploymentLockUsed(boolean isDeploymentLockUsed) {
        this.isDeploymentLockUsed = isDeploymentLockUsed;
    }

    public boolean isCmmnEnabled() {
        return this.cmmnEnabled;
    }

    public void setCmmnEnabled(boolean cmmnEnabled) {
        this.cmmnEnabled = cmmnEnabled;
    }

    public ScriptFactory getScriptFactory() {
        return this.scriptFactory;
    }

    public ScriptingEnvironment getScriptingEnvironment() {
        return this.scriptingEnvironment;
    }

    public void setScriptFactory(ScriptFactory scriptFactory) {
        this.scriptFactory = scriptFactory;
    }

    public void setScriptingEnvironment(ScriptingEnvironment scriptingEnvironment) {
        this.scriptingEnvironment = scriptingEnvironment;
    }

    public List<ScriptEnvResolver> getEnvScriptResolvers() {
        return this.scriptEnvResolvers;
    }

    public void setEnvScriptResolvers(List<ScriptEnvResolver> scriptEnvResolvers) {
        this.scriptEnvResolvers = scriptEnvResolvers;
    }

    public Connectors getConnectors() {
        return this.connectors;
    }

    public void setConnectors(Connectors connectors) {
        this.connectors = connectors;
    }

    public ProcessEngineConfiguration setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
        return this;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public String getDefaultSerializationFormat() {
        return this.defaultSerializationFormat;
    }

    public ProcessEngineConfigurationImpl setDefaultSerializationFormat(String defaultSerializationFormat) {
        this.defaultSerializationFormat = defaultSerializationFormat;
        return this;
    }

    public List<SerializationVariableTypeResolver> getSerializationTypeResolvers() {
        return this.serializationTypeResolvers;
    }

    public ProcessEngineConfigurationImpl setSerializationTypeResolvers(List<SerializationVariableTypeResolver> serializationTypeResolvers) {
        this.serializationTypeResolvers = serializationTypeResolvers;
        return this;
    }
}

