/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.behavior.ProcessOrCaseTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;

public class CaseTaskActivityBehavior
extends ProcessOrCaseTaskActivityBehavior {
    @Override
    protected void triggerCallableElement(CmmnActivityExecution execution, Map<String, Object> variables, String businessKey) {
        String caseDefinitionKey = this.getDefinitionKey(execution);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        CaseDefinitionEntity caseDefinition = null;
        if (this.isLatestBinding()) {
            caseDefinition = deploymentCache.findDeployedLatestCaseDefinitionByKey(caseDefinitionKey);
        } else if (this.isDeploymentBinding()) {
            String deploymentId = this.getDeploymentId(execution);
            caseDefinition = deploymentCache.findDeployedCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
        } else if (this.isVersionBinding()) {
            Integer version = this.getVersion(execution);
            caseDefinition = deploymentCache.findDeployedCaseDefinitionByKeyAndVersion(caseDefinitionKey, version);
        }
        CmmnCaseInstance caseInstance = execution.createSubCaseInstance(caseDefinition);
        caseInstance.create(businessKey, variables);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        throw new ProcessEngineException("It is not possible to complete a case task manually.");
    }
}

