/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;

public abstract class PlanItemDefinitionActivityBehavior
implements CmmnActivityBehavior {
    @Override
    public void execute(CmmnActivityExecution execution) throws Exception {
        throw new UnsupportedOperationException("execute() is unsupported in CmmnActivityBehavior");
    }

    @Override
    public void onCreate(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.NEW, CaseExecutionState.AVAILABLE, "create");
        this.creating(execution);
    }

    @Override
    public void onClose(CmmnActivityExecution execution) {
        if (execution.isCaseInstanceExecution()) {
            String id = execution.getId();
            if (execution.isClosed()) {
                throw new ProcessEngineException("Case instance'" + id + "' is already closed.");
            }
            if (execution.isActive()) {
                throw new ProcessEngineException("Case instance '" + id + "' must be completed|terminated|failed|suspended to close it, but was active.");
            }
        } else {
            throw new UnsupportedOperationException("It is not possible to close a case execution which is not a case instance.");
        }
    }

    protected void creating(CmmnActivityExecution execution) {
    }

    protected void terminating(CmmnActivityExecution execution) {
    }

    protected void completing(CmmnActivityExecution execution) {
    }

    protected void manualCompleting(CmmnActivityExecution execution) {
    }

    protected void suspending(CmmnActivityExecution execution) {
    }

    protected void resuming(CmmnActivityExecution execution) {
    }

    @Override
    public void resumed(CmmnActivityExecution execution) {
    }

    @Override
    public void reactivated(CmmnActivityExecution execution) {
    }

    protected void evaluateRequiredRule(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        Object requiredRule = activity.getProperty("requiredRule");
        if (requiredRule != null) {
            CaseControlRule rule = (CaseControlRule)requiredRule;
            boolean required = rule.evaluate(execution);
            execution.setRequired(required);
        }
    }

    protected void evaluateRepetitionRule(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        Object repetitionRule = activity.getProperty("repetitionRule");
        if (repetitionRule != null) {
            CaseControlRule rule = (CaseControlRule)repetitionRule;
            rule.evaluate(execution);
        }
    }

    protected void ensureTransitionAllowed(CmmnActivityExecution execution, CaseExecutionState expected, CaseExecutionState target, String transition) {
        String id = execution.getId();
        CaseExecutionState currentState = execution.getCurrentState();
        if (target.equals(currentState)) {
            String message = "Case execution '" + id + "' is already " + target + ".";
            throw new ProcessEngineException(message);
        }
        if (!expected.equals(currentState)) {
            String message = "Case execution '" + id + "' must be " + expected + " to " + transition + " it, but was " + currentState + ".";
            throw new ProcessEngineException(message);
        }
    }

    protected void ensureNotCaseInstance(CmmnActivityExecution execution, String transition) {
        if (execution.isCaseInstanceExecution()) {
            String id = execution.getId();
            String message = "It is not possible to " + transition + " the case instance '" + id + "'.";
            throw new ProcessEngineException(message);
        }
    }
}

