/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformer;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class CmmnDeployer
implements Deployer {
    public static final String[] CMMN_RESOURCE_SUFFIXES = new String[]{"cmmn"};
    protected ExpressionManager expressionManager;
    protected CmmnTransformer transformer;
    protected IdGenerator idGenerator;

    @Override
    public void deploy(DeploymentEntity deployment) {
        ArrayList<CaseDefinitionEntity> caseDefinitions = new ArrayList<CaseDefinitionEntity>();
        Map<String, ResourceEntity> resources = deployment.getResources();
        for (ResourceEntity resource : resources.values()) {
            if (!this.isCmmnResource(resource)) continue;
            List<CaseDefinitionEntity> result = this.transformResource(deployment, resource);
            caseDefinitions.addAll(result);
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (CaseDefinitionEntity currentCaseDefinition : caseDefinitions) {
            String key = currentCaseDefinition.getKey();
            if (keys.contains(key)) {
                throw new ProcessEngineException("The deployment contains case definitions with the same key '" + key + "' (case id attribute), this is not allowed");
            }
            keys.add(key);
        }
        if (!deployment.isNew()) {
            this.loadCaseDefinitions(deployment, caseDefinitions);
        } else {
            this.persistCaseDefinitions(deployment, caseDefinitions);
        }
    }

    protected boolean isCmmnResource(ResourceEntity resource) {
        String resourceName = resource.getName();
        for (String suffix : CMMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected List<CaseDefinitionEntity> transformResource(DeploymentEntity deployment, ResourceEntity resource) {
        List<CaseDefinitionEntity> caseDefinitions = this.transformer.createTransform().deployment(deployment).resource(resource).transform();
        for (CaseDefinitionEntity caseDefinition : caseDefinitions) {
            String resourceName = resource.getName();
            caseDefinition.setResourceName(resourceName);
        }
        return caseDefinitions;
    }

    protected int getNextVersion(CaseDefinitionEntity newCaseDefinition, CaseDefinitionEntity latestCaseDefinition) {
        int result = 1;
        if (latestCaseDefinition != null) {
            int latestVersion = latestCaseDefinition.getVersion();
            result = latestVersion + 1;
        }
        return result;
    }

    protected String generateCaseDefinitionId(CaseDefinitionEntity caseDefinition) {
        String nextId = this.idGenerator.getNextId();
        String caseDefinitionKey = caseDefinition.getKey();
        int caseDefinitionVersion = caseDefinition.getVersion();
        String caseDefinitionId = caseDefinitionKey + ":" + caseDefinitionVersion + ":" + nextId;
        if (caseDefinitionId.length() > 64) {
            caseDefinitionId = nextId;
        }
        return caseDefinitionId;
    }

    protected void loadCaseDefinitions(DeploymentEntity deployment, Collection<CaseDefinitionEntity> caseDefinitions) {
        CaseDefinitionManager caseDefinitionManager = Context.getCommandContext().getCaseDefinitionManager();
        for (CaseDefinitionEntity caseDefinition : caseDefinitions) {
            String key = caseDefinition.getKey();
            String deploymentId = deployment.getId();
            caseDefinition.setDeploymentId(deploymentId);
            CaseDefinitionEntity persistedCaseDefinition = caseDefinitionManager.findCaseDefinitionByDeploymentAndKey(deploymentId, key);
            String caseDefinitionId = persistedCaseDefinition.getId();
            caseDefinition.setId(caseDefinitionId);
            int version = persistedCaseDefinition.getVersion();
            caseDefinition.setVersion(version);
            this.addCaseDefinitionToDeploymentCache(caseDefinition);
            deployment.addDeployedArtifact(caseDefinition);
        }
    }

    protected void persistCaseDefinitions(DeploymentEntity deployment, Collection<CaseDefinitionEntity> caseDefinitions) {
        CaseDefinitionManager caseDefinitionManager = Context.getCommandContext().getCaseDefinitionManager();
        for (CaseDefinitionEntity caseDefinition : caseDefinitions) {
            String deploymentId = deployment.getId();
            caseDefinition.setDeploymentId(deploymentId);
            String key = caseDefinition.getKey();
            CaseDefinitionEntity latestCaseDefinition = caseDefinitionManager.findLatestCaseDefinitionByKey(key);
            int version = this.getNextVersion(caseDefinition, latestCaseDefinition);
            caseDefinition.setVersion(version);
            String caseDefinitionId = this.generateCaseDefinitionId(caseDefinition);
            caseDefinition.setId(caseDefinitionId);
            caseDefinitionManager.insertCaseDefinition(caseDefinition);
            this.addCaseDefinitionToDeploymentCache(caseDefinition);
            deployment.addDeployedArtifact(caseDefinition);
        }
    }

    protected void addCaseDefinitionToDeploymentCache(CaseDefinitionEntity caseDefinition) {
        Context.getProcessEngineConfiguration().getDeploymentCache().addCaseDefinition(caseDefinition);
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public CmmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(CmmnTransformer transformer) {
        this.transformer = transformer;
    }
}

