/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.runtime;

import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionQueryImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseInstanceQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;

public class CaseExecutionManager
extends AbstractManager {
    public void insertCaseExecution(CaseExecutionEntity caseExecution) {
        this.getDbSqlSession().insert(caseExecution);
    }

    public void deleteCaseExecution(CaseExecutionEntity caseExecution) {
        this.getDbSqlSession().delete(caseExecution);
    }

    public void deleteCaseInstancesByCaseDefinition(String caseDefinitionId, String deleteReason, boolean cascade) {
        List caseInstanceIds = this.getDbSqlSession().selectList("selectCaseInstanceIdsByCaseDefinitionId", caseDefinitionId);
        for (String caseInstanceId : caseInstanceIds) {
            this.deleteCaseInstance(caseInstanceId, deleteReason, cascade);
        }
    }

    public void deleteCaseInstance(String caseInstanceId, String deleteReason) {
        this.deleteCaseInstance(caseInstanceId, deleteReason, false);
    }

    public void deleteCaseInstance(String caseInstanceId, String deleteReason, boolean cascade) {
        CaseExecutionEntity execution = this.findCaseExecutionById(caseInstanceId);
        if (execution == null) {
            throw new BadUserRequestException("No case instance found for id '" + caseInstanceId + "'");
        }
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getTaskManager().deleteTasksByCaseInstanceId(caseInstanceId, deleteReason, cascade);
        execution.deleteCascade();
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel > 0) {
            commandContext.getOperationLogManager().deleteOperationLogEntriesByCaseInstanceId(caseInstanceId);
        }
    }

    public CaseExecutionEntity findCaseExecutionById(String caseExecutionId) {
        return this.getDbSqlSession().selectById(CaseExecutionEntity.class, caseExecutionId);
    }

    public CaseExecutionEntity findSubCaseInstanceBySuperCaseExecutionId(String superCaseExecutionId) {
        return (CaseExecutionEntity)this.getDbSqlSession().selectOne("selectSubCaseInstanceBySuperCaseExecutionId", superCaseExecutionId);
    }

    public long findCaseExecutionCountByQueryCriteria(CaseExecutionQueryImpl caseExecutionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectCaseExecutionCountByQueryCriteria", caseExecutionQuery);
    }

    public List<CaseExecution> findCaseExecutionsByQueryCriteria(CaseExecutionQueryImpl caseExecutionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectCaseExecutionsByQueryCriteria", caseExecutionQuery, page);
    }

    public long findCaseInstanceCountByQueryCriteria(CaseInstanceQueryImpl caseInstanceQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectCaseInstanceCountByQueryCriteria", caseInstanceQuery);
    }

    public List<CaseInstance> findCaseInstanceByQueryCriteria(CaseInstanceQueryImpl caseInstanceQuery, Page page) {
        return this.getDbSqlSession().selectList("selectCaseInstanceByQueryCriteria", caseInstanceQuery, page);
    }

    public List<CaseExecutionEntity> findChildCaseExecutionsByParentCaseExecutionId(String parentCaseExecutionId) {
        return this.getDbSqlSession().selectList("selectCaseExecutionsByParentCaseExecutionId", parentCaseExecutionId);
    }
}

