/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public abstract class CmmnExecution
extends CoreExecution
implements CmmnCaseInstance {
    private static final long serialVersionUID = 1L;
    protected transient CmmnCaseDefinition caseDefinition;
    protected transient CmmnActivity activity;
    protected transient CmmnActivity nextActivity;
    protected boolean required;
    protected int previousState;
    protected int currentState = CaseExecutionState.NEW.getStateCode();

    @Override
    public abstract List<? extends CmmnExecution> getCaseExecutions();

    protected abstract List<? extends CmmnExecution> getCaseExecutionsInternal();

    @Override
    public CmmnExecution findCaseExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (CmmnExecution cmmnExecution : this.getCaseExecutions()) {
            CmmnExecution result = cmmnExecution.findCaseExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public abstract PvmExecutionImpl getSubProcessInstance();

    public abstract void setSubProcessInstance(PvmExecutionImpl var1);

    @Override
    public abstract PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition var1);

    public abstract CmmnExecution getSubCaseInstance();

    public abstract void setSubCaseInstance(CmmnExecution var1);

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1);

    public abstract CmmnExecution getSuperCaseExecution();

    public abstract void setSuperCaseExecution(CmmnExecution var1);

    @Override
    public String getCaseBusinessKey() {
        return this.getCaseInstance().getBusinessKey();
    }

    public CmmnCaseDefinition getCaseDefinition() {
        return this.caseDefinition;
    }

    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        this.caseDefinition = caseDefinition;
    }

    public abstract CmmnExecution getCaseInstance();

    public abstract void setCaseInstance(CmmnExecution var1);

    @Override
    public boolean isCaseInstanceExecution() {
        return this.getParent() == null;
    }

    @Override
    public String getCaseInstanceId() {
        return this.getCaseInstance().getId();
    }

    @Override
    public abstract CmmnExecution getParent();

    public abstract void setParent(CmmnExecution var1);

    @Override
    public CmmnActivity getActivity() {
        return this.activity;
    }

    public void setActivity(CmmnActivity activity) {
        this.activity = activity;
    }

    public CmmnActivity getNextActivity() {
        return this.nextActivity;
    }

    public void setNextActivity(CmmnActivity nextActivity) {
        this.nextActivity = nextActivity;
    }

    @Override
    public CoreVariableScope getParentVariableScope() {
        return this.getParent();
    }

    public void deleteCascade() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_DELETE_CASCADE);
    }

    @Override
    public void remove() {
        CmmnExecution parent = this.getParent();
        if (parent != null) {
            parent.getCaseExecutionsInternal().remove(this);
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public CaseExecutionState getCurrentState() {
        return CaseExecutionState.CASE_EXECUTION_STATES.get(this.getState());
    }

    @Override
    public void setCurrentState(CaseExecutionState currentState) {
        this.previousState = this.currentState;
        this.currentState = currentState.getStateCode();
    }

    public int getState() {
        return this.currentState;
    }

    public void setState(int state) {
        this.currentState = state;
    }

    @Override
    public boolean isNew() {
        return this.currentState == CaseExecutionState.NEW.getStateCode();
    }

    @Override
    public boolean isAvailable() {
        return this.currentState == CaseExecutionState.AVAILABLE.getStateCode();
    }

    @Override
    public boolean isEnabled() {
        return this.currentState == CaseExecutionState.ENABLED.getStateCode();
    }

    @Override
    public boolean isDisabled() {
        return this.currentState == CaseExecutionState.DISABLED.getStateCode();
    }

    @Override
    public boolean isActive() {
        return this.currentState == CaseExecutionState.ACTIVE.getStateCode();
    }

    @Override
    public boolean isCompleted() {
        return this.currentState == CaseExecutionState.COMPLETED.getStateCode();
    }

    @Override
    public boolean isSuspended() {
        return this.currentState == CaseExecutionState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isTerminated() {
        return this.currentState == CaseExecutionState.TERMINATED.getStateCode();
    }

    @Override
    public boolean isFailed() {
        return this.currentState == CaseExecutionState.FAILED.getStateCode();
    }

    @Override
    public boolean isClosed() {
        return this.currentState == CaseExecutionState.CLOSED.getStateCode();
    }

    @Override
    public CaseExecutionState getPreviousState() {
        return CaseExecutionState.CASE_EXECUTION_STATES.get(this.getPrevious());
    }

    public int getPrevious() {
        return this.previousState;
    }

    public void setPrevious(int previous) {
        this.previousState = previous;
    }

    @Override
    public void create() {
        this.create(null, null);
    }

    @Override
    public void create(Map<String, Object> variables) {
        this.create(null, variables);
    }

    @Override
    public void create(String businessKey) {
        this.create(businessKey, null);
    }

    @Override
    public void create(String businessKey, Map<String, Object> variables) {
        if (variables != null) {
            this.setVariables(variables);
        }
        if (businessKey != null) {
            this.setBusinessKey(businessKey);
        }
        this.performOperation(CmmnAtomicOperation.CASE_INSTANCE_CREATE);
    }

    @Override
    public void createChildExecutions(List<CmmnActivity> activities) {
        if (!this.isActive()) {
            String message = "Cannot create child case executions on case execution '" + this.id + "' as parent because the case execution is not active.";
            throw new ProcessEngineException(message);
        }
        ArrayList<CmmnExecution> children = new ArrayList<CmmnExecution>();
        for (CmmnActivity currentActivity : activities) {
            CmmnExecution child = this.createCaseExecution(currentActivity);
            children.add(child);
        }
        for (CmmnExecution child : children) {
            if (!this.isActive()) break;
            child.performOperation(CmmnAtomicOperation.CASE_EXECUTION_CREATE);
        }
    }

    protected abstract CmmnExecution createCaseExecution(CmmnActivity var1);

    protected abstract CmmnExecution newCaseExecution();

    @Override
    public void enable() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_ENABLE);
    }

    @Override
    public void disable() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_DISABLE);
    }

    @Override
    public void reenable() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_RE_ENABLE);
    }

    @Override
    public void manualStart() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_MANUAL_START);
    }

    @Override
    public void start() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_START);
    }

    @Override
    public void complete() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_COMPLETE);
    }

    @Override
    public void manualComplete() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_MANUAL_COMPLETE);
    }

    @Override
    public void occur() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_OCCUR);
    }

    @Override
    public void terminate() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_TERMINATE);
    }

    @Override
    public void parentTerminate() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_PARENT_TERMINATE);
    }

    @Override
    public void exit() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_EXIT);
    }

    @Override
    public void suspend() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_SUSPEND);
    }

    @Override
    public void parentSuspend() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_PARENT_SUSPEND);
    }

    @Override
    public void resume() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_RESUME);
    }

    @Override
    public void parentResume() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_PARENT_RESUME);
    }

    @Override
    public void reactivate() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_RE_ACTIVATE);
    }

    @Override
    public void close() {
        this.performOperation(CmmnAtomicOperation.CASE_INSTANCE_CLOSE);
    }

    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CmmnExecution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }
}

