/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.core.handler.ModelElementHandler;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;

public abstract class CmmnElementHandler<T extends CmmnElement>
implements ModelElementHandler<T, CmmnHandlerContext> {
    protected CmmnActivity createActivity(CmmnElement element, CmmnHandlerContext context) {
        String id = element.getId();
        CmmnActivity parent = context.getParent();
        CmmnActivity newActivity = null;
        if (parent != null) {
            newActivity = parent.createActivity(id);
        } else {
            CmmnCaseDefinition caseDefinition = context.getCaseDefinition();
            newActivity = new CmmnActivity(id, caseDefinition);
        }
        newActivity.setCmmnElement(element);
        CmmnActivityBehavior behavior = this.getActivityBehavior();
        newActivity.setActivityBehavior(behavior);
        return newActivity;
    }

    protected abstract void initializeActivity(T var1, CmmnActivity var2, CmmnHandlerContext var3);

    protected CmmnActivityBehavior getActivityBehavior() {
        return null;
    }

    public abstract CmmnActivity handleElement(T var1, CmmnHandlerContext var2);
}

