/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.cmmn.behavior.CaseControlRuleImpl;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.listener.ClassDelegateCaseExecutionListener;
import org.camunda.bpm.engine.impl.cmmn.listener.DelegateExpressionCaseExecutionListener;
import org.camunda.bpm.engine.impl.cmmn.listener.ExpressionCaseExecutionListener;
import org.camunda.bpm.engine.impl.cmmn.listener.ScriptCaseExecutionListener;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.el.FixedValue;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.scripting.DynamicResourceExecutableScript;
import org.camunda.bpm.engine.impl.scripting.DynamicSourceExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.engine.JuelScriptEngineFactory;
import org.camunda.bpm.engine.impl.util.ResourceUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.model.cmmn.Query;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.DiscretionaryItem;
import org.camunda.bpm.model.cmmn.instance.ExtensionElements;
import org.camunda.bpm.model.cmmn.instance.ManualActivationRule;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemControl;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.RepetitionRule;
import org.camunda.bpm.model.cmmn.instance.RequiredRule;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaCaseExecutionListener;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaExpression;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaField;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaScript;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaString;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class ItemHandler
extends CmmnElementHandler<CmmnElement> {
    protected static List<String> TASK_OR_STAGE_EVENTS = Arrays.asList("create", "enable", "disable", "reenable", "start", "manualStart", "terminate", "exit", "suspend", "parentSuspend", "resume", "parentResume", "complete");
    protected static List<String> EVENTLISTENER_OR_MILESTONE_EVENTS = Arrays.asList("create", "suspend", "resume", "terminate", "parentTerminate", "occur");
    protected static List<String> CASE_PLAN_MODEL_EVENTS = Arrays.asList("create", "terminate", "suspend", "complete", "reactivate", "close");

    @Override
    public CmmnActivity handleElement(CmmnElement element, CmmnHandlerContext context) {
        CmmnActivity newActivity = this.createActivity(element, context);
        this.initializeActivity(element, newActivity, context);
        return newActivity;
    }

    @Override
    protected void initializeActivity(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        String name;
        if (this.isDiscretionaryItem(element)) {
            activity.setProperty("discretionary", true);
        }
        if ((name = this.getName(element)) == null) {
            PlanItemDefinition definition = this.getDefinition(element);
            name = definition.getName();
        }
        activity.setName(name);
        this.initializeRequiredRule(element, activity, context);
        this.initializeManualActivationRule(element, activity, context);
        this.initializeRepetitionRule(element, activity, context);
        this.initializeCaseExecutionListeners(element, activity, context);
    }

    protected void initializeRequiredRule(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemControl itemControl = this.getItemControl(element);
        PlanItemControl defaultControl = this.getDefaultControl(element);
        ExpressionManager expressionManager = context.getExpressionManager();
        RequiredRule requiredRule = null;
        if (itemControl != null) {
            requiredRule = itemControl.getRequiredRule();
        }
        if (requiredRule == null && defaultControl != null) {
            requiredRule = defaultControl.getRequiredRule();
        }
        if (requiredRule != null) {
            String rule = requiredRule.getCondition().getBody();
            Expression requiredRuleExpression = expressionManager.createExpression(rule);
            CaseControlRuleImpl caseRule = new CaseControlRuleImpl(requiredRuleExpression);
            activity.setProperty("requiredRule", caseRule);
        }
    }

    protected void initializeManualActivationRule(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemControl itemControl = this.getItemControl(element);
        PlanItemControl defaultControl = this.getDefaultControl(element);
        ExpressionManager expressionManager = context.getExpressionManager();
        ManualActivationRule manualActivationRule = null;
        if (itemControl != null) {
            manualActivationRule = itemControl.getManualActivationRule();
        }
        if (manualActivationRule == null && defaultControl != null) {
            manualActivationRule = defaultControl.getManualActivationRule();
        }
        if (manualActivationRule != null) {
            String rule = manualActivationRule.getCondition().getBody();
            Expression requiredRuleExpression = expressionManager.createExpression(rule);
            CaseControlRuleImpl caseRule = new CaseControlRuleImpl(requiredRuleExpression);
            activity.setProperty("manualActivationRule", caseRule);
        }
    }

    protected void initializeRepetitionRule(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemControl itemControl = this.getItemControl(element);
        PlanItemControl defaultControl = this.getDefaultControl(element);
        ExpressionManager expressionManager = context.getExpressionManager();
        RepetitionRule repetitionRule = null;
        if (itemControl != null) {
            repetitionRule = itemControl.getRepetitionRule();
        }
        if (repetitionRule == null && defaultControl != null) {
            repetitionRule = defaultControl.getRepetitionRule();
        }
        if (repetitionRule != null) {
            String rule = repetitionRule.getCondition().getBody();
            Expression requiredRuleExpression = expressionManager.createExpression(rule);
            CaseControlRuleImpl caseRule = new CaseControlRuleImpl(requiredRuleExpression);
            activity.setProperty("repetitionRule", caseRule);
        }
    }

    protected void initializeCaseExecutionListeners(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemDefinition definition = this.getDefinition(element);
        List<CamundaCaseExecutionListener> listeners = this.queryExtensionElementsByClass((CmmnElement)definition, CamundaCaseExecutionListener.class);
        for (CamundaCaseExecutionListener listener : listeners) {
            CaseExecutionListener caseExecutionListener = this.initializeCaseExecutionListener(element, activity, context, listener);
            String eventName = listener.getCamundaEvent();
            if (eventName != null) {
                activity.addListener(eventName, caseExecutionListener);
                continue;
            }
            for (String event : this.getStandardEvents(element)) {
                activity.addListener(event, caseExecutionListener);
            }
        }
    }

    protected CaseExecutionListener initializeCaseExecutionListener(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CamundaCaseExecutionListener listener) {
        ExecutableScript executableScript;
        Collection fields = listener.getCamundaFields();
        List<FieldDeclaration> fieldDeclarations = this.initializeFieldDeclarations(element, activity, context, fields);
        ExpressionManager expressionManager = context.getExpressionManager();
        CaseExecutionListener caseExecutionListener = null;
        String className = listener.getCamundaClass();
        String expression = listener.getCamundaExpression();
        String delegateExpression = listener.getCamundaDelegateExpression();
        CamundaScript scriptElement = listener.getCamundaScript();
        if (className != null) {
            caseExecutionListener = new ClassDelegateCaseExecutionListener(className, fieldDeclarations);
        } else if (expression != null) {
            Expression expressionExp = expressionManager.createExpression(expression);
            caseExecutionListener = new ExpressionCaseExecutionListener(expressionExp);
        } else if (delegateExpression != null) {
            Expression delegateExp = expressionManager.createExpression(delegateExpression);
            caseExecutionListener = new DelegateExpressionCaseExecutionListener(delegateExp, fieldDeclarations);
        } else if (scriptElement != null && (executableScript = this.initializeScript(element, activity, context, scriptElement)) != null) {
            caseExecutionListener = new ScriptCaseExecutionListener(executableScript);
        }
        return caseExecutionListener;
    }

    protected ExecutableScript initializeScript(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CamundaScript script) {
        String language = script.getCamundaScriptFormat();
        String resource = script.getCamundaResource();
        String source = script.getTextContent();
        return this.initializeScriptDefinition(language, resource, source, context);
    }

    public ExecutableScript initializeScriptDefinition(String language, String resource, String source, CmmnHandlerContext context) {
        if (language != null) {
            if (resource != null && !resource.isEmpty()) {
                return this.parseScriptResource(resource, language, context);
            }
            if (source != null) {
                return this.parseScriptSource(source, language, context);
            }
        }
        return null;
    }

    protected ExecutableScript parseScriptSource(String source, String language, CmmnHandlerContext context) {
        if (StringUtil.isExpression(source) && !JuelScriptEngineFactory.names.contains(language)) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression scriptExpression = expressionManager.createExpression(source.trim());
            return new DynamicSourceExecutableScript(scriptExpression, language);
        }
        return this.parseScript(source, language);
    }

    protected ExecutableScript parseScriptResource(String resource, String language, CmmnHandlerContext context) {
        if (StringUtil.isExpression(resource)) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression scriptResourceExpression = expressionManager.createExpression(resource);
            return new DynamicResourceExecutableScript(scriptResourceExpression, language);
        }
        DeploymentEntity deployment = (DeploymentEntity)context.getDeployment();
        String scriptSource = ResourceUtil.loadResourceContent(resource, deployment);
        return this.parseScript(scriptSource, language);
    }

    protected ExecutableScript parseScript(String script, String language) {
        return Context.getProcessEngineConfiguration().getScriptFactory().createScript(script, language);
    }

    protected List<FieldDeclaration> initializeFieldDeclarations(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, Collection<CamundaField> fields) {
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        for (CamundaField field : fields) {
            FieldDeclaration fieldDeclaration = this.initializeFieldDeclaration(element, activity, context, field);
            fieldDeclarations.add(fieldDeclaration);
        }
        return fieldDeclarations;
    }

    protected FieldDeclaration initializeFieldDeclaration(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CamundaField field) {
        String name = field.getCamundaName();
        String type = Expression.class.getName();
        Expression value = this.getFixedValue(field);
        if (value == null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            value = this.getExpressionValue(field, expressionManager);
        }
        return new FieldDeclaration(name, type, value);
    }

    protected FixedValue getFixedValue(CamundaField field) {
        CamundaString strg = field.getCamundaString();
        String value = null;
        if (strg != null) {
            value = strg.getTextContent();
        }
        if (value == null) {
            value = field.getCamundaStringValue();
        }
        if (value != null) {
            return new FixedValue(value);
        }
        return null;
    }

    protected Expression getExpressionValue(CamundaField field, ExpressionManager expressionManager) {
        CamundaExpression expression = field.getCamundaExpressionChild();
        String value = null;
        if (expression != null) {
            value = expression.getTextContent();
        }
        if (value == null) {
            value = field.getCamundaExpression();
        }
        if (value != null) {
            return expressionManager.createExpression(value);
        }
        return null;
    }

    protected PlanItemControl getDefaultControl(CmmnElement element) {
        PlanItemDefinition definition = this.getDefinition(element);
        return definition.getDefaultControl();
    }

    protected <V extends ModelElementInstance> List<V> queryExtensionElementsByClass(CmmnElement element, Class<V> cls) {
        ExtensionElements extensionElements = this.getExtensionElements(element);
        if (extensionElements != null) {
            Query query = extensionElements.getElementsQuery();
            return query.filterByType(cls).list();
        }
        return new ArrayList();
    }

    protected ExtensionElements getExtensionElements(CmmnElement element) {
        return element.getExtensionElements();
    }

    protected PlanItemControl getItemControl(CmmnElement element) {
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            return planItem.getItemControl();
        }
        if (this.isDiscretionaryItem(element)) {
            DiscretionaryItem discretionaryItem = (DiscretionaryItem)element;
            return discretionaryItem.getItemControl();
        }
        return null;
    }

    protected String getName(CmmnElement element) {
        PlanItemDefinition definition;
        String name = null;
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            name = planItem.getName();
        }
        if ((name == null || name.isEmpty()) && (definition = this.getDefinition(element)) != null) {
            name = definition.getName();
        }
        return name;
    }

    protected PlanItemDefinition getDefinition(CmmnElement element) {
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            return planItem.getDefinition();
        }
        if (this.isDiscretionaryItem(element)) {
            DiscretionaryItem discretionaryItem = (DiscretionaryItem)element;
            return discretionaryItem.getDefinition();
        }
        return null;
    }

    protected List<Sentry> getEntryCriterias(CmmnElement element) {
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            return (List)planItem.getEntryCriterias();
        }
        return new ArrayList<Sentry>();
    }

    protected List<Sentry> getExitCriterias(CmmnElement element) {
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            return (List)planItem.getExitCriterias();
        }
        return new ArrayList<Sentry>();
    }

    protected String getDesciption(CmmnElement element) {
        String description = element.getDescription();
        if (description == null) {
            PlanItemDefinition definition = this.getDefinition(element);
            description = definition.getDescription();
        }
        return description;
    }

    protected boolean isPlanItem(CmmnElement element) {
        return element instanceof PlanItem;
    }

    protected boolean isDiscretionaryItem(CmmnElement element) {
        return element instanceof DiscretionaryItem;
    }

    protected abstract List<String> getStandardEvents(CmmnElement var1);
}

