/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateListener;

public abstract class CoreModelElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected Map<String, Object> properties;
    protected Map<String, List<DelegateListener<? extends BaseDelegateExecution>>> builtInListeners = new HashMap<String, List<DelegateListener<? extends BaseDelegateExecution>>>();
    protected Map<String, List<DelegateListener<? extends BaseDelegateExecution>>> listeners = new HashMap<String, List<DelegateListener<? extends BaseDelegateExecution>>>();

    public CoreModelElement(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DelegateListener<? extends BaseDelegateExecution>> getListeners(String eventName) {
        List<DelegateListener<? extends BaseDelegateExecution>> listenerList = this.getListeners().get(eventName);
        if (listenerList != null) {
            return listenerList;
        }
        return Collections.emptyList();
    }

    public List<DelegateListener<? extends BaseDelegateExecution>> getBuiltInListeners(String eventName) {
        List<DelegateListener<? extends BaseDelegateExecution>> listenerList = this.getBuiltInListeners().get(eventName);
        if (listenerList != null) {
            return listenerList;
        }
        return Collections.emptyList();
    }

    public void addListener(String eventName, DelegateListener<? extends BaseDelegateExecution> listener) {
        this.addListener(eventName, listener, -1);
    }

    public void addBuiltInListener(String eventName, DelegateListener<? extends BaseDelegateExecution> listener) {
        this.addBuiltInListener(eventName, listener, -1);
    }

    public void addBuiltInListener(String eventName, DelegateListener<? extends BaseDelegateExecution> listener, int index) {
        this.addListenerToMap(this.listeners, eventName, listener, index);
        this.addListenerToMap(this.builtInListeners, eventName, listener, index);
    }

    public void addListener(String eventName, DelegateListener<? extends BaseDelegateExecution> listener, int index) {
        this.addListenerToMap(this.listeners, eventName, listener, index);
    }

    private void addListenerToMap(Map<String, List<DelegateListener<? extends BaseDelegateExecution>>> listenerMap, String eventName, DelegateListener<? extends BaseDelegateExecution> listener, int index) {
        List<DelegateListener<? extends BaseDelegateExecution>> listeners = listenerMap.get(eventName);
        if (listeners == null) {
            listeners = new ArrayList<DelegateListener<? extends BaseDelegateExecution>>();
            listenerMap.put(eventName, listeners);
        }
        if (index < 0) {
            listeners.add(listener);
        } else {
            listeners.add(index, listener);
        }
    }

    public Map<String, List<DelegateListener<? extends BaseDelegateExecution>>> getListeners() {
        return this.listeners;
    }

    public Map<String, List<DelegateListener<? extends BaseDelegateExecution>>> getBuiltInListeners() {
        return this.builtInListeners;
    }
}

