/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.handler;

import java.util.Map;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.form.StartFormDataImpl;
import org.camunda.bpm.engine.impl.form.handler.DefaultFormHandler;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.xml.Element;

public class DefaultStartFormHandler
extends DefaultFormHandler
implements StartFormHandler {
    protected Expression formKey;

    @Override
    public void parseConfiguration(Element activityElement, DeploymentEntity deployment, ProcessDefinitionEntity processDefinition, BpmnParse bpmnParse) {
        super.parseConfiguration(activityElement, deployment, processDefinition, bpmnParse);
        ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
        String formKeyAttribute = activityElement.attributeNS("http://activiti.org/bpmn", "formKey");
        if (formKeyAttribute != null) {
            this.formKey = expressionManager.createExpression(formKeyAttribute);
        }
        if (this.formKey != null) {
            processDefinition.setStartFormKey(true);
        }
    }

    @Override
    public StartFormData createStartFormData(ProcessDefinitionEntity processDefinition) {
        StartFormDataImpl startFormData = new StartFormDataImpl();
        if (this.formKey != null) {
            startFormData.setFormKey(this.formKey.getExpressionText());
        }
        startFormData.setDeploymentId(this.deploymentId);
        startFormData.setProcessDefinition(processDefinition);
        this.initializeFormProperties(startFormData, null);
        this.initializeFormFields(startFormData, null);
        return startFormData;
    }

    public ExecutionEntity submitStartFormData(ExecutionEntity processInstance, Map<String, Object> properties) {
        this.submitFormProperties(properties, processInstance);
        return processInstance;
    }

    public Expression getFormKey() {
        return this.formKey;
    }
}

