/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;

public abstract class JobEntity
implements Serializable,
Job,
PersistentObject,
HasRevision {
    private static final Logger LOG = Logger.getLogger(JobEntity.class.getName());
    public static final boolean DEFAULT_EXCLUSIVE = true;
    public static final int DEFAULT_RETRIES = 3;
    private static final int MAX_EXCEPTION_MESSAGE_LENGTH = 255;
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected Date duedate;
    protected String lockOwner = null;
    protected Date lockExpirationTime = null;
    protected String executionId = null;
    protected String processInstanceId = null;
    protected String processDefinitionId = null;
    protected String processDefinitionKey = null;
    protected boolean isExclusive = true;
    protected int retries = 3;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String jobHandlerType = null;
    protected String jobHandlerConfiguration = null;
    protected ByteArrayEntity exceptionByteArray;
    protected String exceptionByteArrayId;
    protected String exceptionMessage;
    protected String deploymentId;
    protected String jobDefinitionId;

    public void execute(CommandContext commandContext) {
        ExecutionEntity execution = null;
        if (this.executionId != null) {
            execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
            EnsureUtil.ensureNotNull("Cannot find execution with id '" + this.executionId + "' referenced from job '" + this + "'", "execution", (Object)execution);
        }
        Map<String, JobHandler> jobHandlers = Context.getProcessEngineConfiguration().getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(this.jobHandlerType);
        jobHandler.execute(this.jobHandlerConfiguration, execution, commandContext);
    }

    public void insert() {
        DbSqlSession dbSqlSession = Context.getCommandContext().getDbSqlSession();
        dbSqlSession.insert(this);
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
            execution.addJob(this);
            this.deploymentId = execution.getProcessDefinition().getDeploymentId();
        }
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean incidentResolved) {
        DbSqlSession dbSqlSession = Context.getCommandContext().getDbSqlSession();
        dbSqlSession.delete(this);
        if (this.exceptionByteArrayId != null) {
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.exceptionByteArrayId);
        }
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
            execution.removeJob(this);
        }
        this.removeFailedJobIncident(incidentResolved);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("executionId", this.executionId);
        persistentState.put("lockOwner", this.lockOwner);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        persistentState.put("retries", this.retries);
        persistentState.put("duedate", this.duedate);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        persistentState.put("suspensionState", this.suspensionState);
        if (this.exceptionByteArrayId != null) {
            persistentState.put("exceptionByteArrayId", this.exceptionByteArrayId);
        }
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        execution.addJob(this);
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        if (this.retries == 0 && retries > 0) {
            this.removeFailedJobIncident(true);
        }
        if (retries == 0) {
            this.createFailedJobIncident();
        }
        this.retries = retries;
    }

    public void setRetriesFromPersistence(int retries) {
        this.retries = retries;
    }

    protected void createFailedJobIncident() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isCreateIncidentOnFailedJobEnabled()) {
            String incidentHandlerType = "failedJob";
            if (this.id == null) {
                this.id = processEngineConfiguration.getIdGenerator().getNextId();
            } else {
                List<Incident> failedJobIncidents = Context.getCommandContext().getIncidentManager().findIncidentByConfigurationAndIncidentType(this.id, incidentHandlerType);
                if (!failedJobIncidents.isEmpty()) {
                    return;
                }
            }
            processEngineConfiguration.getIncidentHandler(incidentHandlerType).handleIncident(this.getProcessDefinitionId(), null, this.executionId, this.id, this.exceptionMessage);
        }
    }

    protected void removeFailedJobIncident(boolean incidentResolved) {
        IncidentHandler handler = Context.getProcessEngineConfiguration().getIncidentHandler("failedJob");
        if (incidentResolved) {
            handler.resolveIncident(this.getProcessDefinitionId(), null, this.executionId, this.id);
        } else {
            handler.deleteIncident(this.getProcessDefinitionId(), null, this.executionId, this.id);
        }
    }

    public String getExceptionStacktrace() {
        String exception = null;
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        if (byteArray != null) {
            try {
                exception = new String(byteArray.getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ProcessEngineException("UTF-8 is not a supported encoding");
            }
        }
        return exception;
    }

    public void setSuspensionState(int state) {
        this.suspensionState = state;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String claimedBy) {
        this.lockOwner = claimedBy;
    }

    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date claimedUntil) {
        this.lockExpirationTime = claimedUntil;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    public void setExceptionStacktrace(String exception) {
        byte[] exceptionBytes = null;
        if (exception == null) {
            exceptionBytes = null;
        } else {
            try {
                exceptionBytes = exception.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ProcessEngineException("UTF-8 is not a supported encoding");
            }
        }
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        if (byteArray == null) {
            byteArray = new ByteArrayEntity("job.exceptionByteArray", exceptionBytes);
            Context.getCommandContext().getDbSqlSession().insert(byteArray);
            this.exceptionByteArrayId = byteArray.getId();
            this.exceptionByteArray = byteArray;
        } else {
            byteArray.setBytes(exceptionBytes);
        }
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage != null && exceptionMessage.length() > 255 ? exceptionMessage.substring(0, 255) : exceptionMessage;
    }

    public String getExceptionByteArrayId() {
        return this.exceptionByteArrayId;
    }

    private ByteArrayEntity getExceptionByteArray() {
        if (this.exceptionByteArray == null && this.exceptionByteArrayId != null) {
            this.exceptionByteArray = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, this.exceptionByteArrayId);
        }
        return this.exceptionByteArray;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", duedate=" + this.duedate + ", lockOwner=" + this.lockOwner + ", lockExpirationTime=" + this.lockExpirationTime + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", isExclusive=" + this.isExclusive + ", isExclusive=" + this.isExclusive + ", jobDefinitionId=" + this.jobDefinitionId + ", jobHandlerType=" + this.jobHandlerType + ", jobHandlerConfiguration=" + this.jobHandlerConfiguration + ", exceptionByteArray=" + this.exceptionByteArray + ", exceptionByteArrayId=" + this.exceptionByteArrayId + ", exceptionMessage=" + this.exceptionMessage + ", deploymentId=" + this.deploymentId + "]";
    }
}

