/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationTransitionDestroyScope
implements PvmAtomicOperation {
    private static Logger log = Logger.getLogger(PvmAtomicOperationTransitionDestroyScope.class.getName());

    @Override
    public boolean isAsync(PvmExecutionImpl instance) {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        PvmExecutionImpl propagatingExecution = null;
        ActivityImpl activity = execution.getActivity();
        if (activity.isScope()) {
            PvmExecutionImpl parentScopeInstance = null;
            if (execution.isConcurrent() && !execution.isScope()) {
                PvmExecutionImpl concurrentRoot = execution.getParent();
                parentScopeInstance = execution.getParent().getParent();
                log.fine("moving concurrent " + execution + " one scope up under " + parentScopeInstance);
                List<? extends PvmExecutionImpl> parentScopeInstanceExecutions = parentScopeInstance.getExecutions();
                List<? extends PvmExecutionImpl> concurrentRootExecutions = concurrentRoot.getExecutions();
                if (parentScopeInstanceExecutions.size() == 1) {
                    parentScopeInstanceExecutions.get(0).setConcurrent(true);
                }
                concurrentRootExecutions.remove(execution);
                parentScopeInstanceExecutions.add(execution);
                execution.setParent(parentScopeInstance);
                execution.setActivity(activity);
                propagatingExecution = execution;
                if (concurrentRootExecutions.size() == 1) {
                    PvmExecutionImpl lastConcurrent = concurrentRootExecutions.get(0);
                    if (lastConcurrent.isScope()) {
                        lastConcurrent.setConcurrent(false);
                    } else {
                        log.fine("merging last concurrent " + lastConcurrent + " into concurrent root " + concurrentRoot);
                        concurrentRoot.setActivity(lastConcurrent.getActivity());
                        concurrentRoot.setActive(lastConcurrent.isActive());
                        lastConcurrent.setReplacedBy(concurrentRoot);
                        lastConcurrent.remove();
                    }
                }
            } else if (execution.isConcurrent() && execution.isScope()) {
                log.fine("scoped concurrent " + execution + " becomes concurrent and remains under " + execution.getParent());
                execution.destroy();
                propagatingExecution = execution;
            } else {
                propagatingExecution = execution.getParent();
                propagatingExecution.setActivity(execution.getActivity());
                propagatingExecution.setTransition(execution.getTransition());
                propagatingExecution.setActive(true);
                log.fine("destroy scope: scoped " + execution + " continues as parent scope " + propagatingExecution);
                execution.destroy();
                execution.remove();
            }
        } else {
            propagatingExecution = execution;
        }
        ScopeImpl nextOuterScopeElement = activity.getParent();
        TransitionImpl transition = propagatingExecution.getTransition();
        ActivityImpl destination = transition.getDestination();
        if (this.transitionLeavesNextOuterScope(nextOuterScopeElement, activity, destination)) {
            propagatingExecution.setActivity((ActivityImpl)nextOuterScopeElement);
            propagatingExecution.performOperation(TRANSITION_NOTIFY_LISTENER_END);
        } else {
            propagatingExecution.performOperation(TRANSITION_NOTIFY_LISTENER_TAKE);
        }
    }

    public boolean transitionLeavesNextOuterScope(ScopeImpl nextScopeElement, ActivityImpl current, ActivityImpl destination) {
        return !current.isCancelScope() && !current.isConcurrent() && !nextScopeElement.contains(destination);
    }

    @Override
    public String getCanonicalName() {
        return "transition-destroy-scope";
    }
}

