/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.util.Collection;
import org.camunda.bpm.engine.ProcessEngineException;

public final class EnsureUtil {
    public static void ensureNotNull(String variableName, Object value) {
        EnsureUtil.ensureNotNull(null, variableName, value);
    }

    public static void ensureNotNull(String message, String variableName, Object value) {
        if (value == null) {
            throw EnsureUtil.generateException(message, variableName, "is null");
        }
    }

    public static void ensureNotNull(String variableName, Object ... values) {
        EnsureUtil.ensureNotNull(null, variableName, values);
    }

    public static void ensureNotNull(String message, String variableName, Object ... values) {
        if (values == null) {
            throw EnsureUtil.generateException(message, variableName, "is null");
        }
        for (Object value : values) {
            if (value != null) continue;
            throw EnsureUtil.generateException(message, variableName, "contains null value");
        }
    }

    public static void ensureNotEmpty(String variableName, String value) {
        EnsureUtil.ensureNotEmpty(null, variableName, value);
    }

    public static void ensureNotEmpty(String message, String variableName, String value) {
        EnsureUtil.ensureNotNull(message, variableName, (Object)value);
        if (value.trim().isEmpty()) {
            throw EnsureUtil.generateException(message, variableName, "is empty");
        }
    }

    public static void ensureNotEmpty(String variableName, Collection collection) {
        EnsureUtil.ensureNotEmpty(null, variableName, collection);
    }

    public static void ensureNotEmpty(String message, String variableName, Collection collection) {
        EnsureUtil.ensureNotNull(message, variableName, (Object)collection);
        if (collection.isEmpty()) {
            throw EnsureUtil.generateException(message, variableName, "is empty");
        }
    }

    public static void ensurePositive(String variableName, Integer value) {
        EnsureUtil.ensurePositive(null, variableName, value);
    }

    public static void ensurePositive(String message, String variableName, Integer value) {
        EnsureUtil.ensureNotNull(variableName, (Object)value);
        if (value <= 0) {
            throw EnsureUtil.generateException(message, variableName, "is not positive");
        }
    }

    public static void ensureInstanceOf(String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureInstanceOf(null, variableName, value, expectedClass);
    }

    public static void ensureInstanceOf(String message, String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureNotNull(message, variableName, value);
        Class<?> valueClass = value.getClass();
        if (!expectedClass.isAssignableFrom(valueClass)) {
            throw EnsureUtil.generateException(message, variableName, "has class " + valueClass.getName() + " and not " + expectedClass.getName());
        }
    }

    public static void ensureOnlyOneNotNull(String message, Object ... values) {
        boolean oneNotNull = false;
        for (Object value : values) {
            if (value == null) continue;
            if (oneNotNull) {
                throw EnsureUtil.generateException(null, null, message);
            }
            oneNotNull = true;
        }
        if (!oneNotNull) {
            throw EnsureUtil.generateException(null, null, message);
        }
    }

    public static void ensureAtLeastOneNotNull(String message, Object ... values) {
        for (Object value : values) {
            if (value == null) continue;
            return;
        }
        throw EnsureUtil.generateException(null, null, message);
    }

    protected static ProcessEngineException generateException(String message, String variableName, String description) {
        return new ProcessEngineException(EnsureUtil.formatMessage(message, variableName, description));
    }

    protected static String formatMessage(String message, String variableName, String description) {
        return EnsureUtil.formatMessageElement(message, ": ") + EnsureUtil.formatMessageElement(variableName, " ") + description;
    }

    protected static String formatMessageElement(String element, String delimiter) {
        if (element != null && !element.isEmpty()) {
            return element.concat(delimiter);
        }
        return "";
    }
}

