/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;

public class ByteArrayType
implements VariableType {
    public static final String TYPE_NAME = "bytes";

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getByteArrayValueId() == null) {
            return null;
        }
        ByteArrayEntity byteArrayValue = valueFields.getByteArrayValue();
        if (byteArrayValue != null) {
            return byteArrayValue.getBytes();
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        ByteArrayEntity byteArray = valueFields.getByteArrayValue();
        byte[] bytes = (byte[])value;
        if (byteArray == null) {
            valueFields.setByteArrayValue(bytes);
        } else {
            byteArray.setBytes(bytes);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return byte[].class.isAssignableFrom(value.getClass());
    }

    @Override
    public String getTypeNameForValue(Object value) {
        return "Binary";
    }

    @Override
    public Object getRawValue(ValueFields valueFields) {
        return this.getValue(valueFields);
    }
}

