/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.camunda.bpm.container.impl.deployment.scanning.ProcessApplicationScanningUtil;
import org.junit.Assert;
import org.junit.Test;

public class VfsProcessApplicationScannerTest {
    @Test
    public void testScanProcessArchivePathForResources() throws MalformedURLException {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new URL("file:")});
        String processRootPath = "classpath:org/camunda/bpm/container/impl/jmx/deployment/process/";
        Map scanResult = ProcessApplicationScanningUtil.findResources((ClassLoader)classLoader, (String)processRootPath, null);
        Assert.assertEquals((long)1L, (long)scanResult.size());
        String processFileName = "VfsProcessScannerTest.bpmn20.xml";
        Assert.assertTrue((String)("'" + processFileName + "'not found"), (boolean)this.contains(scanResult, processFileName));
        Assert.assertFalse((String)"'bpmn' folder in resource path found", (boolean)this.contains(scanResult, "processResource.txt"));
    }

    @Test
    public void testScanProcessArchivePathForCmmnResources() throws MalformedURLException {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new URL("file:")});
        String processRootPath = "classpath:org/camunda/bpm/container/impl/jmx/deployment/case/";
        Map scanResult = ProcessApplicationScanningUtil.findResources((ClassLoader)classLoader, (String)processRootPath, null);
        Assert.assertEquals((long)1L, (long)scanResult.size());
        String processFileName = "VfsProcessScannerTest.cmmn";
        Assert.assertTrue((String)("'" + processFileName + "' not found"), (boolean)this.contains(scanResult, processFileName));
        Assert.assertFalse((String)"'cmmn' in resource path found", (boolean)this.contains(scanResult, "caseResource.txt"));
    }

    @Test
    public void testScanProcessArchivePathWithAdditionalResourceSuffixes() throws MalformedURLException {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new URL("file:")});
        String processRootPath = "classpath:org/camunda/bpm/container/impl/jmx/deployment/script/";
        String[] additionalResourceSuffixes = new String[]{"py", "groovy", "rb"};
        Map scanResult = ProcessApplicationScanningUtil.findResources((ClassLoader)classLoader, (String)processRootPath, null, (String[])additionalResourceSuffixes);
        Assert.assertEquals((long)4L, (long)scanResult.size());
        String processFileName = "VfsProcessScannerTest.bpmn20.xml";
        Assert.assertTrue((String)("'" + processFileName + "' not found"), (boolean)this.contains(scanResult, processFileName));
        Assert.assertTrue((String)"'hello.py' in resource path found", (boolean)this.contains(scanResult, "hello.py"));
        Assert.assertTrue((String)"'hello.rb' in resource path found", (boolean)this.contains(scanResult, "hello.rb"));
        Assert.assertTrue((String)"'hello.groovy' in resource path found", (boolean)this.contains(scanResult, "hello.groovy"));
    }

    private boolean contains(Map<String, byte[]> scanResult, String suffix) {
        for (String string : scanResult.keySet()) {
            if (!string.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

