/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;

public class CaseServiceTest
extends PluggableProcessEngineTestCase {
    public void testCreateCaseInstanceQuery() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        CaseServiceTest.assertNotNull((Object)query);
    }

    public void testCreateCaseExecutionQuery() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        CaseServiceTest.assertNotNull((Object)query);
    }

    public void testWithCaseExecution() {
        CaseExecutionCommandBuilder builder = this.caseService.withCaseExecution("aCaseExecutionId");
        CaseServiceTest.assertNotNull((Object)builder);
    }

    public void testManualStartInvalidCaseExecution() {
        try {
            this.caseService.withCaseExecution("invalid").manualStart();
            CaseServiceTest.fail();
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).manualStart();
            CaseServiceTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testCompleteInvalidCaseExeuction() {
        try {
            this.caseService.withCaseExecution("invalid").complete();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).complete();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testCloseInvalidCaseExeuction() {
        try {
            this.caseService.withCaseExecution("invalid").close();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).close();
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableAndVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).setVariable("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableLocalAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).setVariableLocal("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteSetVariableAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).setVariableLocal("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)1, (int)result.size());
        VariableInstance aThirdVariable = (VariableInstance)result.get(0);
        CaseServiceTest.assertNotNull((Object)aThirdVariable);
        CaseServiceTest.assertEquals((String)"aThirdVariable", (String)aThirdVariable.getName());
        CaseServiceTest.assertEquals((Object)123, (Object)aThirdVariable.getValue());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)3, (int)result.size());
        for (VariableInstance variable : result) {
            if (variable.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                CaseServiceTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
                CaseServiceTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
                CaseServiceTest.assertEquals((String)"aThirdVariable", (String)variable.getName());
                CaseServiceTest.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).removeVariable("aVariableName").removeVariable("anotherVariableName").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariableAndVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("aThirdVariable", (Object)123).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).removeVariable("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        this.caseService.withCaseExecution(caseExecutionId).removeVariableLocal("aVariableName").removeVariableLocal("anotherVariableName").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariablesLocal(variableNames).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariableLocalAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).setVariableLocal("aThirdVariable", (Object)123).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariablesLocal(variableNames).removeVariableLocal("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveVariableAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariableLocal("aThirdVariable", (Object)123).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).removeVariableLocal("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        CaseServiceTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveAndSetSameVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).removeVariable("aVariableName").setVariable("aVariableName", (Object)"xyz").execute();
        }
        catch (NotValidException e) {
            this.assertTextPresent("Cannot set and remove a variable with the same variable name: 'aVariableName' within a command.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExecuteRemoveAndSetSameLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"xyz").removeVariableLocal("aVariableName").execute();
        }
        catch (NotValidException e) {
            this.assertTextPresent("Cannot set and remove a variable with the same variable name: 'aVariableName' within a command.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Map variables = this.caseService.getVariables(caseExecutionId);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", variables.get("aVariableName"));
        CaseServiceTest.assertEquals((Object)999, variables.get("anotherVariableName"));
    }

    public void testGetVariablesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariables("invalid");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariables(null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesWithVariableNames() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("thirVariable", (Object)"xyz").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        Map variables = this.caseService.getVariables(caseExecutionId, names);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", variables.get("aVariableName"));
        CaseServiceTest.assertEquals((Object)999, variables.get("anotherVariableName"));
    }

    public void testGetVariablesWithVariablesNamesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariables("invalid", null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariables(null, null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        Map variables = this.caseService.getVariablesLocal(caseExecutionId);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", variables.get("aVariableName"));
        CaseServiceTest.assertEquals((Object)999, variables.get("anotherVariableName"));
    }

    public void testGetVariablesLocalInvalidCaseExecutionId() {
        try {
            this.caseService.getVariablesLocal("invalid");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariablesLocal(null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariablesLocalWithVariableNames() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        Map variables = this.caseService.getVariablesLocal(caseExecutionId, names);
        CaseServiceTest.assertNotNull((Object)variables);
        CaseServiceTest.assertFalse((boolean)variables.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)variables.size());
        CaseServiceTest.assertEquals((Object)"abc", variables.get("aVariableName"));
        CaseServiceTest.assertEquals((Object)999, variables.get("anotherVariableName"));
    }

    public void testGetVariablesLocalWithVariablesNamesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariablesLocal("invalid", null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariablesLocal(null, null);
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("thirVariable", (Object)"xyz").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Object value = this.caseService.getVariable(caseExecutionId, "aVariableName");
        CaseServiceTest.assertNotNull((Object)value);
        CaseServiceTest.assertEquals((Object)"abc", (Object)value);
    }

    public void testGetVariableInvalidCaseExecutionId() {
        try {
            this.caseService.getVariable("invalid", "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariable(null, "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testGetVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        Object value = this.caseService.getVariableLocal(caseExecutionId, "aVariableName");
        CaseServiceTest.assertNotNull((Object)value);
        CaseServiceTest.assertEquals((Object)"abc", (Object)value);
    }

    public void testGetVariableLocalInvalidCaseExecutionId() {
        try {
            this.caseService.getVariableLocal("invalid", "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.caseService.getVariableLocal(null, "aVariableName");
            CaseServiceTest.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }
}

