/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class JobQueryTest
extends PluggableProcessEngineTestCase {
    private String deploymentId;
    private String messageId;
    private CommandExecutor commandExecutor;
    private TimerEntity timerEntity;
    private Date testStartTime;
    private Date timerOneFireTime;
    private Date timerTwoFireTime;
    private Date timerThreeFireTime;
    private String processInstanceIdOne;
    private String processInstanceIdTwo;
    private String processInstanceIdThree;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_SECOND = 1000L;
    private static final String EXCEPTION_MESSAGE = "java.lang.RuntimeException: This is an exception thrown from scriptTask";

    protected void setUp() throws Exception {
        super.setUp();
        this.commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/timerOnTask.bpmn20.xml").deploy().getId();
        Calendar startTime = Calendar.getInstance();
        startTime.set(14, 0);
        Date t1 = startTime.getTime();
        ClockUtil.setCurrentTime((Date)t1);
        this.processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("timerOnTask").getId();
        this.testStartTime = t1;
        this.timerOneFireTime = new Date(t1.getTime() + 3600000L);
        startTime.add(11, 1);
        Date t2 = startTime.getTime();
        ClockUtil.setCurrentTime((Date)t2);
        this.processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("timerOnTask").getId();
        this.timerTwoFireTime = new Date(t2.getTime() + 3600000L);
        startTime.add(11, 1);
        Date t3 = startTime.getTime();
        ClockUtil.setCurrentTime((Date)t3);
        this.processInstanceIdThree = this.runtimeService.startProcessInstanceByKey("timerOnTask").getId();
        this.timerThreeFireTime = new Date(t3.getTime() + 3600000L);
        this.messageId = (String)this.commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = new MessageEntity();
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeployment(this.deploymentId, true);
        this.commandExecutor.execute((Command)new DeleteJobsCmd(this.messageId));
        super.tearDown();
    }

    public void testQueryByNoCriteria() {
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 4);
    }

    public void testByJobDefinitionId() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery query = this.managementService.createJobQuery().jobDefinitionId(jobDefinition.getId());
        this.verifyQueryResults(query, 3);
    }

    public void testByInvalidJobDefinitionId() {
        JobQuery query = this.managementService.createJobQuery().jobDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().jobDefinitionId(null).list();
            JobQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByProcessInstanceId() {
        JobQuery query = this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidProcessInstanceId() {
        JobQuery query = this.managementService.createJobQuery().processInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().processInstanceId(null);
            JobQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByExecutionId() {
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne).singleResult();
        JobQuery query = this.managementService.createJobQuery().executionId(job.getExecutionId());
        JobQueryTest.assertEquals((String)((Job)query.singleResult()).getId(), (String)job.getId());
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidExecutionId() {
        JobQuery query = this.managementService.createJobQuery().executionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().executionId(null).list();
            JobQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().list().get(0);
        JobQuery query = this.managementService.createJobQuery().processDefinitionId(processDefinition.getId());
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByInvalidProcessDefinitionId() {
        JobQuery query = this.managementService.createJobQuery().processDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().processDefinitionId(null).list();
            JobQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByProcessDefinitionKey() {
        JobQuery query = this.managementService.createJobQuery().processDefinitionKey("timerOnTask");
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByInvalidProcessDefinitionKey() {
        JobQuery query = this.managementService.createJobQuery().processDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().processDefinitionKey(null).list();
            JobQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByRetriesLeft() {
        JobQuery query = this.managementService.createJobQuery().withRetriesLeft();
        this.verifyQueryResults(query, 4);
        this.setRetries(this.processInstanceIdOne, 0);
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByExecutable() {
        ClockUtil.setCurrentTime((Date)new Date(this.timerThreeFireTime.getTime() + 1000L));
        JobQuery query = this.managementService.createJobQuery().executable();
        this.verifyQueryResults(query, 4);
        this.setRetries(this.processInstanceIdOne, 0);
        this.verifyQueryResults(query, 3);
        ClockUtil.setCurrentTime((Date)this.testStartTime);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByOnlyTimers() {
        JobQuery query = this.managementService.createJobQuery().timers();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByOnlyMessages() {
        JobQuery query = this.managementService.createJobQuery().messages();
        this.verifyQueryResults(query, 1);
    }

    public void testInvalidOnlyTimersUsage() {
        try {
            this.managementService.createJobQuery().timers().messages().list();
            JobQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot combine onlyTimers() with onlyMessages() in the same query", e.getMessage());
        }
    }

    public void testQueryByDuedateLowerThen() {
        JobQuery query = this.managementService.createJobQuery().duedateLowerThen(this.testStartTime);
        this.verifyQueryResults(query, 0);
        query = this.managementService.createJobQuery().duedateLowerThen(new Date(this.timerOneFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobQuery().duedateLowerThen(new Date(this.timerTwoFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 2);
        query = this.managementService.createJobQuery().duedateLowerThen(new Date(this.timerThreeFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByDuedateLowerThenOrEqual() {
        JobQuery query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.testStartTime);
        this.verifyQueryResults(query, 0);
        query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.timerOneFireTime);
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.timerTwoFireTime);
        this.verifyQueryResults(query, 2);
        query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.timerThreeFireTime);
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByDuedateHigherThen() {
        JobQuery query = this.managementService.createJobQuery().duedateHigherThen(this.testStartTime);
        this.verifyQueryResults(query, 3);
        query = this.managementService.createJobQuery().duedateHigherThen(this.timerOneFireTime);
        this.verifyQueryResults(query, 2);
        query = this.managementService.createJobQuery().duedateHigherThen(this.timerTwoFireTime);
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobQuery().duedateHigherThen(this.timerThreeFireTime);
        this.verifyQueryResults(query, 0);
    }

    public void testQueryByDuedateHigherThenOrEqual() {
        JobQuery query = this.managementService.createJobQuery().duedateHigherThenOrEquals(this.testStartTime);
        this.verifyQueryResults(query, 3);
        query = this.managementService.createJobQuery().duedateHigherThenOrEquals(this.timerOneFireTime);
        this.verifyQueryResults(query, 3);
        query = this.managementService.createJobQuery().duedateHigherThenOrEquals(new Date(this.timerOneFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 2);
        query = this.managementService.createJobQuery().duedateHigherThenOrEquals(this.timerThreeFireTime);
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobQuery().duedateHigherThenOrEquals(new Date(this.timerThreeFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testQueryByException() {
        JobQuery query = this.managementService.createJobQuery().withException();
        this.verifyQueryResults(query, 0);
        ProcessInstance processInstance = this.startProcessInstanceWithFailingJob();
        query = this.managementService.createJobQuery().withException();
        this.verifyFailedJob(query, processInstance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testQueryByExceptionMessage() {
        JobQuery query = this.managementService.createJobQuery().exceptionMessage(EXCEPTION_MESSAGE);
        this.verifyQueryResults(query, 0);
        ProcessInstance processInstance = this.startProcessInstanceWithFailingJob();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        query = this.managementService.createJobQuery().exceptionMessage(job.getExceptionMessage());
        this.verifyFailedJob(query, processInstance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testQueryByExceptionMessageEmpty() {
        JobQuery query = this.managementService.createJobQuery().exceptionMessage("");
        this.verifyQueryResults(query, 0);
        this.startProcessInstanceWithFailingJob();
        query = this.managementService.createJobQuery().exceptionMessage("");
        this.verifyQueryResults(query, 0);
    }

    public void testQueryByExceptionMessageNull() {
        try {
            this.managementService.createJobQuery().exceptionMessage(null);
            JobQueryTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            JobQueryTest.assertEquals((String)"Provided exception message is null", (String)e.getMessage());
        }
    }

    public void testJobQueryWithExceptions() throws Throwable {
        this.createJobWithoutExceptionMsg();
        Job job = (Job)this.managementService.createJobQuery().jobId(this.timerEntity.getId()).singleResult();
        JobQueryTest.assertNotNull((Object)job);
        List list = this.managementService.createJobQuery().withException().list();
        JobQueryTest.assertEquals((int)list.size(), (int)1);
        this.deleteJobInDatabase();
        this.createJobWithoutExceptionStacktrace();
        job = (Job)this.managementService.createJobQuery().jobId(this.timerEntity.getId()).singleResult();
        JobQueryTest.assertNotNull((Object)job);
        list = this.managementService.createJobQuery().withException().list();
        JobQueryTest.assertEquals((int)list.size(), (int)1);
        this.deleteJobInDatabase();
    }

    public void testQueryByNoRetriesLeft() {
        JobQuery query = this.managementService.createJobQuery().noRetriesLeft();
        this.verifyQueryResults(query, 0);
        this.setRetries(this.processInstanceIdOne, 0);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByActive() {
        JobQuery query = this.managementService.createJobQuery().active();
        this.verifyQueryResults(query, 4);
    }

    public void testQueryBySuspended() {
        JobQuery query = this.managementService.createJobQuery().suspended();
        this.verifyQueryResults(query, 0);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("timerOnTask", true);
        this.verifyQueryResults(query, 3);
    }

    public void testQuerySorting() {
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobId().asc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobDuedate().asc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByExecutionId().asc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessInstanceId().asc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobRetries().asc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessDefinitionId().asc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessDefinitionKey().asc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobId().desc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobDuedate().desc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByExecutionId().desc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessInstanceId().desc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobRetries().desc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessDefinitionId().desc()).count());
        JobQueryTest.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessDefinitionKey().desc()).count());
        this.setRetries(this.processInstanceIdTwo, 2);
        ClockUtil.setCurrentTime((Date)new Date(this.timerThreeFireTime.getTime() + 1000L));
        JobQuery query = (JobQuery)((JobQuery)this.managementService.createJobQuery().timers().executable().orderByJobRetries().asc()).orderByJobDuedate().desc();
        List jobs = query.list();
        JobQueryTest.assertEquals((int)3, (int)jobs.size());
        JobQueryTest.assertEquals((int)2, (int)((Job)jobs.get(0)).getRetries());
        JobQueryTest.assertEquals((int)3, (int)((Job)jobs.get(1)).getRetries());
        JobQueryTest.assertEquals((int)3, (int)((Job)jobs.get(2)).getRetries());
        JobQueryTest.assertEquals((String)this.processInstanceIdTwo, (String)((Job)jobs.get(0)).getProcessInstanceId());
        JobQueryTest.assertEquals((String)this.processInstanceIdThree, (String)((Job)jobs.get(1)).getProcessInstanceId());
        JobQueryTest.assertEquals((String)this.processInstanceIdOne, (String)((Job)jobs.get(2)).getProcessInstanceId());
    }

    public void testQueryInvalidSortingUsage() {
        try {
            this.managementService.createJobQuery().orderByJobId().list();
            JobQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.managementService.createJobQuery().asc();
            JobQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("You should call any of the orderBy methods first before specifying a direction", e.getMessage());
        }
    }

    private void setRetries(String processInstanceId, final int retries) {
        final Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobEntity timer = (JobEntity)commandContext.getDbEntityManager().selectById(JobEntity.class, job.getId());
                timer.setRetries(retries);
                return null;
            }
        });
    }

    private ProcessInstance startProcessInstanceWithFailingJob() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        JobQueryTest.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        try {
            this.managementService.executeJob(timerJob.getId());
            JobQueryTest.fail((String)"RuntimeException from within the script task expected");
        }
        catch (RuntimeException re) {
            this.assertTextPresent(EXCEPTION_MESSAGE, re.getMessage());
        }
        return processInstance;
    }

    private void verifyFailedJob(JobQuery query, ProcessInstance processInstance) {
        this.verifyQueryResults(query, 1);
        Job failedJob = (Job)query.singleResult();
        JobQueryTest.assertNotNull((Object)failedJob);
        JobQueryTest.assertEquals((String)processInstance.getId(), (String)failedJob.getProcessInstanceId());
        JobQueryTest.assertNotNull((Object)failedJob.getExceptionMessage());
        this.assertTextPresent(EXCEPTION_MESSAGE, failedJob.getExceptionMessage());
    }

    private void verifyQueryResults(JobQuery query, int countExpected) {
        JobQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        JobQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            JobQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            JobQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(JobQuery query) {
        try {
            query.singleResult();
            JobQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private void createJobWithoutExceptionMsg() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                JobQueryTest.this.timerEntity = new TimerEntity();
                JobQueryTest.this.timerEntity.setLockOwner(UUID.randomUUID().toString());
                JobQueryTest.this.timerEntity.setDuedate(new Date());
                JobQueryTest.this.timerEntity.setRetries(0);
                StringWriter stringWriter = new StringWriter();
                NullPointerException exception = new NullPointerException();
                exception.printStackTrace(new PrintWriter(stringWriter));
                JobQueryTest.this.timerEntity.setExceptionStacktrace(stringWriter.toString());
                jobManager.insert((DbEntity)JobQueryTest.this.timerEntity);
                TestCase.assertNotNull((Object)JobQueryTest.this.timerEntity.getId());
                return null;
            }
        });
    }

    private void createJobWithoutExceptionStacktrace() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                JobQueryTest.this.timerEntity = new TimerEntity();
                JobQueryTest.this.timerEntity.setLockOwner(UUID.randomUUID().toString());
                JobQueryTest.this.timerEntity.setDuedate(new Date());
                JobQueryTest.this.timerEntity.setRetries(0);
                JobQueryTest.this.timerEntity.setExceptionMessage("I'm supposed to fail");
                jobManager.insert((DbEntity)JobQueryTest.this.timerEntity);
                TestCase.assertNotNull((Object)JobQueryTest.this.timerEntity.getId());
                return null;
            }
        });
    }

    private void deleteJobInDatabase() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobQueryTest.this.timerEntity.delete();
                List historicIncidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)historicIncident);
                }
                return null;
            }
        });
    }
}

