/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.GregorianCalendar;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;

public class EventSubscriptionQueryTest
extends PluggableProcessEngineTestCase {
    public void testQueryByEventSubscriptionId() {
        this.createExampleEventSubscriptions();
        List list = this.runtimeService.createEventSubscriptionQuery().eventName("messageName2").list();
        EventSubscriptionQueryTest.assertEquals((int)1, (int)list.size());
        EventSubscription eventSubscription = (EventSubscription)list.get(0);
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery().eventSubscriptionId(eventSubscription.getId());
        EventSubscriptionQueryTest.assertEquals((long)1L, (long)query.count());
        EventSubscriptionQueryTest.assertEquals((int)1, (int)query.list().size());
        EventSubscriptionQueryTest.assertNotNull((Object)query.singleResult());
        try {
            this.runtimeService.createEventSubscriptionQuery().eventSubscriptionId(null).list();
            EventSubscriptionQueryTest.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        this.cleanDb();
    }

    public void testQueryByEventName() {
        this.createExampleEventSubscriptions();
        List list = this.runtimeService.createEventSubscriptionQuery().eventName("messageName").list();
        EventSubscriptionQueryTest.assertEquals((int)2, (int)list.size());
        list = this.runtimeService.createEventSubscriptionQuery().eventName("messageName2").list();
        EventSubscriptionQueryTest.assertEquals((int)1, (int)list.size());
        try {
            this.runtimeService.createEventSubscriptionQuery().eventName(null).list();
            EventSubscriptionQueryTest.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.cleanDb();
    }

    public void testQueryByEventType() {
        this.createExampleEventSubscriptions();
        List list = this.runtimeService.createEventSubscriptionQuery().eventType("signal").list();
        EventSubscriptionQueryTest.assertEquals((int)1, (int)list.size());
        list = this.runtimeService.createEventSubscriptionQuery().eventType("message").list();
        EventSubscriptionQueryTest.assertEquals((int)2, (int)list.size());
        try {
            this.runtimeService.createEventSubscriptionQuery().eventType(null).list();
            EventSubscriptionQueryTest.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.cleanDb();
    }

    public void testQueryByActivityId() {
        this.createExampleEventSubscriptions();
        List list = this.runtimeService.createEventSubscriptionQuery().activityId("someOtherActivity").list();
        EventSubscriptionQueryTest.assertEquals((int)1, (int)list.size());
        list = this.runtimeService.createEventSubscriptionQuery().activityId("someActivity").eventType("message").list();
        EventSubscriptionQueryTest.assertEquals((int)2, (int)list.size());
        try {
            this.runtimeService.createEventSubscriptionQuery().activityId(null).list();
            EventSubscriptionQueryTest.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.cleanDb();
    }

    @Deployment
    public void testQueryByExecutionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("catchSignal");
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().processInstanceId(processInstance.getId()).singleResult();
        EventSubscriptionQueryTest.assertNotNull((Object)subscription);
        Execution executionWaitingForSignal = (Execution)this.runtimeService.createExecutionQuery().activityId("signalEvent").processInstanceId(processInstance.getId()).singleResult();
        EventSubscription signalSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().executionId(executionWaitingForSignal.getId()).singleResult();
        EventSubscriptionQueryTest.assertNotNull((Object)signalSubscription);
        EventSubscriptionQueryTest.assertEquals((Object)signalSubscription, (Object)subscription);
        try {
            this.runtimeService.createEventSubscriptionQuery().executionId(null).list();
            EventSubscriptionQueryTest.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        this.cleanDb();
    }

    public void testQuerySorting() {
        this.createExampleEventSubscriptions();
        List eventSubscriptions = ((EventSubscriptionQuery)this.runtimeService.createEventSubscriptionQuery().orderByCreated().asc()).list();
        Assert.assertEquals((long)3L, (long)eventSubscriptions.size());
        Assert.assertTrue((((EventSubscription)eventSubscriptions.get(0)).getCreated().compareTo(((EventSubscription)eventSubscriptions.get(1)).getCreated()) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((((EventSubscription)eventSubscriptions.get(1)).getCreated().compareTo(((EventSubscription)eventSubscriptions.get(2)).getCreated()) < 0 ? 1 : 0) != 0);
        this.cleanDb();
    }

    protected void createExampleEventSubscriptions() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                GregorianCalendar calendar = new GregorianCalendar();
                MessageEventSubscriptionEntity messageEventSubscriptionEntity1 = new MessageEventSubscriptionEntity();
                messageEventSubscriptionEntity1.setEventName("messageName");
                messageEventSubscriptionEntity1.setActivityId("someActivity");
                calendar.set(2001, 1, 1);
                messageEventSubscriptionEntity1.setCreated(calendar.getTime());
                messageEventSubscriptionEntity1.insert();
                MessageEventSubscriptionEntity messageEventSubscriptionEntity2 = new MessageEventSubscriptionEntity();
                messageEventSubscriptionEntity2.setEventName("messageName");
                messageEventSubscriptionEntity2.setActivityId("someActivity");
                calendar.set(2000, 1, 1);
                messageEventSubscriptionEntity2.setCreated(calendar.getTime());
                messageEventSubscriptionEntity2.insert();
                SignalEventSubscriptionEntity signalEventSubscriptionEntity3 = new SignalEventSubscriptionEntity();
                signalEventSubscriptionEntity3.setEventName("messageName2");
                signalEventSubscriptionEntity3.setActivityId("someOtherActivity");
                calendar.set(2002, 1, 1);
                signalEventSubscriptionEntity3.setCreated(calendar.getTime());
                signalEventSubscriptionEntity3.insert();
                return null;
            }
        });
    }

    protected void cleanDb() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List subscriptions = new EventSubscriptionQueryImpl(commandContext).list();
                for (EventSubscription eventSubscriptionEntity : subscriptions) {
                    ((EventSubscriptionEntity)eventSubscriptionEntity).delete();
                }
                return null;
            }
        });
    }
}

