/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.HashMap;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;

public class AsyncStartEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testAsyncStartEvent() {
        this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((String)"The user task should not have been reached yet", (Object)task);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        this.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        Assert.assertNotNull((String)"The user task should have been reached", (Object)task);
    }

    @Deployment
    public void testAsyncStartEventListeners() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Assert.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
        this.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventHistory() {
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
            HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
            Assert.assertNotNull((Object)historicInstance);
            Assert.assertNotNull((Object)historicInstance.getStartTime());
            HistoricActivityInstance historicStartEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().singleResult();
            Assert.assertNull((Object)historicStartEvent);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void testAsyncStartEventVariableHistory() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("asyncStartEvent", variables).getId();
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)variableFoo);
        AsyncStartEventTest.assertEquals((String)"foo", (String)variableFoo.getName());
        AsyncStartEventTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel() > 1) {
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            AsyncStartEventTest.assertNotNull((Object)variable);
            AsyncStartEventTest.assertEquals((String)"foo", (String)variable.getVariableName());
            AsyncStartEventTest.assertEquals((Object)"bar", (Object)variable.getValue());
            AsyncStartEventTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel() > 2) {
                String startEventId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                AsyncStartEventTest.assertEquals((String)startEventId, (String)historicDetail.getActivityInstanceId());
            }
        }
    }

    @Deployment
    public void testMultipleAsyncStartEvents() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        AsyncStartEventTest.assertEquals((String)"taskAfterMessageStartEvent", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testMultipleAsyncStartEvents.bpmn20.xml"})
    public void testMultipleAsyncStartEventsVariableHistory() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)variableFoo);
        AsyncStartEventTest.assertEquals((String)"foo", (String)variableFoo.getName());
        AsyncStartEventTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel() > 1) {
            String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getId();
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            AsyncStartEventTest.assertNotNull((Object)variable);
            AsyncStartEventTest.assertEquals((String)"foo", (String)variable.getVariableName());
            AsyncStartEventTest.assertEquals((Object)"bar", (Object)variable.getValue());
            AsyncStartEventTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel() > 2) {
                String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("messageStartEvent").singleResult()).getId();
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                AsyncStartEventTest.assertEquals((String)theStartActivityInstanceId, (String)historicDetail.getActivityInstanceId());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testCallActivity-super.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testCallActivity-sub.bpmn20.xml"})
    public void testCallActivity() {
        this.runtimeService.startProcessInstanceByKey("super");
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        AsyncStartEventTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        AsyncStartEventTest.assertEquals((String)"theSubStart", (String)((ExecutionEntity)pi).getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    public void FAILING_testSubmitForm() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("asyncStartEvent").singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("foo", "bar");
        this.formService.submitStartForm(processDefinitionId, properties);
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)variableFoo);
        AsyncStartEventTest.assertEquals((String)"foo", (String)variableFoo.getName());
        AsyncStartEventTest.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        AsyncStartEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        AsyncStartEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel() > 1) {
            String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getId();
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            AsyncStartEventTest.assertNotNull((Object)variable);
            AsyncStartEventTest.assertEquals((String)"foo", (String)variable.getVariableName());
            AsyncStartEventTest.assertEquals((Object)"bar", (Object)variable.getValue());
            AsyncStartEventTest.assertEquals((String)processInstanceId, (String)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel() > 2) {
                String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                AsyncStartEventTest.assertEquals((String)theStartActivityInstanceId, (String)historicDetail.getActivityInstanceId());
            }
        }
    }
}

