/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.callactivity;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaOut;

public class CallActivityAdvancedTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSimpleSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcessWithExpressions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSimpleSubProcessWithExpressions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.setVariable(taskBeforeSubProcess.getId(), "simpleSubProcessExpression", (Object)"simpleSubProcess");
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessEndsSuperProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessEndsSuperProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessEndsSuperProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.complete(taskBeforeSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityAdvancedTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallParallelSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleParallelSubProcess.bpmn20.xml"})
    public void testCallParallelSubProcess() {
        this.runtimeService.startProcessInstanceByKey("callParallelSubProcess");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        List tasks = taskQuery.list();
        CallActivityAdvancedTest.assertEquals((int)2, (int)tasks.size());
        Task taskA = (Task)tasks.get(0);
        Task taskB = (Task)tasks.get(1);
        CallActivityAdvancedTest.assertEquals((String)"Task A", (String)taskA.getName());
        CallActivityAdvancedTest.assertEquals((String)"Task B", (String)taskB.getName());
        this.taskService.complete(taskA.getId());
        CallActivityAdvancedTest.assertEquals((int)1, (int)taskQuery.list().size());
        this.taskService.complete(taskB.getId());
        CallActivityAdvancedTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSequentialSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcessWithExpressions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess2.bpmn20.xml"})
    public void testCallSequentialSubProcessWithExpressions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSequentialSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.setVariable(taskBeforeSubProcess.getId(), "simpleSubProcessExpression", (Object)"simpleSubProcess");
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.setVariable(taskBeforeSubProcess.getId(), "simpleSubProcessExpression", (Object)"simpleSubProcess2");
        this.taskService.complete(taskBeforeSubProcess.getId());
        taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess 2", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTimerOnCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testTimerOnCallActivity() {
        this.runtimeService.startProcessInstanceByKey("timerOnCallActivity");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)timer);
        this.managementService.executeJob(timer.getId());
        Task escalatedTask = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Escalated Task", (String)escalatedTask.getName());
        this.taskService.complete(escalatedTask.getId());
        CallActivityAdvancedTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessWithDataInputOutput() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("superVariable", "Hello from the super process.");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "subVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "subVariable"));
        this.runtimeService.setVariable(taskBeforeSubProcess.getProcessInstanceId(), "subVariable", (Object)"Hello from sub process.");
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in super process", (String)taskAfterSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Hello from sub process.", (Object)this.taskService.getVariable(taskAfterSubProcess.getId(), "superVariable"));
        vars.clear();
        vars.put("x", new Long(5L));
        this.taskService.complete(taskAfterSubProcess.getId(), vars);
        Task taskInSecondSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSecondSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)10L, (Object)this.runtimeService.getVariable(taskInSecondSubProcess.getProcessInstanceId(), "y"));
        CallActivityAdvancedTest.assertEquals((Object)10L, (Object)this.taskService.getVariable(taskInSecondSubProcess.getId(), "y"));
        this.taskService.complete(taskInSecondSubProcess.getId());
        Task taskAfterSecondSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in super process", (String)taskAfterSecondSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)15L, (Object)this.runtimeService.getVariable(taskAfterSecondSubProcess.getProcessInstanceId(), "z"));
        CallActivityAdvancedTest.assertEquals((Object)15L, (Object)this.taskService.getVariable(taskAfterSecondSubProcess.getId(), "z"));
        this.taskService.complete(taskAfterSecondSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityAdvancedTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    public void testSubProcessWithDataInputOutputWithoutTarget() {
        String processId = "subProcessDataInputOutputWithoutTarget";
        BpmnModelInstance modelInstance = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().callActivity("callActivity").calledElement("simpleSubProcess")).userTask().endEvent().done();
        CallActivityBuilder callActivityBuilder = ((CallActivity)modelInstance.getModelElementById("callActivity")).builder();
        CamundaIn camundaIn = (CamundaIn)modelInstance.newInstance(CamundaIn.class);
        camundaIn.setCamundaSource("superVariable");
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaIn);
        this.deployAndExpectException(modelInstance);
        camundaIn.setCamundaTarget("subVariable");
        camundaIn = (CamundaIn)modelInstance.newInstance(CamundaIn.class);
        camundaIn.setCamundaSourceExpression("${x+5}");
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaIn);
        this.deployAndExpectException(modelInstance);
        camundaIn.setCamundaTarget("subVariable2");
        CamundaOut camundaOut = (CamundaOut)modelInstance.newInstance(CamundaOut.class);
        camundaOut.setCamundaSource("subVariable");
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaOut);
        this.deployAndExpectException(modelInstance);
        camundaOut.setCamundaTarget("superVariable");
        camundaOut = (CamundaOut)modelInstance.newInstance(CamundaOut.class);
        camundaOut.setCamundaSourceExpression("${y+1}");
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaOut);
        this.deployAndExpectException(modelInstance);
        camundaOut.setCamundaTarget("superVariable2");
        try {
            String deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
        catch (ProcessEngineException e) {
            CallActivityAdvancedTest.fail((String)"No exception expected");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/dataSubProcess.bpmn20.xml"})
    public void testSubProcessWithNullDataInput() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput").getId();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityAdvancedTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityAdvancedTest.assertNull((Object)variable);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)task);
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        CallActivityAdvancedTest.assertNull((Object)this.taskService.getVariable(task.getId(), "subVariable"));
        String subProcessInstanceId = task.getProcessInstanceId();
        CallActivityAdvancedTest.assertFalse((boolean)processInstanceId.equals(subProcessInstanceId));
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{subProcessInstanceId}).variableName("subVariable").singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)variable);
        CallActivityAdvancedTest.assertNull((Object)variable.getValue());
        CallActivityAdvancedTest.assertEquals((String)"subVariable", (String)variable.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutputAsExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/dataSubProcess.bpmn20.xml"})
    public void testSubProcessWithNullDataInputAsExpression() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("superVariable", null);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", params).getId();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityAdvancedTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)variable);
        CallActivityAdvancedTest.assertNull((Object)variable.getValue());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)task);
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        CallActivityAdvancedTest.assertNull((Object)this.taskService.getVariable(task.getId(), "subVariable"));
        String subProcessInstanceId = task.getProcessInstanceId();
        CallActivityAdvancedTest.assertFalse((boolean)processInstanceId.equals(subProcessInstanceId));
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{subProcessInstanceId}).variableName("subVariable").singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)variable);
        CallActivityAdvancedTest.assertNull((Object)variable.getValue());
        CallActivityAdvancedTest.assertEquals((String)"subVariable", (String)variable.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/dataSubProcess.bpmn20.xml"})
    public void testSubProcessWithNullDataOutput() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput").getId();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityAdvancedTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityAdvancedTest.assertNull((Object)variable);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)task);
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        this.taskService.complete(task.getId());
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityAdvancedTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)variable);
        CallActivityAdvancedTest.assertNull((Object)variable.getValue());
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("hisLocalVariable").singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)variable);
        CallActivityAdvancedTest.assertNull((Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutputAsExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/dataSubProcess.bpmn20.xml"})
    public void testSubProcessWithNullDataOutputAsExpression() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("superVariable", null);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", params).getId();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityAdvancedTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)variable);
        CallActivityAdvancedTest.assertNull((Object)variable.getValue());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)task);
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        this.taskService.complete(task.getId());
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityAdvancedTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)variable);
        CallActivityAdvancedTest.assertNull((Object)variable.getValue());
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("hisLocalVariable").singleResult();
        CallActivityAdvancedTest.assertNotNull((Object)variable);
        CallActivityAdvancedTest.assertNull((Object)variable.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployAndExpectException(BpmnModelInstance modelInstance) {
        String deploymentId = null;
        try {
            deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
            CallActivityAdvancedTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Missing attribute 'target'", e.getMessage());
        }
        finally {
            if (deploymentId != null) {
                this.repositoryService.deleteDeployment(deploymentId, true);
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTwoSubProcesses.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testTwoSubProcesses() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callTwoSubProcesses");
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityAdvancedTest.assertNotNull((Object)instanceList);
        CallActivityAdvancedTest.assertEquals((int)3, (int)instanceList.size());
        List taskList = this.taskService.createTaskQuery().list();
        CallActivityAdvancedTest.assertNotNull((Object)taskList);
        CallActivityAdvancedTest.assertEquals((int)2, (int)taskList.size());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "Test cascading");
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityAdvancedTest.assertNotNull((Object)instanceList);
        CallActivityAdvancedTest.assertEquals((int)0, (int)instanceList.size());
        taskList = this.taskService.createTaskQuery().list();
        CallActivityAdvancedTest.assertNotNull((Object)taskList);
        CallActivityAdvancedTest.assertEquals((int)0, (int)taskList.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessAllDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessAllDataInputOutput() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("superVariable", "Hello from the super process.");
        vars.put("testVariable", "Only a test.");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessAllDataInputOutput", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Only a test.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "testVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Only a test.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "testVariable"));
        this.taskService.complete(taskBeforeSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskInSubProcess.getId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Only a test.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "testVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Only a test.", (Object)this.taskService.getVariable(taskInSubProcess.getId(), "testVariable"));
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "superVariable", (Object)"Hello from sub process.");
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "testVariable", (Object)"Variable changed in sub process.");
        this.taskService.complete(taskInSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Variable changed in sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "testVariable"));
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityAdvancedTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessAllDataInputOutputWithAdditionalInputMapping.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessAllDataInputOutputWithAdditionalInputMapping() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("superVariable", "Hello from the super process.");
        vars.put("testVariable", "Only a test.");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessAllDataInputOutput", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Only a test.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "testVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Only a test.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "testVariable"));
        this.taskService.complete(taskBeforeSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "subVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskInSubProcess.getId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Only a test.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "testVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Only a test.", (Object)this.taskService.getVariable(taskInSubProcess.getId(), "testVariable"));
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "superVariable", (Object)"Hello from sub process.");
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "testVariable", (Object)"Variable changed in sub process.");
        this.taskService.complete(taskInSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Variable changed in sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "testVariable"));
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityAdvancedTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessAllDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessAllDataOutput() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessAllDataInputOutput");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.complete(taskBeforeSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "superVariable", (Object)"Hello from sub process.");
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "testVariable", (Object)"Variable changed in sub process.");
        this.taskService.complete(taskInSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((Object)"Hello from sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        CallActivityAdvancedTest.assertEquals((Object)"Variable changed in sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "testVariable"));
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityAdvancedTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessBusinessKeyInput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessBusinessKeyInput() {
        String businessKey = "myBusinessKey";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessBusinessKeyInput", businessKey);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityAdvancedTest.assertEquals((String)"myBusinessKey", (String)processInstance.getBusinessKey());
        this.taskService.complete(taskBeforeSubProcess.getId());
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
            CallActivityAdvancedTest.assertEquals((String)businessKey, (String)hpi.getBusinessKey());
            CallActivityAdvancedTest.assertEquals((int)2, (int)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).list().size());
        }
        taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(taskInSubProcess.getProcessInstanceId()).singleResult();
        CallActivityAdvancedTest.assertEquals((String)"myBusinessKey", (String)subProcessInstance.getBusinessKey());
        this.taskService.complete(taskInSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityAdvancedTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).finished().singleResult();
            CallActivityAdvancedTest.assertEquals((String)businessKey, (String)hpi.getBusinessKey());
            CallActivityAdvancedTest.assertEquals((int)2, (int)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).finished().list().size());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcessWithHashExpressions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSimpleSubProcessWithHashExpressions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.setVariable(taskBeforeSubProcess.getId(), "simpleSubProcessExpression", (Object)"simpleSubProcess");
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testInterruptingEventSubProcessEventSubscriptions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/interruptingEventSubProcessEventSubscriptions.bpmn20.xml"})
    public void testInterruptingMessageEventSubProcessEventSubscriptionsInsideCallActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callInterruptingEventSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskInsideCallActivity = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"taskBeforeInterruptingEventSubprocess", (String)taskInsideCallActivity.getTaskDefinitionKey());
        CallActivityAdvancedTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().processInstanceId(processInstance.getId()).count());
        String calledProcessInstanceId = taskInsideCallActivity.getProcessInstanceId();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery().processInstanceId(calledProcessInstanceId);
        List subscriptions = eventSubscriptionQuery.list();
        CallActivityAdvancedTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.correlateMessage("newMessage");
        Task taskAfterMessageStartEvent = (Task)taskQuery.processInstanceId(calledProcessInstanceId).singleResult();
        CallActivityAdvancedTest.assertEquals((String)"taskAfterMessageStartEvent", (String)taskAfterMessageStartEvent.getTaskDefinitionKey());
        CallActivityAdvancedTest.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        this.taskService.complete(taskAfterMessageStartEvent.getId());
        this.assertProcessEnded(calledProcessInstanceId);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testInterruptingEventSubProcessEventSubscriptions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/interruptingEventSubProcessEventSubscriptions.bpmn20.xml"})
    public void testInterruptingSignalEventSubProcessEventSubscriptionsInsideCallActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callInterruptingEventSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskInsideCallActivity = (Task)taskQuery.singleResult();
        CallActivityAdvancedTest.assertEquals((String)"taskBeforeInterruptingEventSubprocess", (String)taskInsideCallActivity.getTaskDefinitionKey());
        CallActivityAdvancedTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().processInstanceId(processInstance.getId()).count());
        String calledProcessInstanceId = taskInsideCallActivity.getProcessInstanceId();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery().processInstanceId(calledProcessInstanceId);
        List subscriptions = eventSubscriptionQuery.list();
        CallActivityAdvancedTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.signalEventReceived("newSignal");
        Task taskAfterSignalStartEvent = (Task)taskQuery.processInstanceId(calledProcessInstanceId).singleResult();
        CallActivityAdvancedTest.assertEquals((String)"taskAfterSignalStartEvent", (String)taskAfterSignalStartEvent.getTaskDefinitionKey());
        CallActivityAdvancedTest.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        this.taskService.complete(taskAfterSignalStartEvent.getId());
        this.assertProcessEnded(calledProcessInstanceId);
        this.assertProcessEnded(processInstance.getId());
    }
}

