/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.link;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class LinkEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testValidEventLink() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("linkEventValid");
        List activeActivities = this.runtimeService.getActiveActivityIds(pi.getId());
        LinkEventTest.assertEquals(Arrays.asList("waitAfterLink1"), (Object)activeActivities);
        this.runtimeService.signal(pi.getId());
        activeActivities = this.runtimeService.getActiveActivityIds(pi.getId());
        LinkEventTest.assertEquals(Arrays.asList("waitAfterLink2"), (Object)activeActivities);
        this.runtimeService.signal(pi.getId());
        this.assertProcessEnded(pi.getId());
        if (this.processEngineConfiguration.getHistoryLevel() >= 1) {
            List activities = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi.getId()).orderByActivityId().asc()).list();
            LinkEventTest.assertEquals((int)4, (int)activities.size());
            LinkEventTest.assertEquals((String)"EndEvent_1", (String)((HistoricActivityInstance)activities.get(0)).getActivityId());
            LinkEventTest.assertEquals((String)"StartEvent_1", (String)((HistoricActivityInstance)activities.get(1)).getActivityId());
            LinkEventTest.assertEquals((String)"waitAfterLink1", (String)((HistoricActivityInstance)activities.get(2)).getActivityId());
            LinkEventTest.assertEquals((String)"waitAfterLink2", (String)((HistoricActivityInstance)activities.get(3)).getActivityId());
        }
    }

    @Deployment
    public void testEventLinkMultipleSources() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("linkEventValid");
        List activeActivities = this.runtimeService.getActiveActivityIds(pi.getId());
        LinkEventTest.assertEquals(Arrays.asList("WaitAfterLink", "WaitAfterLink"), (Object)activeActivities);
        this.runtimeService.deleteProcessInstance(pi.getId(), "test done");
        if (this.processEngineConfiguration.getHistoryLevel() >= 1) {
            List activities = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(pi.getId()).orderByActivityId().asc()).list();
            LinkEventTest.assertEquals((int)5, (int)activities.size());
            LinkEventTest.assertEquals((String)"ManualTask_1", (String)((HistoricActivityInstance)activities.get(0)).getActivityId());
            LinkEventTest.assertEquals((String)"ParallelGateway_1", (String)((HistoricActivityInstance)activities.get(1)).getActivityId());
            LinkEventTest.assertEquals((String)"StartEvent_1", (String)((HistoricActivityInstance)activities.get(2)).getActivityId());
            LinkEventTest.assertEquals((String)"WaitAfterLink", (String)((HistoricActivityInstance)activities.get(3)).getActivityId());
            LinkEventTest.assertEquals((String)"WaitAfterLink", (String)((HistoricActivityInstance)activities.get(4)).getActivityId());
        }
    }

    public void testInvalidEventLinkMultipleTargets() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/link/LinkEventTest.testInvalidEventLinkMultipleTargets.bpmn20.xml").deploy();
            LinkEventTest.fail((String)"process should not deploy because it contains multiple event link targets which is invalid in the BPMN 2.0 spec");
        }
        catch (Exception ex) {
            LinkEventTest.assertTrue((boolean)ex.getMessage().contains("Multiple Intermediate Catch Events with the same link event name ('LinkA') are not allowed"));
        }
    }

    public void testCatchLinkEventAfterEventBasedGatewayNotAllowed() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/link/LinkEventTest.testCatchLinkEventAfterEventBasedGatewayNotAllowed.bpmn20.xml").deploy();
            LinkEventTest.fail((String)"process should not deploy because it contains multiple event link targets which is invalid in the BPMN 2.0 spec");
        }
        catch (Exception ex) {
            LinkEventTest.assertTrue((boolean)ex.getMessage().contains("IntermediateCatchLinkEvent is not allowed after an EventBasedGateway."));
        }
    }
}

