/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.TestExecutionListener;

public class MessageEventSubprocessTest
extends PluggableProcessEngineTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            TestExecutionListener.reset();
        }
    }

    @Deployment
    public void testInterruptingUnderProcessDefinition() {
        this.testInterruptingUnderProcessDefinition(1);
    }

    @Deployment
    public void testTwoInterruptingUnderProcessDefinition() {
        this.testInterruptingUnderProcessDefinition(2);
    }

    private void testInterruptingUnderProcessDefinition(int expectedNumberOfEventSubscriptions) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstance.getId()).messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)expectedNumberOfEventSubscriptions, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcessTask", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess", (String)taskInEventSubProcess.getTaskDefinitionKey());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
        }
    }

    @Deployment
    public void testNonInterruptingEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInMainFlow = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInMainFlow").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)taskInMainFlow);
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInEventSubProcess").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)taskInEventSubProcess);
        this.taskService.complete(taskInMainFlow.getId());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
        }
    }

    @Deployment
    public void testNestedEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess", (String)taskInEventSubProcess.getTaskDefinitionKey());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").finished().count());
        }
    }

    @Deployment
    public void testNestedNonInterruptingEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInMainFlow = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInMainFlow").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)taskInMainFlow);
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInEventSubProcess").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)taskInEventSubProcess);
        this.taskService.complete(taskInMainFlow.getId());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").finished().count());
        }
    }

    @Deployment
    public void testEventSubprocessBoundaryListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess", (String)taskInEventSubProcess.getTaskDefinitionKey());
        this.runtimeService.correlateMessage("message2");
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel() > 0) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").canceled().count());
        }
    }

    @Deployment
    public void testNonInterruptingUnderProcessDefinition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstance.getId()).messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNonInterruptingUnderProcessDefinitionScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNonInterruptingInEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testMultipleNonInterruptingInEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution subProcess = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)subProcess);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Task subProcessTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("subProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)subProcessTask);
        for (int i = 1; i < 3; ++i) {
            this.runtimeService.messageEventReceived("newMessage", subProcess.getId());
            List eventSubProcessTasks = this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").list();
            MessageEventSubprocessTest.assertEquals((int)i, (int)eventSubProcessTasks.size());
            String taskExecutionId = ((Task)eventSubProcessTasks.get(i - 1)).getExecutionId();
            ExecutionEntity taskExecution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(taskExecutionId).singleResult();
            MessageEventSubprocessTest.assertEquals((String)subProcess.getId(), (String)taskExecution.getParentId());
        }
        this.taskService.complete(subProcessTask.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    private EventSubscriptionQueryImpl createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.processEngineConfiguration.getCommandExecutorTxRequired());
    }

    @Deployment
    public void testNonInterruptingInMultiParallelEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        MessageEventSubprocessTest.assertEquals((long)6L, (long)this.runtimeService.createExecutionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            MessageEventSubprocessTest.assertEquals((String)"subUserTask", (String)task.getTaskDefinitionKey());
            this.taskService.complete(task.getId());
        }
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        for (EventSubscription es : this.runtimeService.createEventSubscriptionQuery().list()) {
            this.runtimeService.messageEventReceived("message", es.getExecutionId());
        }
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        tasks = this.taskService.createTaskQuery().taskName("Message User Task").list();
        MessageEventSubprocessTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.runtimeService.messageEventReceived("message", ((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getExecutionId());
        MessageEventSubprocessTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskName("Message User Task").list().size());
        tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testNonInterruptingInMultiSequentialEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("message", ((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getExecutionId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Message User Task").singleResult()).getId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
    }
}

