/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.gateway;

import java.util.Date;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class EventBasedGatewayTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.testCatchAlertAndTimer.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.throwAlertSignal.bpmn20.xml"})
    public void testCatchSignalCancelsTimer() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        EventBasedGatewayTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventBasedGatewayTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskName("afterSignal").singleResult();
        EventBasedGatewayTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.testCatchAlertAndTimer.bpmn20.xml"})
    public void testCatchTimerCancelsSignal() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 10000L));
        try {
            this.waitForJobExecutorToProcessAllJobs(10000L);
            EventBasedGatewayTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
            EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
            EventBasedGatewayTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
            Task task = (Task)this.taskService.createTaskQuery().taskName("afterTimer").singleResult();
            EventBasedGatewayTest.assertNotNull((Object)task);
            this.taskService.complete(task.getId());
        }
        finally {
            ClockUtil.setCurrentTime((Date)new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment
    public void testCatchSignalAndMessageAndTimer() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        EventBasedGatewayTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        EventSubscriptionQuery messageEventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery().eventType("message");
        EventBasedGatewayTest.assertEquals((long)1L, (long)messageEventSubscriptionQuery.count());
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").count());
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventBasedGatewayTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoice").signalEventSubscriptionName("alert").singleResult();
        EventBasedGatewayTest.assertNotNull((Object)execution);
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 10000L));
        try {
            EventSubscription messageEventSubscription = (EventSubscription)messageEventSubscriptionQuery.singleResult();
            this.runtimeService.messageEventReceived(messageEventSubscription.getEventName(), messageEventSubscription.getExecutionId());
            EventBasedGatewayTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
            EventBasedGatewayTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
            EventBasedGatewayTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
            Task task = (Task)this.taskService.createTaskQuery().taskName("afterMessage").singleResult();
            EventBasedGatewayTest.assertNotNull((Object)task);
            this.taskService.complete(task.getId());
        }
        finally {
            ClockUtil.setCurrentTime((Date)new Date());
        }
    }

    public void testConnectedToActitiy() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.testConnectedToActivity.bpmn20.xml").deploy();
                EventBasedGatewayTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("Event based gateway can only be connected to elements of type intermediateCatchEvent")) break block2;
                EventBasedGatewayTest.fail((String)"different exception expected");
            }
        }
    }

    public void testInvalidSequenceFlow() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/gateway/EventBasedGatewayTest.testEventInvalidSequenceFlow.bpmn20.xml").deploy();
                EventBasedGatewayTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("Invalid incoming sequenceflow for intermediateCatchEvent")) break block2;
                EventBasedGatewayTest.fail((String)"different exception expected");
            }
        }
    }
}

