/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.scripttask;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;

public class SpinScriptTaskSupportTest
extends PluggableProcessEngineTestCase {
    public void testSpinAvailableInGroovy() {
        this.deployProcess("groovy", "execution.setVariable('name',  S('<test />').name() )\n");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        String var = (String)this.runtimeService.getVariable(pi.getId(), "name");
        SpinScriptTaskSupportTest.assertEquals((String)"test", (String)var);
    }

    public void testSpinAvailableInJavascript() {
        this.deployProcess("javascript", "execution.setVariable('name',  S('<test />').name() )\n");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        String var = (String)this.runtimeService.getVariable(pi.getId(), "name");
        SpinScriptTaskSupportTest.assertEquals((String)"test", (String)var);
    }

    public void testSpinAvailableInPython() {
        this.deployProcess("python", "execution.setVariable('name',  S('<test />').name() )\n");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        String var = (String)this.runtimeService.getVariable(pi.getId(), "name");
        SpinScriptTaskSupportTest.assertEquals((String)"test", (String)var);
    }

    public void testSpinAvailableInRuby() {
        this.deployProcess("ruby", "$execution.setVariable('name',  S('<test />').name() )\n");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        String var = (String)this.runtimeService.getVariable(pi.getId(), "name");
        SpinScriptTaskSupportTest.assertEquals((String)"test", (String)var);
    }

    protected void deployProcess(String scriptFormat, String scriptText) {
        BpmnModelInstance process = this.createProcess(scriptFormat, scriptText);
        Deployment deployment = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy();
        this.deploymentId = deployment.getId();
    }

    protected BpmnModelInstance createProcess(String scriptFormat, String scriptText) {
        return ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().scriptTask().scriptFormat(scriptFormat)).scriptText(scriptText)).userTask().endEvent().done();
    }
}

