/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.servicetask;

import java.util.HashMap;
import org.camunda.bpm.connect.rest.httpclient.RestHttpConnector;
import org.camunda.bpm.connect.soap.httpclient.SoapHttpConnector;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.servicetask.util.TestConnector;

public class ConnectorServiceTaskTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.processEngineConfiguration.getConnectors().addConnector("testConnector", TestConnector.class);
        TestConnector.responseParameters.clear();
        TestConnector.requestParameters = null;
    }

    @Deployment
    public void testConnectorInvoked() {
        String outputParamValue = "someOutputValue";
        String inputVariableValue = "someInputVariableValue";
        TestConnector.responseParameters.put("someOutputParameter", outputParamValue);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("someInputVariable", inputVariableValue);
        this.runtimeService.startProcessInstanceByKey("testProcess", vars);
        ConnectorServiceTaskTest.assertNotNull((Object)TestConnector.requestParameters.get("reqParam1"));
        ConnectorServiceTaskTest.assertEquals((Object)inputVariableValue, (Object)TestConnector.requestParameters.get("reqParam1"));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("out1").singleResult();
        ConnectorServiceTaskTest.assertNotNull((Object)variable);
        ConnectorServiceTaskTest.assertEquals((Object)outputParamValue, (Object)variable.getValue());
    }

    public void testDefaultConnectorsRegistered() {
        ConnectorServiceTaskTest.assertEquals(SoapHttpConnector.class, (Object)this.processEngineConfiguration.getConnectors().getConnector("soap-http-connector"));
        ConnectorServiceTaskTest.assertEquals(RestHttpConnector.class, (Object)this.processEngineConfiguration.getConnectors().getConnector("rest-http-connector"));
    }

    @Deployment
    public void testConnectorWithScriptInputOutputMapping() {
        int x = 3;
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("x", x);
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Object in = TestConnector.requestParameters.get("in");
        ConnectorServiceTaskTest.assertNotNull((Object)in);
        ConnectorServiceTaskTest.assertEquals((Object)(2 * x), (Object)in);
        VariableInstance out = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("out").singleResult();
        ConnectorServiceTaskTest.assertNotNull((Object)out);
        ConnectorServiceTaskTest.assertEquals((Object)(3 * x), (Object)out.getValue());
    }
}

