/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import java.util.List;
import org.camunda.bpm.engine.impl.cmmn.behavior.CallableElement;
import org.camunda.bpm.engine.impl.cmmn.behavior.CallableElementParameter;
import org.camunda.bpm.engine.impl.cmmn.behavior.CaseTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CaseTaskItemHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.SentryHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.impl.core.mapping.value.ConstantValueProvider;
import org.camunda.bpm.engine.impl.core.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.el.ElValueProvider;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.impl.instance.Body;
import org.camunda.bpm.model.cmmn.impl.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.instance.CaseTask;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.ExtensionElements;
import org.camunda.bpm.model.cmmn.instance.IfPart;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaOut;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CaseTaskPlanItemHandlerTest
extends CmmnElementHandlerTest {
    protected CaseTask caseTask;
    protected PlanItem planItem;
    protected CaseTaskItemHandler handler = new CaseTaskItemHandler();

    @Before
    public void setUp() {
        this.caseTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aCaseTask", CaseTask.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aCaseTask", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.caseTask);
    }

    @Test
    public void testCaseTaskActivityName() {
        String name = "A CaseTask";
        this.caseTask.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testPlanItemActivityName() {
        String name = "A CaseTask";
        this.caseTask.setName(name);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNotEquals((Object)name, (Object)activity.getName());
        Assert.assertEquals((Object)planItemName, (Object)activity.getName());
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof CaseTaskActivityBehavior));
    }

    @Test
    public void testIsBlockingEqualsTrueProperty() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertTrue((boolean)isBlocking);
    }

    @Test
    public void testIsBlockingEqualsFalseProperty() {
        this.caseTask.setIsBlocking(false);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertFalse((boolean)isBlocking);
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testCallableElement() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        Assert.assertNotNull((Object)behavior.getCallableElement());
    }

    @Test
    public void testCaseRefConstant() {
        String caseRef = "aCaseToCall";
        this.caseTask.setCase(caseRef);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider caseRefValueProvider = callableElement.getDefinitionKeyValueProvider();
        Assert.assertNotNull((Object)caseRefValueProvider);
        Assert.assertTrue((boolean)(caseRefValueProvider instanceof ConstantValueProvider));
        ConstantValueProvider valueProvider = (ConstantValueProvider)caseRefValueProvider;
        Assert.assertEquals((Object)caseRef, (Object)valueProvider.getValue(null));
    }

    @Test
    public void testCaseRefExpression() {
        String caseRef = "${aCaseToCall}";
        this.caseTask.setCase(caseRef);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider caseRefValueProvider = callableElement.getDefinitionKeyValueProvider();
        Assert.assertNotNull((Object)caseRefValueProvider);
        Assert.assertTrue((boolean)(caseRefValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)caseRefValueProvider;
        Assert.assertEquals((Object)caseRef, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testBinding() {
        CallableElement.CallableElementBinding caseBinding = CallableElement.CallableElementBinding.LATEST;
        this.caseTask.setCamundaCaseBinding(caseBinding.getValue());
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElement.CallableElementBinding binding = callableElement.getBinding();
        Assert.assertNotNull((Object)binding);
        Assert.assertEquals((Object)caseBinding, (Object)binding);
    }

    @Test
    public void testVersionConstant() {
        String caseVersion = "2";
        this.caseTask.setCamundaCaseVersion(caseVersion);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider caseVersionValueProvider = callableElement.getVersionValueProvider();
        Assert.assertNotNull((Object)caseVersionValueProvider);
        Assert.assertTrue((boolean)(caseVersionValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)caseVersion, (Object)caseVersionValueProvider.getValue(null));
    }

    @Test
    public void testVersionExpression() {
        String caseVersion = "${aVersion}";
        this.caseTask.setCamundaCaseVersion(caseVersion);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider caseVersionValueProvider = callableElement.getVersionValueProvider();
        Assert.assertNotNull((Object)caseVersionValueProvider);
        Assert.assertTrue((boolean)(caseVersionValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)caseVersionValueProvider;
        Assert.assertEquals((Object)caseVersion, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testBusinessKeyConstant() {
        String businessKey = "myBusinessKey";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaIn businessKeyElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        businessKeyElement.setCamundaBusinessKey(businessKey);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider businessKeyValueProvider = callableElement.getBusinessKeyValueProvider();
        Assert.assertNotNull((Object)businessKeyValueProvider);
        Assert.assertTrue((boolean)(businessKeyValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)businessKey, (Object)businessKeyValueProvider.getValue(null));
    }

    @Test
    public void testBusinessKeyExpression() {
        String businessKey = "${myBusinessKey}";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaIn businessKeyElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        businessKeyElement.setCamundaBusinessKey(businessKey);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ParameterValueProvider businessKeyValueProvider = callableElement.getBusinessKeyValueProvider();
        Assert.assertNotNull((Object)businessKeyValueProvider);
        Assert.assertTrue((boolean)(businessKeyValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)businessKeyValueProvider;
        Assert.assertEquals((Object)businessKey, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testInputs() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaIn variablesElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        variablesElement.setCamundaVariables("all");
        CamundaIn sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceElement.setCamundaSource("a");
        CamundaIn sourceExpressionElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceExpressionElement.setCamundaSourceExpression("${b}");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        List inputs = callableElement.getInputs();
        Assert.assertNotNull((Object)inputs);
        Assert.assertFalse((boolean)inputs.isEmpty());
        Assert.assertEquals((long)3L, (long)inputs.size());
    }

    @Test
    public void testInputVariables() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaIn variablesElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        variablesElement.setCamundaVariables("all");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getInputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isAllVariables());
    }

    @Test
    public void testInputSource() {
        String source = "a";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaIn sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceElement.setCamundaSource(source);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getInputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        ParameterValueProvider sourceValueProvider = parameter.getSourceValueProvider();
        Assert.assertNotNull((Object)sourceValueProvider);
        Assert.assertTrue((boolean)(sourceValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)source, (Object)sourceValueProvider.getValue(null));
    }

    @Test
    public void testInputSourceExpression() {
        String source = "${a}";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaIn sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceElement.setCamundaSourceExpression(source);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getInputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        ParameterValueProvider sourceExpressionValueProvider = parameter.getSourceValueProvider();
        Assert.assertNotNull((Object)sourceExpressionValueProvider);
        Assert.assertTrue((boolean)(sourceExpressionValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)sourceExpressionValueProvider;
        Assert.assertEquals((Object)source, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testInputTarget() {
        String target = "b";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaIn sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaIn.class);
        sourceElement.setCamundaTarget(target);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getInputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        Assert.assertEquals((Object)target, (Object)parameter.getTarget());
    }

    @Test
    public void testOutputs() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaOut variablesElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        variablesElement.setCamundaVariables("all");
        CamundaOut sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceElement.setCamundaSource("a");
        CamundaOut sourceExpressionElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceExpressionElement.setCamundaSourceExpression("${b}");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        List outputs = callableElement.getOutputs();
        Assert.assertNotNull((Object)outputs);
        Assert.assertFalse((boolean)outputs.isEmpty());
        Assert.assertEquals((long)3L, (long)outputs.size());
    }

    @Test
    public void testOutputVariables() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaOut variablesElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        variablesElement.setCamundaVariables("all");
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getOutputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isAllVariables());
    }

    @Test
    public void testOutputSource() {
        String source = "a";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaOut sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceElement.setCamundaSource(source);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getOutputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        ParameterValueProvider sourceValueProvider = parameter.getSourceValueProvider();
        Assert.assertNotNull((Object)sourceValueProvider);
        Assert.assertTrue((boolean)(sourceValueProvider instanceof ConstantValueProvider));
        Assert.assertEquals((Object)source, (Object)sourceValueProvider.getValue(null));
    }

    @Test
    public void testOutputSourceExpression() {
        String source = "${a}";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaOut sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceElement.setCamundaSourceExpression(source);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getOutputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        ParameterValueProvider sourceExpressionValueProvider = parameter.getSourceValueProvider();
        Assert.assertNotNull((Object)sourceExpressionValueProvider);
        Assert.assertTrue((boolean)(sourceExpressionValueProvider instanceof ElValueProvider));
        ElValueProvider valueProvider = (ElValueProvider)sourceExpressionValueProvider;
        Assert.assertEquals((Object)source, (Object)valueProvider.getExpression().getExpressionText());
    }

    @Test
    public void testOutputTarget() {
        String target = "b";
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.caseTask);
        CamundaOut sourceElement = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaOut.class);
        sourceElement.setCamundaTarget(target);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CaseTaskActivityBehavior behavior = (CaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        CallableElementParameter parameter = (CallableElementParameter)callableElement.getOutputs().get(0);
        Assert.assertNotNull((Object)parameter);
        Assert.assertFalse((boolean)parameter.isAllVariables());
        Assert.assertEquals((Object)target, (Object)parameter.getTarget());
    }

    @Test
    public void testExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        this.planItem.getExitCriterias().add(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
    }

    @Test
    public void testMultipleExitCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        Body body1 = this.createElement((CmmnModelElementInstance)conditionExpression1, null, Body.class);
        body1.setTextContent("${test}");
        this.planItem.getExitCriterias().add(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        Body body2 = this.createElement((CmmnModelElementInstance)conditionExpression2, null, Body.class);
        body2.setTextContent("${test}");
        this.planItem.getExitCriterias().add(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getExitCriteria().size());
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        this.planItem.getEntryCriterias().add(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testMultipleEntryCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        Body body1 = this.createElement((CmmnModelElementInstance)conditionExpression1, null, Body.class);
        body1.setTextContent("${test}");
        this.planItem.getEntryCriterias().add(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        Body body2 = this.createElement((CmmnModelElementInstance)conditionExpression2, null, Body.class);
        body2.setTextContent("${test}");
        this.planItem.getEntryCriterias().add(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getEntryCriteria().size());
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteriaAndExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        this.planItem.getEntryCriterias().add(sentry);
        this.planItem.getExitCriterias().add(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }
}

