/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.variables;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.delegate.SerializedVariableValue;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.examples.variables.SimpleSerializableBean;
import org.camunda.bpm.engine.test.examples.variables.VariableSpec;
import org.junit.Assert;

public class SerializedVariablesTest
extends PluggableProcessEngineTestCase {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String ONE_SUB_PROCESS = "org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml";
    protected static byte[] byteArray = new byte[]{42, 47};
    protected static SimpleSerializableBean serializable = new SimpleSerializableBean(42);
    protected static long longValue = 12345678L;
    protected static final VariableSpec BOOLEAN_VARIABLE_SPEC = new VariableSpec().name("booleanVariable").value(true).serializedValue(true).variableTypeName(ProcessEngineVariableType.BOOLEAN.getName()).valueTypeName(Boolean.class.getSimpleName()).storesCustomObjects(false).configuration(new HashMap<String, Object>());
    protected static final VariableSpec BYTE_ARRAY_VARIABLE_SPEC = new VariableSpec().name("byteArrayVariable").value(byteArray).serializedValue(byteArray).variableTypeName(ProcessEngineVariableType.BYTES.getName()).valueTypeName(byte[].class.getSimpleName()).storesCustomObjects(false).configuration(new HashMap<String, Object>());
    protected static final VariableSpec SERIALIZABLE_VARIABLE_SPEC = new VariableSpec().name("serializableVariable").value(serializable).serializedValue(SerializedVariablesTest.toExpectedBytes(serializable)).variableTypeName(ProcessEngineVariableType.SERIALIZABLE.getName()).valueTypeName(Serializable.class.getSimpleName()).storesCustomObjects(true).configuration(new HashMap<String, Object>());
    protected static final VariableSpec DATE_VARIABLE_SPEC = new VariableSpec().name("dateVariable").value(new Date(longValue)).serializedValue(longValue).variableTypeName(ProcessEngineVariableType.DATE.getName()).valueTypeName(Date.class.getSimpleName()).storesCustomObjects(false).configuration(new HashMap<String, Object>());
    protected static final VariableSpec INT_VARIABLE_SPEC = new VariableSpec().name("intVariable").value(42).serializedValue(42).variableTypeName(ProcessEngineVariableType.INTEGER.getName()).valueTypeName(Integer.class.getSimpleName()).storesCustomObjects(false).configuration(new HashMap<String, Object>());
    protected static final VariableSpec DOUBLE_VARIABLE_SPEC = new VariableSpec().name("doubleVariable").value(4.2).serializedValue(4.2).variableTypeName(ProcessEngineVariableType.DOUBLE.getName()).valueTypeName(Double.class.getSimpleName()).storesCustomObjects(false).configuration(new HashMap<String, Object>());
    protected static final VariableSpec SHORT_VARIABLE_SPEC = new VariableSpec().name("shortVariable").value((short)4).serializedValue((short)4).variableTypeName(ProcessEngineVariableType.SHORT.getName()).valueTypeName(Short.class.getSimpleName()).storesCustomObjects(false).configuration(new HashMap<String, Object>());
    protected static final VariableSpec LONG_VARIABLE_SPEC = new VariableSpec().name("longVariable").value(longValue).serializedValue(longValue).variableTypeName(ProcessEngineVariableType.LONG.getName()).valueTypeName(Long.class.getSimpleName()).storesCustomObjects(false).configuration(new HashMap<String, Object>());
    protected static final VariableSpec NULL_VARIABLE_SPEC = new VariableSpec().name("nullVariable").value(null).serializedValue(null).variableTypeName(ProcessEngineVariableType.NULL.getName()).valueTypeName("Null").storesCustomObjects(false).configuration(new HashMap<String, Object>());
    protected static final VariableSpec STRING_VARIABLE_SPEC = new VariableSpec().name("stringVariable").value("a String value").serializedValue("a String value").variableTypeName(ProcessEngineVariableType.STRING.getName()).valueTypeName(String.class.getSimpleName()).storesCustomObjects(false).configuration(new HashMap<String, Object>());

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedBooleanValue() {
        this.assertGetSerializedValue("oneTaskProcess", BOOLEAN_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedBooleanValue() {
        this.assertSetSerializedValue("oneTaskProcess", BOOLEAN_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedByteArrayValue() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", this.newMap(BYTE_ARRAY_VARIABLE_SPEC.getName(), BYTE_ARRAY_VARIABLE_SPEC.getValue()));
        VariableInstance variableInstance = this.getVariableInstance(BYTE_ARRAY_VARIABLE_SPEC.getName());
        SerializedVariableValue serializedValue = variableInstance.getSerializedValue();
        Assert.assertArrayEquals((byte[])((byte[])BYTE_ARRAY_VARIABLE_SPEC.getSerializedValue()), (byte[])((byte[])serializedValue.getValue()));
        SerializedVariablesTest.assertEquals(BYTE_ARRAY_VARIABLE_SPEC.getConfiguration(), (Object)serializedValue.getConfig());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedByteArrayValue() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariableFromSerialized(instance.getId(), BYTE_ARRAY_VARIABLE_SPEC.getName(), BYTE_ARRAY_VARIABLE_SPEC.getSerializedValue(), BYTE_ARRAY_VARIABLE_SPEC.getVariableTypeName(), BYTE_ARRAY_VARIABLE_SPEC.getConfiguration());
        VariableInstance variableInstance = this.getVariableInstance(BYTE_ARRAY_VARIABLE_SPEC.getName());
        SerializedVariablesTest.assertEquals((String)BYTE_ARRAY_VARIABLE_SPEC.getName(), (String)variableInstance.getName());
        Assert.assertArrayEquals((byte[])((byte[])BYTE_ARRAY_VARIABLE_SPEC.getSerializedValue()), (byte[])((byte[])variableInstance.getValue()));
        SerializedVariablesTest.assertEquals((String)BYTE_ARRAY_VARIABLE_SPEC.getVariableTypeName(), (String)variableInstance.getTypeName());
        SerializedVariableValue serializedValue = variableInstance.getSerializedValue();
        Assert.assertArrayEquals((byte[])((byte[])BYTE_ARRAY_VARIABLE_SPEC.getSerializedValue()), (byte[])((byte[])serializedValue.getValue()));
        SerializedVariablesTest.assertEquals(BYTE_ARRAY_VARIABLE_SPEC.getConfiguration(), (Object)serializedValue.getConfig());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedSerializableValue() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", this.newMap(SERIALIZABLE_VARIABLE_SPEC.getName(), SERIALIZABLE_VARIABLE_SPEC.getValue()));
        VariableInstance variableInstance = this.getVariableInstance(SERIALIZABLE_VARIABLE_SPEC.getName());
        SerializedVariableValue serializedValue = variableInstance.getSerializedValue();
        Assert.assertArrayEquals((byte[])((byte[])SERIALIZABLE_VARIABLE_SPEC.getSerializedValue()), (byte[])((byte[])serializedValue.getValue()));
        SerializedVariablesTest.assertEquals(SERIALIZABLE_VARIABLE_SPEC.getConfiguration(), (Object)serializedValue.getConfig());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedSerializableValue() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariableFromSerialized(instance.getId(), SERIALIZABLE_VARIABLE_SPEC.getName(), SERIALIZABLE_VARIABLE_SPEC.getSerializedValue(), SERIALIZABLE_VARIABLE_SPEC.getVariableTypeName(), SERIALIZABLE_VARIABLE_SPEC.getConfiguration());
        VariableInstance variableInstance = this.getVariableInstance(SERIALIZABLE_VARIABLE_SPEC.getName());
        SerializedVariablesTest.assertEquals((String)SERIALIZABLE_VARIABLE_SPEC.getName(), (String)variableInstance.getName());
        SerializedVariablesTest.assertEquals((Object)SERIALIZABLE_VARIABLE_SPEC.getValue(), (Object)variableInstance.getValue());
        SerializedVariablesTest.assertEquals((String)SERIALIZABLE_VARIABLE_SPEC.getVariableTypeName(), (String)variableInstance.getTypeName());
        SerializedVariableValue serializedValue = variableInstance.getSerializedValue();
        Assert.assertArrayEquals((byte[])((byte[])SERIALIZABLE_VARIABLE_SPEC.getSerializedValue()), (byte[])((byte[])serializedValue.getValue()));
        SerializedVariablesTest.assertEquals(SERIALIZABLE_VARIABLE_SPEC.getConfiguration(), (Object)serializedValue.getConfig());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedDateValue() {
        this.assertGetSerializedValue("oneTaskProcess", DATE_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedDateValue() {
        this.assertSetSerializedValue("oneTaskProcess", DATE_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedIntValue() {
        this.assertGetSerializedValue("oneTaskProcess", INT_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedIntValue() {
        this.assertSetSerializedValue("oneTaskProcess", INT_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedDoubleValue() {
        this.assertGetSerializedValue("oneTaskProcess", DOUBLE_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedDoubleValue() {
        this.assertSetSerializedValue("oneTaskProcess", DOUBLE_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedShortValue() {
        this.assertGetSerializedValue("oneTaskProcess", SHORT_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedShortValue() {
        this.assertSetSerializedValue("oneTaskProcess", SHORT_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedLongValue() {
        this.assertGetSerializedValue("oneTaskProcess", LONG_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedLongValue() {
        this.assertSetSerializedValue("oneTaskProcess", LONG_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedNullTypeValue() {
        this.assertGetSerializedValue("oneTaskProcess", NULL_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedNullTypeValue() {
        this.assertSetSerializedValue("oneTaskProcess", NULL_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedStringValue() {
        this.assertGetSerializedValue("oneTaskProcess", STRING_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedStringValue() {
        this.assertSetSerializedValue("oneTaskProcess", STRING_VARIABLE_SPEC);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetMalformedVariableType() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        try {
            this.runtimeService.setVariableFromSerialized(instance.getId(), "aName", null, "No Valid Type", null);
            SerializedVariablesTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetNullVariableType() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        try {
            this.runtimeService.setVariableFromSerialized(instance.getId(), "aName", null, null, null);
            SerializedVariablesTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedNullValue() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariableFromSerialized(instance.getId(), "aName", null, ProcessEngineVariableType.STRING.getName(), null);
        VariableInstance variableInstance = this.getVariableInstance("aName");
        SerializedVariablesTest.assertNotNull((Object)variableInstance);
        SerializedVariablesTest.assertEquals((String)ProcessEngineVariableType.STRING.getName(), (String)variableInstance.getTypeName());
        SerializedVariablesTest.assertNull((Object)variableInstance.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedValueWithNullConfiguration() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariableFromSerialized(instance.getId(), "aName", (Object)"a String Value", ProcessEngineVariableType.STRING.getName(), null);
        VariableInstance variableInstance = this.getVariableInstance("aName");
        SerializedVariablesTest.assertNotNull((Object)variableInstance);
        SerializedVariablesTest.assertNotNull((Object)variableInstance.getSerializedValue().getConfig());
        SerializedVariablesTest.assertTrue((boolean)variableInstance.getSerializedValue().getConfig().isEmpty());
    }

    public void testSetSerializedValueForNonExistingExecution() {
        try {
            this.runtimeService.setVariableFromSerialized("a non existing id", "aName", (Object)"aValue", ProcessEngineVariableType.STRING.getName(), null);
            SerializedVariablesTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testUpdateSerializedVariable() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(instance.getId(), "aVariable", (Object)"aStringValue");
        this.runtimeService.setVariableFromSerialized(instance.getId(), "aVariable", (Object)"anotherStringValue", ProcessEngineVariableType.STRING.getName(), null);
        VariableInstance variableInstance = this.getVariableInstance("aVariable");
        SerializedVariablesTest.assertNotNull((Object)variableInstance);
        SerializedVariablesTest.assertEquals((Object)"anotherStringValue", (Object)variableInstance.getValue());
        SerializedVariablesTest.assertEquals((String)ProcessEngineVariableType.STRING.getName(), (String)variableInstance.getTypeName());
        this.runtimeService.setVariableFromSerialized(instance.getId(), "aVariable", (Object)42, ProcessEngineVariableType.INTEGER.getName(), null);
        variableInstance = this.getVariableInstance("aVariable");
        SerializedVariablesTest.assertNotNull((Object)variableInstance);
        SerializedVariablesTest.assertEquals((Object)42, (Object)variableInstance.getValue());
        SerializedVariablesTest.assertEquals((String)ProcessEngineVariableType.INTEGER.getName(), (String)variableInstance.getTypeName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testSetSerializedValueLocal() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess");
        String subprocessExecutionId = ((Task)this.taskService.createTaskQuery().singleResult()).getExecutionId();
        SerializedVariablesTest.assertFalse((boolean)instance.getId().equals(subprocessExecutionId));
        this.runtimeService.setVariableFromSerialized(subprocessExecutionId, "aVariable", (Object)"aValue", ProcessEngineVariableType.STRING.getName(), null);
        VariableInstance variableInstance = this.getVariableInstance("aVariable");
        SerializedVariablesTest.assertNotNull((Object)variableInstance);
        SerializedVariablesTest.assertEquals((String)instance.getId(), (String)variableInstance.getExecutionId());
        this.runtimeService.setVariableLocalFromSerialized(subprocessExecutionId, "aLocalVariable", (Object)"anothervalue", ProcessEngineVariableType.STRING.getName(), null);
        variableInstance = this.getVariableInstance("aLocalVariable");
        SerializedVariablesTest.assertNotNull((Object)variableInstance);
        SerializedVariablesTest.assertEquals((String)subprocessExecutionId, (String)variableInstance.getExecutionId());
    }

    @Deployment
    public void testSetSerializedValueFromDelegate() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variableToSet", "testVar");
        this.runtimeService.startProcessInstanceByKey("testProcess", vars);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetNonNullSerializedValueForNullType() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        try {
            this.runtimeService.setVariableFromSerialized(instance.getId(), "aVar", (Object)"a non-null value", ProcessEngineVariableType.NULL.getName(), null);
            SerializedVariablesTest.fail((String)"should fail as non-null value is not allowed for null type");
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedValueForNullVariable() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        try {
            this.runtimeService.setVariableFromSerialized(instance.getId(), null, (Object)"value", ProcessEngineVariableType.STRING.getName(), null);
            SerializedVariablesTest.fail((String)"should fail as null is not allowed as variable name");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void assertGetSerializedValue(String processKey, VariableSpec variableSpec) {
        this.runtimeService.startProcessInstanceByKey(processKey, this.newMap(variableSpec.getName(), variableSpec.getValue()));
        VariableInstance variableInstance = this.getVariableInstance(variableSpec.getName());
        SerializedVariableValue serializedValue = variableInstance.getSerializedValue();
        SerializedVariablesTest.assertEquals((Object)variableSpec.getSerializedValue(), (Object)serializedValue.getValue());
        SerializedVariablesTest.assertEquals(variableSpec.getConfiguration(), (Object)serializedValue.getConfig());
    }

    public void assertSetSerializedValue(String processKey, VariableSpec variableSpec) {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(processKey);
        this.runtimeService.setVariableFromSerialized(instance.getId(), variableSpec.getName(), variableSpec.getSerializedValue(), variableSpec.getVariableTypeName(), variableSpec.getConfiguration());
        VariableInstance variableInstance = this.getVariableInstance(variableSpec.getName());
        SerializedVariablesTest.assertEquals((String)variableSpec.getName(), (String)variableInstance.getName());
        SerializedVariablesTest.assertEquals((Object)variableSpec.getValue(), (Object)variableInstance.getValue());
        SerializedVariablesTest.assertEquals((String)variableSpec.getVariableTypeName(), (String)variableInstance.getTypeName());
        SerializedVariablesTest.assertEquals((String)variableSpec.getValueTypeName(), (String)variableInstance.getValueTypeName());
        SerializedVariablesTest.assertEquals((boolean)variableSpec.getStoresCustomObjects(), (boolean)variableInstance.storesCustomObjects());
        SerializedVariableValue serializedValue = variableInstance.getSerializedValue();
        SerializedVariablesTest.assertEquals((Object)variableSpec.getSerializedValue(), (Object)serializedValue.getValue());
        SerializedVariablesTest.assertEquals(variableSpec.getConfiguration(), (Object)serializedValue.getConfig());
    }

    protected VariableInstance getVariableInstance(String name) {
        return (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(name).singleResult();
    }

    protected static byte[] toExpectedBytes(Object o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream ois = null;
        try {
            ois = new ObjectOutputStream(baos);
            ois.writeObject(o);
        }
        catch (IOException e) {
            try {
                throw new ProcessEngineException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(ois);
                throw throwable;
            }
        }
        IoUtil.closeSilently((OutputStream)ois);
        return baos.toByteArray();
    }

    protected Map<String, Object> newMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }
}

