/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.variables;

import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.PersistentVariableInstance;
import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.test.examples.variables.VariableAssertionUtil;
import org.junit.Assert;

public class SetSerializedVariablesDelegate
implements JavaDelegate {
    public void execute(DelegateExecution execution) throws Exception {
        String variableName = (String)execution.getVariable("variableToSet");
        execution.setVariableFromSerialized(variableName, (Object)"test", ProcessEngineVariableType.STRING.getName(), null);
        PersistentVariableInstance variable = (PersistentVariableInstance)execution.getVariableInstance(variableName);
        Assert.assertEquals((Object)variableName, (Object)variable.getName());
        VariableAssertionUtil.assertVariableHasValueAndType(variable, "test", ProcessEngineVariableType.STRING.getName());
        execution.setVariableFromSerialized(variableName, (Object)"another Value", ProcessEngineVariableType.STRING.getName(), null);
        Assert.assertEquals((Object)variableName, (Object)variable.getName());
        VariableAssertionUtil.assertVariableHasValueAndType(variable, "another Value", ProcessEngineVariableType.STRING.getName());
        execution.setVariableFromSerialized(variableName, (Object)42, ProcessEngineVariableType.INTEGER.getName(), null);
        Assert.assertEquals((Object)variableName, (Object)variable.getName());
        VariableAssertionUtil.assertVariableHasValueAndType(variable, 42, ProcessEngineVariableType.INTEGER.getName());
    }
}

